/*
 * Decompiled with CFR 0.152.
 */
package jmce.sim;

import jmce.sim.AbstractPeripheral;
import jmce.sim.CPU;
import jmce.sim.Memory;
import jmce.sim.MemoryReadListener;
import jmce.sim.MemoryWriteListener;
import jmce.sim.ResetListener;
import jmce.sim.SIMException;
import jmce.sim.Serial;
import jmce.sim.terminal.Terminal;
import jmce.util.FastArray;
import jmce.util.Hex;
import jmce.util.Logger;
import jmce.util.Timeout;

public final class SysKit
extends AbstractPeripheral
implements MemoryReadListener,
MemoryWriteListener,
ResetListener {
    private static Logger log = Logger.getLogger(SysKit.class);
    public static final int SYSKIT_CMD_CHECK = 105;
    public static final int SYSKIT_CMD_GETVER = 1;
    public static final int SYSKIT_CMD_RESKIT = 2;
    public static final int SYSKIT_CMD_DELAY = 3;
    public static final int SYSKIT_CMD_TSTART = 4;
    public static final int SYSKIT_CMD_TSTOP = 5;
    public static final int SYSKIT_CMD_PRTVER = 6;
    public static final int SYSKIT_CMD_DEBUG = 7;
    public static final int SYSKIT_CMD_NONE = 255;
    public static final int SYSKIT_VERSION = 1;
    protected int port = 240;
    private int count;
    private int cmd = 255;
    private FastArray<Timeout> timers = null;
    private Serial console = null;

    public SysKit() {
        this.setName("SysKit");
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public void registerCPU(CPU cpu) throws SIMException {
        super.registerCPU(cpu);
        cpu.addIOReadListener(this.port, this);
        cpu.addIOWriteListener(this.port, this);
        cpu.addResetListener(this);
        Terminal t = (Terminal)cpu.getHardwareTree(Serial.class, Terminal.class);
        if (t != null) {
            this.console = (Serial)t.getParent();
        }
        if (this.console == null) {
            log.info("No Terminal installed in " + cpu);
        }
    }

    @Override
    public void reset(CPU cpu) throws SIMException {
        this.reskit();
    }

    @Override
    public int readMemory(Memory m, int address, int v) throws SIMException {
        switch (this.cmd) {
            default: {
                log.info("Unknown read command " + Hex.formatByte(this.cmd));
                this.cmd = 255;
                v = 255;
                break;
            }
            case 1: {
                v = 1;
                this.cmd = 255;
                break;
            }
            case 105: {
                v = this.count == 0 ? 105 : 150;
                if (++this.count < 2) break;
                this.cmd = 255;
            }
        }
        return v;
    }

    private void newCommand(int v) throws SIMException {
        this.count = 0;
        switch (v) {
            default: {
                log.info("Unknown new command " + Hex.formatByte(v));
                break;
            }
            case 7: {
                this.cpu.setTill(this.cpu.pc());
                break;
            }
            case 5: {
                if (this.timers.getSize() > 0) {
                    Timeout t = this.timers.get(this.timers.getSize() - 1);
                    this.timers.remove(this.timers.getSize() - 1);
                    String s = "Timer # " + (this.timers.getSize() + 1) + " = " + t.getElapsed() + " millis elapsed";
                    log.info(s);
                    this.println(s);
                    break;
                }
                log.info("Stop timer without start!");
                break;
            }
            case 4: {
                Timeout t = new Timeout();
                this.timers.add(t);
                log.info("Start timer # " + this.timers.getSize());
                break;
            }
            case 1: 
            case 105: {
                this.cmd = v;
                break;
            }
            case 2: {
                this.reskit();
                break;
            }
            case 3: {
                this.idle();
                break;
            }
            case 6: {
                this.println(this.toString());
            }
        }
    }

    private void reskit() {
        this.cmd = 255;
        this.timers = new FastArray();
    }

    @Override
    public void writeMemory(Memory m, int address, int v, int oldValue) throws SIMException {
        switch (this.cmd) {
            case 255: {
                this.newCommand(v);
            }
        }
    }

    public void print(Object o) throws SIMException {
        String s = String.valueOf(o);
        for (int i = 0; i < s.length(); ++i) {
            this.putchar(s.charAt(i));
        }
    }

    public void println() throws SIMException {
        this.print("\r\n");
    }

    public void println(Object o) throws SIMException {
        String s = String.valueOf(o);
        this.print(s + "\r\n");
    }

    public void putchar(int c) throws SIMException {
        if (this.console != null) {
            this.console.write(c);
        }
    }

    @Override
    public String toString() {
        return "SysKit Ver. 1 at " + Hex.formatWord(this.port);
    }
}

