/*
 * Decompiled with CFR 0.152.
 */
package jmce.sim.cpm;

import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import jmce.sim.Disk;
import jmce.sim.cpm.CpmFile;
import jmce.sim.cpm.DPB;
import jmce.sim.cpm.FCB;
import jmce.util.FastArray;
import jmce.util.Logger;

public class CpmDisk {
    private static Logger log = Logger.getLogger(CpmDisk.class);
    private Disk disk;
    private DPB dpb;
    private boolean[] directoryUsed;
    private boolean[] blockUsed;
    private byte[] fcbBuffer = new byte[128];
    private byte[] block;
    private FastArray<CpmFile> files = new FastArray();

    public CpmDisk(DPB dpb, Disk disk) {
        this.dpb = dpb;
        this.disk = disk;
        this.directoryUsed = new boolean[dpb.drm + 1];
        this.blockUsed = new boolean[dpb.dsm + 1];
        this.block = new byte[this.getBlockSize()];
    }

    public void format() throws Exception {
        int i;
        for (i = 0; i <= this.dpb.getOFF(); ++i) {
            this.disk.setTrack(i);
            this.disk.format();
        }
        for (i = 0; i < this.block.length; ++i) {
            this.block[i] = -27;
        }
        for (i = 0; i < this.getNumDirBlock() * 2; ++i) {
            this.writeBlock(i, this.block);
        }
    }

    public CpmFile getFileAt(int index) {
        return this.files.get(index);
    }

    public int getFileCount() {
        return this.files.getSize();
    }

    private CpmFile searchFileException(int user, String name) throws Exception {
        CpmFile file = this.searchFile(user, name);
        if (file == null) {
            throw new Exception("File not found " + user + ":" + name);
        }
        return file;
    }

    private CpmFile searchFile(int user, String name) {
        for (int i = 0; i < this.getFileCount(); ++i) {
            CpmFile file = this.getFileAt(i);
            if (file.user != user || !file.name.equals(name)) continue;
            return file;
        }
        return null;
    }

    private int getFCBBlockLength() {
        return this.dpb.dsm < 256 ? 1 : 2;
    }

    private int getFCBBlockCount() {
        return 16 / this.getFCBBlockLength();
    }

    private int getFCBBlock(FCB fcb, int block) {
        if (this.getFCBBlockLength() == 1) {
            return fcb.getBlockByte(block);
        }
        return fcb.getBlockWord(block);
    }

    private void putFCBBlock(FCB fcb, int n, int block) {
        if (this.getFCBBlockLength() == 1) {
            fcb.setBlockByte(n, block);
        } else {
            fcb.setBlockWord(n, block);
        }
    }

    private void writeFCB(int dir, FCB fcb) throws Exception {
        int offset = dir * 32;
        int sector = offset / 128;
        this.readSector(sector, this.fcbBuffer);
        fcb.getBuffer(this.fcbBuffer, offset %= 128);
        this.writeSector(sector, this.fcbBuffer);
    }

    private void readFCB(int dir, FCB fcb) throws Exception {
        int offset = dir * 32;
        int sector = offset / 128;
        this.readSector(sector, this.fcbBuffer);
        fcb.setBuffer(this.fcbBuffer, offset %= 128);
    }

    public void writeSector(int secno, byte[] buffer) throws Exception {
        int track = secno / this.dpb.getSPT() + this.dpb.getOFF();
        int sector = secno % this.dpb.getSPT() + 1;
        sector = this.dpb.translateSector(sector);
        this.writeSector(track, sector, buffer);
    }

    public void writeSector(int track, int sector, byte[] buffer) throws Exception {
        System.arraycopy(buffer, 0, this.disk.getBuffer(), 0, 128);
        this.disk.setTrack(track);
        this.disk.setHead(0);
        this.disk.setSector(sector);
        this.disk.write();
    }

    public void readSector(int track, int sector, byte[] buffer) throws Exception {
        this.disk.setTrack(track);
        this.disk.setHead(0);
        this.disk.setSector(sector);
        this.disk.read();
        System.arraycopy(this.disk.getBuffer(), 0, buffer, 0, 128);
    }

    public void readSector(int secno, byte[] buffer) throws Exception {
        int track = secno / this.dpb.getSPT() + this.dpb.getOFF();
        int sector = secno % this.dpb.getSPT() + 1;
        sector = this.dpb.translateSector(sector);
        this.readSector(track, sector, buffer);
    }

    public int getNumDirBlock() {
        int count = 0;
        for (int i = 0; i < 8; ++i) {
            int mask = 1 << i;
            if ((this.dpb.getAL0() & mask) != 0) {
                ++count;
            }
            if ((this.dpb.getAL1() & mask) == 0) continue;
            ++count;
        }
        return count;
    }

    public void mount() throws Exception {
        int i;
        if (this.dpb.getEXM() != 0) {
            throw new Exception("DPB.EXM=" + this.dpb.getEXM() + " not supported");
        }
        FCB fcb = new FCB();
        this.disk.mount();
        for (i = 0; i < this.blockUsed.length; ++i) {
            this.blockUsed[i] = false;
        }
        for (i = 0; i < 8; ++i) {
            if ((this.dpb.getAL0() & 1 << 7 - i) != 0) {
                this.blockUsed[i] = true;
            }
            if ((this.dpb.getAL1() & 1 << 7 - i) == 0) continue;
            this.blockUsed[8 + i] = true;
        }
        this.files.clear();
        for (i = 0; i <= this.dpb.drm; ++i) {
            int b;
            this.readFCB(i, fcb);
            if (fcb.isDeleted()) {
                this.directoryUsed[i] = false;
                continue;
            }
            int user = fcb.getUser();
            fcb.getEX();
            fcb.getRC();
            this.directoryUsed[i] = true;
            if (user > 31) continue;
            String fileName = fcb.getFileName();
            CpmFile file = this.searchFile(user, fileName);
            if (file == null) {
                file = new CpmFile(user, fileName);
                file.setAttributeGlobal(fcb.getAttributeGlobal());
                file.setAttributeFifo(fcb.getAttributeFifo());
                file.setAttributeReadOnly(fcb.getAttributeReadOnly());
                file.setAttributeArchive(fcb.getAttributeArchive());
                this.files.add(file);
            }
            file.addFCB(i);
            for (int j = 0; j < this.getFCBBlockCount() && (b = this.getFCBBlock(fcb, j)) != 0; ++j) {
                this.blockUsed[b] = true;
                file.addBlock(b);
            }
        }
    }

    public int getNumBlockUsed() {
        int block = 0;
        for (int i = 0; i < this.blockUsed.length; ++i) {
            if (!this.blockUsed[i]) continue;
            ++block;
        }
        return block;
    }

    int getBlockSize() {
        return (this.dpb.getBLM() + 1) * 128;
    }

    public int getNumDirectoryUsed() {
        int dir = 0;
        for (int i = 0; i < this.directoryUsed.length; ++i) {
            if (!this.directoryUsed[i]) continue;
            ++dir;
        }
        return dir;
    }

    public void stat(String name, int value, String unit) {
        while (name.length() < 32) {
            name = " " + name;
        }
        String s = "" + value;
        while (s.length() < 10) {
            s = " " + s;
        }
        log.info(name + " = " + s + " " + unit);
    }

    private void stat(String name, int value) {
        this.stat(name, value, "");
    }

    public void stat() {
        this.stat("Reserved track", this.dpb.getOFF());
        this.stat("Total directory", this.dpb.drm + 1);
        this.stat("Directory used", this.getNumDirectoryUsed());
        this.stat("Directory free", this.dpb.drm + 1 - this.getNumDirectoryUsed());
        int usedBlock = this.getNumBlockUsed();
        this.stat("Block size", this.getBlockSize(), "Bytes");
        this.stat("Space configured ", this.dpb.dsm + 1, "Block");
        this.stat("Space used", usedBlock, "Block");
        this.stat("Space available", this.dpb.dsm + 1 - usedBlock, "Block");
        this.stat("Space configured", (this.dpb.dsm + 1) * this.getBlockSize() / 1024, "KB");
        this.stat("Space used", usedBlock * this.getBlockSize() / 1024, "KB");
        this.stat("Space free", (this.dpb.dsm + 1 - usedBlock) * this.getBlockSize() / 1024, "KB");
    }

    public void readBlock(int block, byte[] buffer) throws Exception {
        int sector = (this.dpb.blm + 1) * block;
        for (int i = 0; i <= this.dpb.blm; ++i) {
            this.readSector(sector++, this.fcbBuffer);
            System.arraycopy(this.fcbBuffer, 0, buffer, i * 128, 128);
        }
    }

    public void writeBlock(int block, byte[] buffer) throws Exception {
        int sector = (this.dpb.blm + 1) * block;
        for (int i = 0; i <= this.dpb.blm; ++i) {
            System.arraycopy(buffer, i * 128, this.fcbBuffer, 0, 128);
            this.writeSector(sector++, this.fcbBuffer);
        }
    }

    private int allocateBlock() throws Exception {
        for (int i = 0; i < this.block.length; ++i) {
            if (this.blockUsed[i]) continue;
            this.blockUsed[i] = true;
            return i;
        }
        throw new Exception("Out of disk space");
    }

    private int allocateFCB() throws Exception {
        for (int i = 0; i < this.directoryUsed.length; ++i) {
            if (this.directoryUsed[i]) continue;
            this.directoryUsed[i] = true;
            return i;
        }
        throw new Exception("No free FCB entry");
    }

    public int getRecordForFCB() {
        return (this.dpb.exm + 1) * 128;
    }

    public void putFile(int user, String name, InputStream is) throws Exception {
        int byteCount;
        FCB fcb = new FCB();
        int blockCount = 0;
        int record = 0;
        CpmFile file = this.searchFile(user, name);
        if (file != null) {
            throw new Exception(name + " Already exist");
        }
        file = new CpmFile(user, name);
        fcb.clear();
        fcb.setUser(user);
        fcb.setFileName(name);
        fcb.setEX(0);
        fcb.setRC(0);
        int entry = this.allocateFCB();
        this.files.add(file);
        this.writeFCB(entry, fcb);
        file.addFCB(entry);
        while ((byteCount = is.read(this.block, 0, this.getBlockSize())) > 0) {
            for (int i = byteCount; i < this.getBlockSize(); ++i) {
                this.block[i] = 26;
            }
            int recordCount = (byteCount + 128 - 1) / 128;
            while (recordCount > 0) {
                if (blockCount >= this.getFCBBlockCount()) {
                    entry = this.allocateFCB();
                    fcb.clearBlocks();
                    fcb.setRC(0);
                    fcb.setEX(fcb.getEX() + 1);
                    this.writeFCB(entry, fcb);
                    file.addFCB(entry);
                    blockCount = 0;
                }
                int blockNo = this.allocateBlock();
                this.putFCBBlock(fcb, blockCount++, blockNo);
                record = recordCount > this.dpb.blm + 1 ? this.dpb.blm + 1 : recordCount;
                recordCount -= record;
                record += fcb.getRC();
                if ((record &= 0xFF) > 128) {
                    fcb.setEX(fcb.getEX() + 1);
                    if (record > 128) {
                        record -= 128;
                    }
                }
                fcb.setRC(record);
                this.writeFCB(entry, fcb);
                file.addBlock(blockNo);
                this.writeBlock(blockNo, this.block);
            }
        }
    }

    public int getFileSize(CpmFile file) throws Exception {
        int size = 0;
        FCB fcb = new FCB();
        for (int i = 0; i < file.getFCBCount(); ++i) {
            this.readFCB(file.getFCBAt(i), fcb);
            int ex = fcb.getEX() & 0x1F & ~this.dpb.exm;
            int record = fcb.getRC() & 0xFF;
            size = ex * 128 + ((this.dpb.exm & fcb.getEX()) + 1) * 128 - (128 - record);
        }
        return size;
    }

    public void getFile(int user, String name, String to) throws Exception {
        FileOutputStream os = new FileOutputStream(to);
        this.getFile(user, name, os);
        os.close();
    }

    public void getFile(int user, String name, OutputStream os) throws Exception {
        CpmFile file = this.searchFileException(user, name);
        this.getFile(file, os);
    }

    public void getFile(CpmFile file, String name) throws Exception {
        FileOutputStream os = new FileOutputStream(name);
        this.getFile(file, os);
        os.close();
    }

    public void getFile(CpmFile file, OutputStream os) throws Exception {
        int length = this.getFileSize(file) * 128;
        for (int i = 0; i < file.getBlockCount(); ++i) {
            this.readBlock(file.getBlockAt(i), this.block);
            int count = this.getBlockSize();
            if (length < count) {
                count = length;
            }
            os.write(this.block, 0, count);
            length -= count;
        }
    }

    public void deleteFile(int user, String name) throws Exception {
        CpmFile file = this.searchFileException(user, name);
        for (int i = 0; i < file.getBlockCount(); ++i) {
            this.blockUsed[file.getBlockAt((int)i)] = false;
        }
        FCB fcb = new FCB();
        for (int i = 0; i < file.getFCBCount(); ++i) {
            int entry = file.getFCBAt(i);
            this.readFCB(entry, fcb);
            fcb.setDeleted();
            this.writeFCB(entry, fcb);
            this.directoryUsed[entry] = false;
        }
        this.files.remove(file);
    }

    public void umount() throws Exception {
        this.disk.dismount();
    }

    public String toString() {
        return "CP/M Disk " + this.disk;
    }
}

