/*
 * Decompiled with CFR 0.152.
 */
package jmce.sim.cpu;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import jmce.sim.LoadInfo;
import jmce.sim.Memory;
import jmce.sim.SIMException;
import jmce.sim.SIMIOException;
import jmce.sim.cpu.AbstractLoader;
import jmce.util.Hex;

public class IntelLoader
extends AbstractLoader {
    public IntelLoader(String ext) {
        super(ext);
    }

    @Override
    public void load(Memory m, String name, int base, LoadInfo info) throws SIMException {
        try {
            String line;
            BufferedReader rd = new BufferedReader(new FileReader(name));
            int start = -1;
            int end = -1;
            while ((line = rd.readLine()) != null) {
                int i;
                if (!line.startsWith(":")) {
                    throw new SIMIOException(name, " is not a valid intel file");
                }
                int lenData = Hex.getByte(line, 1);
                int address = Hex.getWord(line, 3);
                int type = Hex.getByte(line, 7);
                int chksum = lenData + address / 256 + address + type;
                for (i = 0; i < lenData + 1; ++i) {
                    chksum += Hex.getByte(line, 9 + i * 2);
                }
                if ((chksum &= 0xFF) != 0) {
                    throw new SIMException("Invalid chksum " + Hex.formatByte(chksum) + " in " + line);
                }
                if (type == 1) break;
                if (type == 3) continue;
                if (type != 0) {
                    throw new SIMException("Unsupported record type " + type);
                }
                if (address < start || start == -1) {
                    start = address;
                }
                if (address + lenData - 1 > end || end == -1) {
                    end = address + lenData - 1;
                }
                for (i = 0; i < lenData; ++i) {
                    m.setMemory(address + i, Hex.getByte(line, 9 + i * 2));
                }
            }
            info.start = start;
            info.end = end;
            rd.close();
        }
        catch (IOException e) {
            throw new SIMIOException(name, " Reading");
        }
    }
}

