/*
 * Decompiled with CFR 0.152.
 */
package jmce.sim.memory;

import java.lang.reflect.Array;
import jmce.sim.AbstractPeripheral;
import jmce.sim.Memory;
import jmce.sim.MemoryException;
import jmce.sim.MemoryReadListener;
import jmce.sim.MemoryWriteListener;
import jmce.sim.SIMException;
import jmce.util.FastArray;
import jmce.util.Hex;
import jmce.util.Logger;

public abstract class AbstractMemory
extends AbstractPeripheral
implements Memory {
    private static Logger log = Logger.getLogger(AbstractMemory.class.getName());
    protected FastArray<AbstractMemory> vms = new FastArray();
    private boolean[] rol;
    private FastArray<MemoryWriteListener> mwl = new FastArray();
    private FastArray<MemoryReadListener> mrl = new FastArray();
    private FastArray<MemoryWriteListener>[] mwls;
    private FastArray<MemoryReadListener>[] mrls;
    private String[] names = new String[0];
    protected int size;
    private int nameLength = 4;

    public AbstractMemory() {
        this("MEMORY");
    }

    public AbstractMemory(String name) {
        super(name);
    }

    protected abstract void set(int var1, int var2);

    protected abstract int get(int var1);

    @Override
    public final boolean getReadOnly(int add) {
        return this.rol[add];
    }

    @Override
    public final void setReadOnly() {
        this.setReadOnly(0, this.getSize());
    }

    @Override
    public final void setReadOnly(int a, int len) {
        Memory mm = this.mapMemory(a);
        a = this.mapAddress(a);
        if (mm != this) {
            mm.setReadOnly(a, len);
            return;
        }
        for (int i = 0; i < len; ++i) {
            this.rol[a + i] = true;
        }
    }

    @Override
    public final void setReadOnly(int add) {
        this.setReadOnly(add, 1);
    }

    @Override
    public final void addMemoryWriteListener(MemoryWriteListener l) {
        this.mwl.add(l);
    }

    @Override
    public final void removeMemoryWriteListener(MemoryWriteListener l) {
        this.mwl.remove(l);
    }

    @Override
    public final void addMemoryWriteListener(int a, MemoryWriteListener l) {
        Memory mm = this.mapMemory(a);
        a = this.mapAddress(a);
        if (mm != this) {
            mm.addMemoryWriteListener(a, l);
            return;
        }
        FastArray<MemoryWriteListener> m = this.mwls[a];
        if (m == null) {
            this.mwls[a] = m = new FastArray();
        }
        m.add(l);
    }

    @Override
    public void removeMemoryWriteListener(int a, MemoryWriteListener l) {
        FastArray<MemoryWriteListener> m = this.mwls[a];
        m.remove(l);
    }

    @Override
    public void addMemoryReadListener(MemoryReadListener l) {
        this.mrl.add(l);
    }

    @Override
    public void removeMemoryReadListener(MemoryReadListener l) {
        this.mrl.remove(l);
    }

    @Override
    public void removeMemoryReadListener(int a, MemoryReadListener l) {
        FastArray<MemoryReadListener> m = this.mrls[a];
        m.remove(l);
    }

    @Override
    public void addMemoryReadListener(int a, MemoryReadListener l) {
        Memory mm = this.mapMemory(a);
        a = this.mapAddress(a);
        if (mm != this) {
            mm.addMemoryReadListener(a, l);
            return;
        }
        FastArray<MemoryReadListener> m = this.mrls[a];
        if (m == null) {
            this.mrls[a] = m = new FastArray();
        }
        m.add(l);
    }

    @Override
    public int getMemoryWriteListenerCount() {
        return this.mwl.getSize();
    }

    @Override
    public int getMemoryWriteListenerCount(int a) {
        FastArray<MemoryWriteListener> m = this.mwls[a];
        return m == null ? 0 : m.getSize();
    }

    @Override
    public int getMemoryReadListenerCount() {
        return this.mrl.getSize();
    }

    @Override
    public int getMemoryReadListenerCount(int a) {
        FastArray<MemoryReadListener> m = this.mrls[a];
        return m == null ? 0 : m.getSize();
    }

    @Override
    public MemoryWriteListener getMemoryWriteListenerAt(int i) {
        return this.mwl.get(i);
    }

    @Override
    public MemoryReadListener getMemoryReadListenerAt(int i) {
        return this.mrl.get(i);
    }

    @Override
    public MemoryWriteListener getMemoryWriteListenerAt(int a, int i) {
        FastArray<MemoryWriteListener> m = this.mwls[a];
        return m.get(i);
    }

    @Override
    public MemoryReadListener getMemoryReadListenerAt(int a, int i) {
        FastArray<MemoryReadListener> m = this.mrls[a];
        return m.get(i);
    }

    @Override
    public void setSize(int newSize) {
        this.size = newSize;
        FastArray w = new FastArray();
        FastArray r = new FastArray();
        this.mwls = (FastArray[])Array.newInstance(w.getClass(), newSize);
        this.mrls = (FastArray[])Array.newInstance(r.getClass(), newSize);
        this.rol = new boolean[newSize];
        this.names = new String[newSize];
        this.nameLength = this.size > 0x1000000 ? 8 : (this.size > 0x100000 ? 7 : (this.size > 65536 ? 6 : (this.size > 65536 ? 5 : (this.size > 256 ? 4 : 2))));
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public final void setMemoryName(int a, String name) {
        Memory m = this.mapMemory(a);
        a = this.mapAddress(a);
        if (m != this) {
            m.setMemoryName(a, name);
            return;
        }
        this.names[a] = name;
    }

    @Override
    public final String getMemoryName(int a) {
        Memory m = this.mapMemory(a);
        a = this.mapAddress(a);
        if (m != this) {
            return m.getMemoryName(a);
        }
        if (this.names[a] == null) {
            this.names[a] = Hex.formatValue(a, this.nameLength);
        }
        return this.names[a];
    }

    public void addHardwareMemory(Memory m) {
        this.addMemory(m);
        this.addHardware(m);
    }

    public void addMemory(Memory v) {
        this.vms.add((AbstractMemory)v);
    }

    protected int getMemoryCount() {
        return this.vms.getSize();
    }

    protected AbstractMemory getMemoryAt(int i) {
        return this.vms.get(i);
    }

    @Override
    public boolean isBit(int a, int mask) throws MemoryException {
        return (this.get(a) & mask) != 0;
    }

    @Override
    public void setBit(int a, int mask) throws SIMException {
        int v = this.get(a) | mask;
        this.setMemory(a, v);
    }

    @Override
    public void clrBit(int a, int mask) throws SIMException {
        int v = this.get(a) & ~mask;
        this.setMemory(a, v);
    }

    @Override
    public final int getMemory(int add) throws SIMException {
        Memory mm = this.mapMemory(add);
        int a = this.mapAddress(add);
        if (mm != this) {
            int v = mm.getMemory(a);
            int i = this.mrl.getSize();
            while (--i >= 0) {
                v = this.mrl.get(i).readMemory(this, add, v);
            }
            return v;
        }
        int v = this.get(a);
        int i = this.mrl.getSize();
        while (--i >= 0) {
            v = this.mrl.get(i).readMemory(this, a, v);
        }
        FastArray<MemoryReadListener> m = this.mrls[a];
        if (m != null) {
            i = m.getSize();
            while (--i >= 0) {
                v = m.get(i).readMemory(this, a, v);
            }
        }
        return v;
    }

    @Override
    public final void setMemory(int add, int v) throws SIMException {
        Memory mm = this.mapMemory(add);
        int a = this.mapAddress(add);
        if (mm != this) {
            int i = this.mwl.getSize();
            while (--i >= 0) {
                this.mwl.get(i).writeMemory(this, add, v, -1);
            }
            mm.setMemory(a, v);
            return;
        }
        v &= 0xFF;
        int oldValue = this.get(a);
        if (this.rol[a] && this.cpu != null && this.cpu.isRunning()) {
            if (v != oldValue) {
                log.fine(this.getName() + " write ignored at " + this.getMemoryName(a) + " from " + Hex.formatByte(oldValue) + " to " + Hex.formatByte(v));
            }
        } else {
            this.set(a, v);
        }
        int i = this.mwl.getSize();
        while (--i >= 0) {
            this.mwl.get(i).writeMemory(this, a, v, oldValue);
        }
        FastArray<MemoryWriteListener> m = this.mwls[a];
        if (m != null) {
            i = m.getSize();
            while (--i >= 0) {
                m.get(i).writeMemory(this, a, v, oldValue);
            }
        }
    }

    protected Memory mapMemory(int a) {
        return this;
    }

    protected int mapAddress(int a) {
        return a;
    }

    @Override
    public String toString() {
        int size = this.getSize();
        if (size < 1024) {
            return this.getName() + " " + size + " bytes";
        }
        return this.getName() + " " + size / 1024 + " KB";
    }
}

