/*
 * Decompiled with CFR 0.152.
 */
package jmce.sim.memory;

import jmce.sim.CPU;
import jmce.sim.LoadInfo;
import jmce.sim.LoadableListener;
import jmce.sim.ResetListener;
import jmce.sim.SIMException;
import jmce.sim.memory.PlainMemory;
import jmce.util.FastArray;

public class LoadableMemory
extends PlainMemory
implements ResetListener {
    private String filename;
    private FastArray<LoadableListener> listeners = new FastArray();

    public LoadableMemory() {
        this.setReadOnly();
    }

    public LoadableMemory(String filename, int size) {
        this.setReadOnly();
        this.setFilename(filename);
        this.setSize(size);
    }

    public LoadableMemory(String name, int size, String file) {
        this.setReadOnly();
        this.setName(name);
        this.setSize(size);
        this.setFilename(file);
    }

    @Override
    public void registerCPU(CPU cpu) throws SIMException {
        super.registerCPU(cpu);
        cpu.addResetListener(this);
    }

    @Override
    public void reset(CPU cpu) throws SIMException {
        for (int i = 0; i < this.listeners.getSize(); ++i) {
            this.listeners.get(i).startLoad(cpu);
        }
        LoadInfo info = new LoadInfo();
        cpu.load(this.getFilename(), 0, info);
        for (int i = 0; i < this.listeners.getSize(); ++i) {
            this.listeners.get(i).endLoad(cpu, info);
        }
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getFilename() {
        return this.filename;
    }

    protected String filename() {
        return this.getFilename();
    }

    public void addLoadableListener(LoadableListener l) {
        this.listeners.add(l);
    }

    @Override
    public String toString() {
        return super.toString() + " [" + this.filename + "]";
    }
}

