/*
 * Decompiled with CFR 0.152.
 */
package jmce.sim.memory;

import java.util.Arrays;
import jmce.sim.SIMException;
import jmce.sim.memory.AbstractMemory;

public class PlainMemory
extends AbstractMemory {
    protected int[] memory = PlainMemory.allocMemory(0);
    protected int[] tmpMemory = PlainMemory.allocMemory(0);

    public PlainMemory() {
    }

    public PlainMemory(String name) {
        super(name);
    }

    public PlainMemory(String name, int size) {
        super(name);
        this.setSize(size);
    }

    @Override
    protected void set(int a, int v) {
        this.memory[a] = v;
    }

    @Override
    protected int get(int a) {
        return this.memory[a] & 0xFF;
    }

    @Override
    public void reset() throws SIMException {
        super.reset();
        Arrays.fill(this.memory, -1);
    }

    @Override
    public void setSize(int newSize) {
        super.setSize(newSize);
        if (this.memory.length != newSize) {
            this.tmpMemory = PlainMemory.allocMemory(newSize);
            int oldSize = this.memory.length;
            PlainMemory.copyMemory(this.memory, 0, this.tmpMemory, 0, oldSize > newSize ? newSize : oldSize);
            this.memory = this.tmpMemory;
        }
    }

    protected static int[] allocMemory(int size) {
        int[] m = new int[size];
        Arrays.fill(m, -1);
        return m;
    }

    protected static void copyMemory(int[] source, int soffset, int[] dest, int doffset, int size) {
        System.arraycopy(source, soffset, dest, doffset, size);
    }
}

