/*
 * Decompiled with CFR 0.152.
 */
package jmce.sim.serial;

import java.io.InputStream;
import java.io.OutputStream;
import jmce.sim.DeviceConsumer;
import jmce.sim.Hardware;
import jmce.sim.SIMException;
import jmce.sim.Serial;
import jmce.util.Logger;

public abstract class PolledSerial
extends Serial
implements Runnable,
DeviceConsumer<Integer> {
    private static final Logger log = Logger.getLogger(PolledSerial.class);
    private static final boolean logFine = false;
    private byte[] buffer = new byte[1024];
    private int count;
    private int i;
    protected long sent = 0L;
    protected long rcvd = 0L;
    private final int MIN_CONNECT_DELAY = 100;
    private final int MAX_CONNECT_DELAY = 3654000;
    protected boolean connected = false;
    protected InputStream is = null;
    protected OutputStream os = null;

    @Override
    public void consume(Integer c) throws SIMException {
        if (this.connected) {
            try {
                this.os.write(c);
                ++this.sent;
            }
            catch (Exception e) {
                log.info(e);
                this.close();
            }
        }
    }

    @Override
    public void init(Hardware parent) throws SIMException {
        super.init(parent);
        Thread t = new Thread(this);
        t.start();
    }

    protected void delay(int delay) {
        try {
            Thread.sleep(delay);
        }
        catch (Exception ignore) {
            log.info(ignore);
        }
    }

    protected synchronized void close() {
        if (this.connected) {
            log.info("Close");
        }
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (Exception ignore) {
                log.info(ignore);
            }
            this.is = null;
        }
        if (this.os != null) {
            try {
                this.os.close();
            }
            catch (Exception ignore) {
                log.info(ignore);
            }
            this.os = null;
        }
        this.connected = false;
        this.removeInputConsumer(this);
    }

    @Override
    public final void run() {
        while (true) {
            int delay = 100;
            while (!this.connected) {
                this.delay(delay);
                try {
                    this.connect();
                    delay = 100;
                }
                catch (Exception ex) {
                    this.close();
                    if ((delay *= 2) > 3654000) {
                        delay = 3654000;
                    }
                    log.fine(this + " " + ex.toString());
                }
            }
            if (this.connected) {
                log.info("Polling : " + this.toString());
            }
            this.addInputConsumer(this);
            while (this.connected) {
                try {
                    this.count = this.is.read(this.buffer);
                }
                catch (Exception ex) {
                    log.info(ex);
                    break;
                }
                if (this.count <= 0) continue;
                this.rcvd += (long)this.count;
                try {
                    this.i = 0;
                    while (this.i < this.count) {
                        this.write(this.buffer[this.i] & 0xFF);
                        ++this.i;
                    }
                }
                catch (SIMException e) {
                    log.info(e);
                    break;
                }
            }
            this.close();
        }
    }

    protected abstract void connect() throws Exception;
}

