/*
 * Decompiled with CFR 0.152.
 */
package jmce.sim.tape;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import jmce.sim.TapePulse;
import jmce.sim.tape.TapeData;
import jmce.sim.tape.TapeFileDecoder;

public class TapeFileC64
implements TapeFileDecoder {
    public static final int MULTIPLIER = 8;
    private int version;

    @Override
    public boolean isFileSupported(InputStream is) throws IOException {
        byte[] header = new byte[20];
        if (is.read(header) != 20) {
            return false;
        }
        String signature = new String(header, 0, 12);
        if (!signature.equals("C64-TAPE-RAW")) {
            return false;
        }
        this.version = header[12] & 0xFF;
        return true;
    }

    @Override
    public TapeData decode(BufferedInputStream is) throws IOException {
        int v;
        TapeData data = new TapeData(985248);
        while ((v = is.read()) != -1) {
            if (v == 0) {
                if (this.version == 0) {
                    v = 256;
                } else {
                    int b3;
                    int b2;
                    int b1 = is.read() & 0xFF;
                    v = (b1 + (b2 = is.read() & 0xFF) * 256 + (b3 = is.read() & 0xFF) * 256 * 256) / 8;
                    if (v > 100000) {
                        v = 100000;
                    }
                }
            }
            data.add(new TapePulse(v * 8));
        }
        return data;
    }

    public String toString() {
        return "C64 1.00";
    }
}

