/*
 * Decompiled with CFR 0.152.
 */
package jmce.sim.terminal;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.Timer;
import jmce.sim.Hardware;
import jmce.sim.SIMException;
import jmce.sim.SwingHardware;
import jmce.sim.terminal.AbstractCRT;

public class SwingCRT
extends AbstractCRT
implements SwingHardware {
    private final int TIME_REFRESH = 20;
    private final int TIME_BLINK = 500;
    private Image image = null;
    private FontMetrics fm;
    private Dimension size;
    private Dimension sizeChar;
    private Color color = new Color(0, 255, 0);
    private Color colorHi = new Color(255, 255, 255);
    private Timer timer1;
    private Timer timer2;
    private boolean blinkDisable = false;
    private JSwingCRT component = new JSwingCRT();
    private char[] line;

    public SwingCRT() {
        super("SwingCRT");
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    @Override
    public void destroy() throws SIMException {
        super.destroy();
        if (this.timer1 != null) {
            this.timer1.stop();
            this.timer1 = null;
        }
        if (this.timer2 != null) {
            this.timer2.stop();
            this.timer2 = null;
        }
        try {
            Thread.sleep(40L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void init(Hardware parent) throws SIMException {
        super.init(parent);
        this.line = new char[this.numCol];
        this.timer1 = new Timer(20, new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SwingCRT.this.screenChanged) return;
                boolean[] blArray = SwingCRT.this.lineChanged;
                synchronized (SwingCRT.this.lineChanged) {
                    SwingCRT.this.screenChanged = false;
                    SwingCRT.this.component.repaint();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        });
        this.timer1.setRepeats(true);
        this.timer1.start();
        this.timer2 = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingCRT.this.blinkDisable = !SwingCRT.this.blinkDisable;
                block2: for (int r = 0; r < SwingCRT.this.numRow; ++r) {
                    for (int c = 0; c < SwingCRT.this.numCol; ++c) {
                        try {
                            if ((SwingCRT.this.getAtt(r, c) & 8) == 0) continue;
                            SwingCRT.this.changedLine(r);
                            continue block2;
                        }
                        catch (Exception discard) {
                            // empty catch block
                        }
                    }
                }
            }
        });
        this.timer2.setRepeats(true);
        this.timer2.start();
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    class JSwingCRT
    extends JComponent
    implements KeyListener {
        private static final long serialVersionUID = 1L;

        public JSwingCRT() {
            this.enableEvents(8L);
            this.enableEvents(2056L);
            this.addKeyListener(this);
            this.setFocusable(true);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    JSwingCRT.this.requestFocusInWindow();
                }
            });
        }

        @Override
        public boolean hasFocus() {
            return true;
        }

        @Override
        public boolean isFocusable() {
            return true;
        }

        @Override
        public void keyPressed(KeyEvent e) {
            try {
                if (e.getKeyChar() == '\n' && e.getKeyChar() == e.getKeyCode()) {
                    try {
                        SwingCRT.this.terminal.write(e.getKeyCode() | 0x10000);
                    }
                    catch (Exception ignore) {}
                } else if (e.getKeyChar() == '\uffff') {
                    SwingCRT.this.terminal.write(e.getKeyCode() | 0x10000);
                } else {
                    SwingCRT.this.terminal.write(e.getKeyChar() & 0xFF);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public Dimension getPreferredSize() {
            if (SwingCRT.this.size == null) {
                Graphics g = this.getGraphics();
                g.setFont(SwingCRT.this.terminal.getFont());
                SwingCRT.this.fm = g.getFontMetrics();
                int width = 0;
                int height = SwingCRT.this.fm.getHeight();
                for (int i = 0; i < 256; ++i) {
                    if (SwingCRT.this.fm.charWidth(i) <= width) continue;
                    width = SwingCRT.this.fm.charWidth(i);
                }
                SwingCRT.this.sizeChar = new Dimension(width, height);
                SwingCRT.this.size = new Dimension(SwingCRT.this.numCol * width, SwingCRT.this.numRow * height);
            }
            return SwingCRT.this.size;
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public void paint(Graphics g) {
            if (SwingCRT.this.image == null) {
                SwingCRT.this.image = this.createImage(((SwingCRT)SwingCRT.this).size.width, ((SwingCRT)SwingCRT.this).size.height);
            }
            this.draw(SwingCRT.this.image.getGraphics());
            g.drawImage(SwingCRT.this.image, 0, 0, this);
        }

        public void drawLine(Graphics g, int att, int r, int c, int count) throws SIMException {
            int x = c * ((SwingCRT)SwingCRT.this).sizeChar.width;
            int y = ((SwingCRT)SwingCRT.this).sizeChar.height - SwingCRT.this.fm.getDescent() + r * ((SwingCRT)SwingCRT.this).sizeChar.height - 1;
            for (int i = 0; i < count; ++i) {
                ((SwingCRT)SwingCRT.this).line[i] = (char)SwingCRT.this.getChar(r, c + i);
            }
            g.setColor(this.getBackground(att));
            g.fillRect(x, ((SwingCRT)SwingCRT.this).sizeChar.height * r, count * ((SwingCRT)SwingCRT.this).sizeChar.width, ((SwingCRT)SwingCRT.this).sizeChar.height);
            g.setColor(this.getForeground(att));
            g.drawChars(SwingCRT.this.line, 0, count, x, y);
            if ((att & 4) != 0) {
                g.fillRect(x, ((SwingCRT)SwingCRT.this).sizeChar.height * (r + 1) - 4, ((SwingCRT)SwingCRT.this).sizeChar.width * count, 1);
            }
        }

        public Color getColor(int att) {
            Color c = SwingCRT.this.color;
            if ((att & 2) != 0) {
                c = SwingCRT.this.colorHi;
            }
            return c;
        }

        public Color getForeground(int att) {
            if ((att & 8) != 0 && SwingCRT.this.blinkDisable) {
                return this.getBackground(att);
            }
            return (att & 1) == 0 ? this.getColor(att) : Color.black;
        }

        public Color getBackground(int att) {
            return (att & 1) != 0 ? this.getColor(att) : Color.black;
        }

        public void drawLine(Graphics g, int r) {
            try {
                int c;
                int att = SwingCRT.this.getAtt(r, 0);
                int count = 0;
                for (c = 0; c < SwingCRT.this.numCol; ++c) {
                    if (att == SwingCRT.this.getAtt(r, c)) {
                        ++count;
                        continue;
                    }
                    this.drawLine(g, att, r, c - count, count);
                    count = 1;
                    att = SwingCRT.this.getAtt(r, c);
                }
                this.drawLine(g, att, r, c - count, count);
                if (r == SwingCRT.this.terminal.getRow() && SwingCRT.this.terminal.getCursor()) {
                    g.fillRect(((SwingCRT)SwingCRT.this).sizeChar.width * SwingCRT.this.terminal.getCol(), ((SwingCRT)SwingCRT.this).sizeChar.height * (SwingCRT.this.terminal.getRow() + 1) - 3, ((SwingCRT)SwingCRT.this).sizeChar.width, 2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void draw(Graphics g) {
            Insets insets = this.getInsets();
            g.translate(insets.left, insets.top);
            g.setFont(SwingCRT.this.terminal.getFont());
            for (int r = 0; r < SwingCRT.this.numRow; ++r) {
                if (!SwingCRT.this.lineChanged[r]) continue;
                SwingCRT.this.lineChanged[r] = false;
                this.drawLine(g, r);
            }
        }
    }
}

