/*
 * Decompiled with CFR 0.152.
 */
package jmce.sinclair.spectrum;

import java.awt.Component;
import javax.swing.JPanel;
import jmce.sim.AbstractPeripheral;
import jmce.sim.CPU;
import jmce.sim.Hardware;
import jmce.sim.Memory;
import jmce.sim.SIMException;
import jmce.sim.SIMSWException;
import jmce.sim.SwingHardware;
import jmce.sinclair.spectrum.KeyboardPanel;
import jmce.sinclair.spectrum.ScreenPanel;
import jmce.sinclair.spectrum.SpectrumConstants;
import jmce.sinclair.spectrum.SpectrumMemory;
import jmce.sinclair.spectrum.SwingKeyboard;
import jmce.util.Timer;
import jmce.util.TimerListener;

public class Screen
extends AbstractPeripheral
implements SwingHardware,
SpectrumConstants {
    Component comp = null;
    ScreenPanel sp = new ScreenPanel();
    private int scale = 1;
    private boolean keyboardVisible = false;
    private int border;

    public Screen() {
        this(1);
    }

    public Screen(int scale) {
        this.setName("Screen 256x192");
        this.setScale(scale);
    }

    public boolean getKeyboardVisible() {
        return this.keyboardVisible;
    }

    public void setKeyboardVisible(boolean b) {
        this.keyboardVisible = b;
    }

    public int getScale() {
        return this.scale;
    }

    public void setBorder(int border) {
        this.sp.setBorder(border);
    }

    public void setScale(int scale) {
        this.scale = scale;
        this.sp.setScale(scale);
    }

    @Override
    public Component getComponent() {
        return this.comp;
    }

    public void setMemory(Memory m) {
        this.sp.setMemory(m);
    }

    @Override
    public void registerCPU(CPU cpu) throws SIMException {
        super.registerCPU(cpu);
        SpectrumMemory m = (SpectrumMemory)cpu.getHardware(SpectrumMemory.class);
        if (m == null) {
            throw new SIMSWException("No SpectrumMemory installed!");
        }
        this.setMemory(m.getVideoMemory());
        Timer timer = new Timer(320, true, new TimerListener(){

            @Override
            public void timerExpired() {
                Screen.this.sp.updateBlink();
            }
        });
        cpu.addTimerMs(timer);
    }

    @Override
    public void init(Hardware parent) throws SIMException {
        JPanel p = new JPanel();
        p.add(this.sp);
        if (this.keyboardVisible) {
            p.add(new KeyboardPanel());
        }
        this.comp = p;
        if (this.getHardware((Class)SwingKeyboard.class) == null) {
            this.addHardware(new SwingKeyboard());
        }
        super.init(parent);
    }
}

