/*
 * Decompiled with CFR 0.152.
 */
package jmce.sinclair.spectrum;

import jmce.sim.CPU;
import jmce.sim.ResetListener;
import jmce.sim.SIMException;
import jmce.sinclair.spectrum.Screen;
import jmce.sinclair.spectrum.Speaker;
import jmce.sinclair.spectrum.SpectrumConstants;
import jmce.sinclair.spectrum.Tape;
import jmce.sinclair.spectrum.Timer;
import jmce.sinclair.spectrum.ZXSnapshot;
import jmce.zilog.z80.Z80;

public class Spectrum
extends Z80
implements SpectrumConstants,
ResetListener {
    private int ula;

    public Spectrum() {
        this.setClock(3500000L);
        this.setRealTime(true);
        this.addLoader(new ZXSnapshot());
        this.addResetListener(this);
    }

    @Override
    protected void initPeripherals() throws SIMException {
        Speaker spk;
        Screen scr;
        if (this.getHardware((Class)Timer.class) == null) {
            this.addHardware(new Timer());
        }
        if ((scr = (Screen)this.getHardware((Class)Screen.class)) == null) {
            scr = new Screen(2);
            this.addHardware(scr);
        }
        if ((spk = (Speaker)this.getHardware((Class)Speaker.class)) == null) {
            spk = new Speaker();
            this.addHardware(spk);
        }
        spk.setScreen(scr);
        Tape tape = (Tape)this.getHardware((Class)Tape.class);
        if (tape == null) {
            tape = new Tape();
            this.addHardware(tape);
        }
        super.initPeripherals();
    }

    public final boolean getTapeIn() {
        return (this.ula & 0x40) != 0;
    }

    public final void setTapeIn(boolean mode) {
        this.ula = mode ? (this.ula |= 0x40) : (this.ula &= 0xFFFFFFBF);
    }

    public final int getUla() {
        return this.ula;
    }

    @Override
    public void reset(CPU cpu) throws SIMException {
        this.ula = 0;
    }
}

