/*
 * Decompiled with CFR 0.152.
 */
package jmce.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.Timer;
import javax.swing.border.TitledBorder;
import jmce.Jmce;
import jmce.swing.Repaintable;
import jmce.util.Logger;
import jmce.util.RingBuffer;

public class Util {
    private static Logger log = Logger.getLogger(Util.class);
    static RingBuffer<Repaintable> cmps = new RingBuffer(1024);
    static int repaintDelay = 100;
    static Timer timer = null;
    public static final Font fontTitle = new Font("Monospaced", 1, 14);
    public static final Font fontLabel = new Font("Monospaced", 0, 12);
    private static Class defaultIconParent = Jmce.class;

    public static void setRepaintDelay(int n) {
        repaintDelay = n;
        if (timer != null) {
            timer.setDelay(repaintDelay);
        }
    }

    public static void repaintLater(Repaintable c) {
        if (!cmps.contains(c)) {
            cmps.put(c);
            if (timer == null) {
                timer = new Timer(repaintDelay, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        Util.repaints();
                    }
                });
            }
            if (!timer.isRunning()) {
                timer.start();
            }
        }
    }

    private static void repaints() {
        Repaintable r = cmps.get();
        while (r != null) {
            r.updateComponent();
            r = cmps.get();
        }
    }

    public static void setBox(JComponent j) {
        j.setBorder(BorderFactory.createEtchedBorder());
    }

    public static TitledBorder setTitle(JComponent j, String title) {
        return Util.setTitle(j, title, null);
    }

    public static TitledBorder setTitle(JComponent j, String title, Color c) {
        TitledBorder titled = BorderFactory.createTitledBorder(title);
        if (c != null) {
            titled.setTitleColor(c);
        }
        j.setBorder(titled);
        return titled;
    }

    public static Icon getIcon(String name) {
        return Util.getIcon(defaultIconParent, name);
    }

    public static Icon getIcon(Class parent, String name) {
        URL url = parent.getResource("images/" + name);
        if (url == null) {
            log.info("getIcon : Package=" + parent + " name=" + name + " - not found");
            return null;
        }
        ImageIcon icon = new ImageIcon(url);
        return icon;
    }

    public static void setLocationCenterTo(Component c, Container parent) {
        Point topLeft = parent.getLocationOnScreen();
        Dimension parentSize = parent.getSize();
        Dimension mySize = c.getSize();
        int x = parentSize.width > mySize.width ? (parentSize.width - mySize.width) / 2 + topLeft.x : topLeft.x;
        int y = parentSize.height > mySize.height ? (parentSize.height - mySize.height) / 2 + topLeft.y : topLeft.y;
        c.setLocation(x, y);
    }
}

