/*
 * Decompiled with CFR 0.152.
 */
package jmce.util;

public class Timeout {
    private long start;
    private long timeout;
    private boolean nano = false;

    public Timeout() {
        this(0L, false);
    }

    public Timeout(long n) {
        this(n, false);
    }

    public Timeout(boolean nano) {
        this(0L, nano);
    }

    public Timeout(long timeout, boolean nano) {
        this.timeout = timeout;
        this.nano = nano;
        this.restart();
    }

    private final long getTime() {
        return this.nano ? System.nanoTime() : System.currentTimeMillis();
    }

    public final void restart() {
        this.start = this.getTime();
    }

    public final long getElapsedEx() {
        return this.getTime() - this.start;
    }

    public final int getElapsed() {
        return (int)this.getElapsedEx();
    }

    public final boolean isExpired() {
        return (long)this.getElapsed() >= this.timeout;
    }

    public static void main(String[] argv) {
        int delay = 50;
        Timeout tms = new Timeout();
        Timeout tns = new Timeout(true);
        for (int i = 0; i < 10; ++i) {
            System.out.println("Test timeout $Id: Timeout.java 630 2011-06-09 07:12:05Z mviara $ # " + i);
            tms.restart();
            tns.restart();
            try {
                Thread.sleep(50L);
            }
            catch (Exception ignore) {
                // empty catch block
            }
            long n = tns.getElapsedEx();
            long m = tms.getElapsedEx();
            System.out.println("Sleep 50 as " + m + " ms and " + n + " ns");
        }
    }
}

