/*
 * Decompiled with CFR 0.152.
 */
package jmce.util;

import jmce.util.Logger;
import jmce.util.TimerListener;
import jmce.util.TimerManager;

public class Timer {
    private static Logger log = Logger.getLogger(Timer.class);
    static TimerManager timerManager = null;
    public static final int IDLE = 0;
    public static final int QUEUED = 1;
    public static final int READY = 2;
    public static final int CANCELLED = 3;
    int status;
    int remainingTime;
    int initialTime;
    boolean repeat;
    TimerListener target;
    TimerManager manager = null;

    Timer() {
        this(0, null);
    }

    public Timer(int time, boolean repeat, TimerListener run) {
        this.initialTime = time;
        this.target = run;
        this.status = 0;
        this.repeat = repeat;
    }

    public Timer(int time, TimerListener run) {
        this(time, false, run);
    }

    public boolean isRunning() {
        return this.status == 1 || this.status == 2;
    }

    public final boolean isRepeat() {
        return this.repeat;
    }

    public void setRepeat(boolean mode) {
        this.repeat = mode;
    }

    public long getTime() {
        return this.initialTime;
    }

    public void setTime(int t) {
        this.initialTime = t;
    }

    public final void cancel() {
        if (this.manager != null) {
            this.manager.remove(this);
        }
    }

    public final int getStatus() {
        return this.status;
    }

    public static void addTimer(Timer timer) {
        if (timerManager == null) {
            timerManager = new TimerManager("Standard timer");
            timerManager.start();
        }
        timerManager.add(timer);
    }

    public static Timer createTimer(int time, boolean repeat, TimerListener run) {
        Timer t = new Timer(time, repeat, run);
        Timer.addTimer(t);
        return t;
    }

    public static Timer createTimer(int time, TimerListener run) {
        return Timer.createTimer(time, false, run);
    }

    public static void main(String[] argv) {
        try {
            Timer.createTimer(1000, true, new TimerListener(){

                @Override
                public void timerExpired() {
                    log.info("Expired 1000");
                }
            });
            Timer.createTimer(2000, true, new TimerListener(){

                @Override
                public void timerExpired() {
                    log.info("Expired 2000");
                }
            });
            Timer.createTimer(5000, true, new TimerListener(){

                @Override
                public void timerExpired() {
                    log.info("Expired 5000");
                    Timer.createTimer(500, true, new TimerListener(){

                        @Override
                        public void timerExpired() {
                            log.info("Expired 500");
                        }
                    });
                }
            });
            Timer.createTimer(10030, true, new TimerListener(){

                @Override
                public void timerExpired() {
                    log.info("Expired 10030");
                    System.exit(0);
                }
            });
        }
        catch (Throwable e) {
            System.out.println(e);
            e.printStackTrace();
        }
    }

    public String toString() {
        return "Timer " + this.initialTime + " counter " + this.remainingTime + ", repeat " + this.repeat;
    }
}

