/*
 * Decompiled with CFR 0.152.
 */
package jmce.yaze;

import jmce.sim.CPU;
import jmce.sim.MemoryWriteListener;
import jmce.sim.ResetListener;
import jmce.sim.SIMException;
import jmce.sim.memory.BankedMemory;
import jmce.yaze.YazeConstants;

public class Memory
extends BankedMemory
implements YazeConstants,
MemoryWriteListener,
ResetListener {
    int page = 0;

    public Memory() {
        this.setName("MEMORY");
        this.setSize(65536);
        this.setNumBank(16);
        this.setPageSize(4096);
        this.setNumPage(16);
        this.setSharedStart(0);
        this.setSharedSize(0);
    }

    @Override
    public void registerCPU(CPU cpu) throws SIMException {
        super.registerCPU(cpu);
        cpu.addIOWriteListener(20, this);
        cpu.addIOWriteListener(21, this);
        cpu.addIOWriteListener(22, this);
        cpu.addResetListener(this);
    }

    @Override
    public void reset(CPU cpu) throws SIMException {
        this.initMmu();
    }

    @Override
    public void writeMemory(jmce.sim.Memory m, int address, int value, int oldValue) throws SIMException {
        switch (address) {
            case 20: {
                this.page = this.page & 0xFF00 | value;
                break;
            }
            case 21: {
                this.page = this.page & 0xFF | value << 8;
                break;
            }
            case 22: {
                this.setPageMap(this.getBank(), value, this.page);
                break;
            }
        }
    }
}

