/*
 * Decompiled with CFR 0.152.
 */
package jmce.z80pack;

import jmce.sim.CPU;
import jmce.sim.Memory;
import jmce.sim.MemoryReadListener;
import jmce.sim.MemoryWriteListener;
import jmce.sim.SIMException;
import jmce.sim.cpm.DPBZPHD;
import jmce.sim.disk.AbstractDiskController;
import jmce.util.Hex;
import jmce.util.Logger;
import jmce.z80pack.Z80PackConstants;

public class FDC
extends AbstractDiskController
implements Z80PackConstants,
MemoryReadListener,
MemoryWriteListener {
    private static Logger log = Logger.getLogger(FDC.class);
    private boolean commandInProcess = false;
    protected int commandResult = 0;
    private int dma = 0;

    public FDC() {
        this.setName("Z80Pack FDC");
    }

    @Override
    public void registerCPU(CPU cpu) throws SIMException {
        super.registerCPU(cpu);
        cpu.addIOReadListener(14, this);
        cpu.addIOWriteListener(10, this);
        cpu.addIOWriteListener(13, this);
        cpu.addIOWriteListener(11, this);
        cpu.addIOWriteListener(12, this);
        cpu.addIOWriteListener(17, this);
        cpu.addIOWriteListener(15, this);
        cpu.addIOWriteListener(16, this);
    }

    protected void setDma(int dma) {
        this.dma = dma;
    }

    private void diskio(int cmd) throws SIMException {
        this.commandInProcess = true;
        this.commandResult = 1;
        if (this.drive < 0 || this.drive >= this.getDiskCount()) {
            log.info("Disk not found");
            return;
        }
        byte[] buffer = this.disk.getBuffer();
        switch (cmd) {
            case 0: {
                this.cpu.setStatusLine('R');
                if (this.disk.read() != buffer.length) {
                    return;
                }
                for (int i = 0; i < buffer.length; ++i) {
                    this.cpu.setByte(this.dma + i, buffer[i] & 0xFF);
                }
                break;
            }
            case 1: {
                int i;
                this.cpu.setStatusLine('W');
                for (i = 0; i < buffer.length; ++i) {
                    buffer[i] = (byte)this.cpu.getByte(this.dma + i);
                }
                i = this.disk.write();
                if (i == buffer.length) break;
                return;
            }
            default: {
                return;
            }
        }
        this.commandResult = 0;
    }

    @Override
    public int readMemory(Memory m, int address, int value) throws SIMException {
        this.setLive();
        if (this.commandInProcess) {
            this.commandInProcess = false;
            return this.commandResult;
        }
        if (this.drive < 0 || this.drive >= this.getDiskCount()) {
            return 1;
        }
        return 0;
    }

    @Override
    public void writeMemory(Memory m, int address, int value, int oldValue) throws SIMException {
        this.setLive();
        switch (address) {
            case 10: {
                this.setDrive(value);
                break;
            }
            case 17: {
                int s = this.disk.getSector();
                s &= 0xFF;
                this.disk.setSector(s |= value << 8);
                break;
            }
            case 12: {
                int s = this.disk.getSector();
                s &= 0xFF00;
                this.disk.setSector(s |= value);
                break;
            }
            case 11: {
                this.disk.setTrack(value);
                break;
            }
            case 16: {
                this.dma &= 0xFF;
                this.dma |= value << 8;
                this.setDma(this.dma);
                break;
            }
            case 15: {
                this.dma &= 0xFF00;
                this.dma |= value;
                this.setDma(this.dma);
                break;
            }
            case 13: {
                this.diskio(value);
            }
        }
    }

    void addDirDiskZ80PackHD(String dir) {
        this.addDirDiskCPM(dir, new DPBZPHD());
    }

    void addImageDiskZ80PackHD(String name) {
        this.addImageDisk(name, new DPBZPHD());
    }

    @Override
    public String toString() {
        return "Z80Pack FDC AT 0x" + Hex.formatByte(10);
    }
}

