/*
 * Decompiled with CFR 0.152.
 */
package jmce.z80pack;

import jmce.intel.i8080.I8080;
import jmce.intel.i8080.INT;
import jmce.sim.AbstractPeripheral;
import jmce.sim.CPU;
import jmce.sim.Memory;
import jmce.sim.MemoryReadListener;
import jmce.sim.MemoryWriteListener;
import jmce.sim.ResetListener;
import jmce.sim.SIMException;
import jmce.util.TimerListener;
import jmce.z80pack.Z80PackConstants;

public class Timer
extends AbstractPeripheral
implements Z80PackConstants,
MemoryReadListener,
MemoryWriteListener,
ResetListener,
TimerListener {
    private INT irq;
    private int timerMode = 0;
    private jmce.util.Timer timer;

    public Timer() {
        this.setName("Timer 10 ms");
    }

    @Override
    public void registerCPU(CPU cpu) throws SIMException {
        super.registerCPU(cpu);
        cpu.addIOReadListener(27, this);
        cpu.addIOWriteListener(27, this);
        cpu.addResetListener(this);
        this.irq = new INT((I8080)cpu, "Timer");
        this.irq.setAutoReset(true);
        this.timer = new jmce.util.Timer(10, true, this);
    }

    @Override
    public int readMemory(Memory m, int address, int value) throws SIMException {
        return this.timerMode;
    }

    @Override
    public void writeMemory(Memory m, int address, int value, int oldValue) throws SIMException {
        this.timerMode = value;
        if (this.timerMode == 0) {
            this.timer.cancel();
        } else if (!this.timer.isRunning()) {
            this.cpu.addTimerMs(this.timer);
        }
    }

    @Override
    public void reset(CPU cpu) throws SIMException {
        this.timer.cancel();
    }

    @Override
    public void timerExpired() throws SIMException {
        this.irq.setActive(true);
    }
}

