/*
 * Decompiled with CFR 0.152.
 */
package jmce;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import jmce.JDebug;
import jmce.Monitor;
import jmce.Svnversion;
import jmce.sim.AbstractHardware;
import jmce.sim.CPU;
import jmce.sim.Console;
import jmce.sim.Device;
import jmce.sim.Disk;
import jmce.sim.DiskController;
import jmce.sim.ExceptionEvent;
import jmce.sim.ExceptionListener;
import jmce.sim.Hardware;
import jmce.sim.Memory;
import jmce.sim.SIMException;
import jmce.sim.SIMIOException;
import jmce.sim.Serial;
import jmce.sim.disk.NullDisk;
import jmce.sim.serial.TCPServer;
import jmce.sim.terminal.SampleTerminal;
import jmce.util.Logger;

public class Jmce
extends AbstractHardware
implements ExceptionListener {
    private static Logger log = Logger.getLogger(Jmce.class);
    public static String versionNumber = Svnversion.VERSION;
    public static String version1 = "JMCE (Java Multiple Computer Emulator) Version " + Svnversion.VERSION + " Build " + Svnversion.SVNVERSION;
    public static String version2 = "Copyright (c) 2010-2012 Mario Viara - http://www.viara.eu/en/jmce";
    public static final String JMCE_XML = "cpu.xml";
    static Jmce instance = null;
    private String name;
    private int monitorType;
    private int port;
    private boolean monitor;
    private boolean debugger;
    public CPU cpu;
    private boolean destroyed;

    public static Jmce getInstance() {
        return instance;
    }

    static void usage() {
        System.err.println(version1);
        System.err.println(version2);
        System.err.println("usage : jmce [options] class|xml\n");
        System.err.println(" class  Is a class name of one CPU.");
        System.err.println(" xml    Is the name of xml file with a configuration.\n");
        System.err.println(" options : -g class -t type -p port -l file -m :\n");
        System.err.println(" -g class  Set the  default name for the class CRT.");
        System.err.println(" -t type   Set the type of system monitor :");
        System.err.println("            0 - Monitor on terminal (default).");
        System.err.println("            1 - Monitor on TCP port (see -p).");
        System.err.println(" -p port   Set the TCP port for monitor (see -t 1).");
        System.err.println(" -l file   Set default file for log config. Default logging.properties");
        System.err.println(" -m        Enable monitor implies -g jmce.sim.terminal.SwingCRT");
        System.err.println(" -d        Elable the debugger");
        System.err.println();
        System.err.println(" try:jmce jmce.sinclair.spectrum.Spectrum48K to start ZX (require swing).");
        System.err.println("  or:jmce jmce.z80pack.Z80Pack to start Z80pack with default configuration.");
    }

    void error(String s) {
        Jmce.usage();
        System.err.println("\nError : " + s + "\n");
        System.exit(0);
    }

    void invalidOption(String s) {
        this.error(s + " is not a valid option.");
    }

    void argumentRequired(String opt, String desc) {
        this.error(opt + " require as argument " + desc);
    }

    void invalidArgument(String opt, String desc) {
        this.error("invalid argument " + opt + " " + desc);
    }

    void processOptions(String[] argv) throws SIMException {
        String s;
        int i;
        block8: for (i = 0; i < argv.length && (s = argv[i]).charAt(0) == '-'; ++i) {
            if (s.length() > 2) {
                this.invalidOption(s);
            }
            switch (s.charAt(1)) {
                case 'l': {
                    if (++i >= argv.length) {
                        this.argumentRequired(s, "log config");
                    }
                    Logger.setConfiguration(argv[i]);
                    continue block8;
                }
                case 'g': {
                    if (++i >= argv.length) {
                        this.argumentRequired(s, "Class name");
                    }
                    SampleTerminal.setDefaultCRT(argv[i]);
                    continue block8;
                }
                case 't': {
                    if (++i >= argv.length) {
                        this.argumentRequired(s, "Monitor type");
                    }
                    this.monitorType = Integer.parseInt(argv[i]);
                    if (this.monitorType >= 0 && this.monitorType <= 1) continue block8;
                    this.invalidArgument(argv[i], "Must be 0 or 1");
                    continue block8;
                }
                case 'p': {
                    if (++i >= argv.length) {
                        this.argumentRequired(s, "TCP Port");
                    }
                    this.port = Integer.parseInt(argv[i]);
                    if (this.port >= 0) continue block8;
                    this.invalidArgument(argv[i], "Must >= 0");
                    continue block8;
                }
                case 'd': {
                    this.debugger = true;
                    if (!this.monitor) continue block8;
                    this.error("-d is not compatible with -m");
                    continue block8;
                }
                case 'm': {
                    SampleTerminal.setDefaultCRT("jmce.sim.terminal.SwingCRT");
                    this.monitor = true;
                    if (!this.debugger) continue block8;
                    this.error("-m is not compatible with -d");
                }
            }
        }
        if (i >= argv.length) {
            if (!this.monitor) {
                this.error("No class name or xml specified");
            }
        } else {
            this.name = argv[i];
        }
    }

    @Override
    public void exceptionEvent(ExceptionEvent ev) {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        this.cpu.stop();
        try {
            log.fine("Destroy root");
            this.cpu.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Logger.writeEx(ev.ex);
        System.exit(0);
    }

    public Jmce(String[] argv) {
        block13: {
            this.name = null;
            this.monitorType = 0;
            this.monitor = false;
            this.debugger = false;
            this.cpu = null;
            this.destroyed = false;
            instance = this;
            try {
                SampleTerminal.setDefaultCRT("jmce.sim.terminal.ttyCRT");
                this.processOptions(argv);
                if (this.name != null) {
                    if (this.name.toUpperCase().endsWith(".XML")) {
                        this.setCPU(this.decode(this.name));
                    } else {
                        Class<?> clazz = Class.forName(this.name);
                        Object o = clazz.newInstance();
                        this.setCPU(o);
                    }
                }
                if (this.monitor) {
                    Monitor m = new Monitor();
                    if (this.monitorType == 1) {
                        TCPServer s = new TCPServer();
                        s.setPort(this.port);
                        m.addHardware(s);
                    }
                    this.addHardware(m);
                    this.init(null);
                    this.initSwing(null);
                    this.reset();
                    if (this.cpu != null) {
                        this.cpu.reset();
                    }
                    break block13;
                }
                if (this.debugger) {
                    JDebug jd = new JDebug(this.cpu);
                    jd.pack();
                    jd.setVisible(true);
                }
                try {
                    this.cpu.reset();
                    if (this.cpu.getExceptionListenerCount() == 0) {
                        this.cpu.addExceptionListener(this);
                    }
                    if (!this.debugger) {
                        this.cpu.start();
                    }
                }
                catch (Exception ex) {
                    this.exceptionEvent(new ExceptionEvent(ex));
                }
            }
            catch (Throwable e) {
                System.err.println("\njmce error : " + e);
                Logger.writeEx(e);
            }
        }
    }

    public void start() {
    }

    public void encode(String filename) throws SIMException {
        try {
            XMLEncoder e = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(filename)));
            e.setExceptionListener(new java.beans.ExceptionListener(){

                @Override
                public void exceptionThrown(Exception e) {
                    e.printStackTrace(System.out);
                }
            });
            e.writeObject(this.cpu);
            e.close();
        }
        catch (IOException e) {
            throw new SIMIOException(filename, "XML encoding");
        }
    }

    public void addChild(Hardware parent, Object o) throws SIMException {
        Hardware h = (Hardware)o;
        parent.addHardware(h);
        h.init(parent);
        h.initSwing(parent);
    }

    public void setCPU(Object o) throws SIMException {
        this.cpu = (CPU)o;
        this.cpu.init(null);
        this.cpu.initSwing(null);
    }

    public Object decode(String filename) throws SIMException {
        try {
            XMLDecoder d = new XMLDecoder(new BufferedInputStream(new FileInputStream(filename)));
            Object o = d.readObject();
            d.close();
            return o;
        }
        catch (IOException e) {
            throw new SIMIOException(filename, "XML Decoding");
        }
    }

    public static void showConfig(CPU cpu, Console t) throws SIMException {
        Serial s;
        DiskController fdc;
        int i;
        t.println(version1);
        t.println(version2);
        t.println("CPU " + cpu.getName() + " Clock=" + cpu.getClock() / 1000000L + " Mhz");
        for (i = 0; i < cpu.getMemoryCount(); ++i) {
            Memory m = cpu.getMemoryAt(i);
            t.println("  Memory #" + i + ". " + m.toString());
        }
        i = 0;
        while ((fdc = (DiskController)cpu.getHardware(DiskController.class, i)) != null) {
            t.println("Disk controller # " + i + " " + fdc);
            for (int j = 0; j < fdc.getDiskCount(); ++j) {
                Disk dsk = fdc.getDisk(j);
                if (dsk instanceof NullDisk) continue;
                t.println("  Disk #" + j + " " + (char)(65 + j) + "  " + dsk.toString());
            }
            ++i;
        }
        t.println("Serials :");
        i = 0;
        while ((s = (Serial)cpu.getHardware(Serial.class, i)) != null) {
            Device d2;
            t.print("  Serial # " + i + " " + s.toString());
            Device d1 = s;
            while ((d2 = d1.getConnected()) != null) {
                t.print(" ==> " + d2.toString());
                d1 = d2;
            }
            t.println();
            ++i;
        }
        t.println("Other hardware :");
        for (i = 0; i < cpu.getHardwareCount(); ++i) {
            Hardware h = cpu.getHardware(i);
            if (h instanceof Memory || h instanceof DiskController || h instanceof Serial) continue;
            t.println("  Hardware #" + i + " " + h.toString());
        }
    }

    public static void main(String[] argv) {
        Jmce j = new Jmce(argv);
        j.start();
    }

    @Override
    public String toString() {
        return "JMCE Ver. " + versionNumber;
    }
}

