/*
 * Decompiled with CFR 0.152.
 */
package jmce.commodore.vic20;

import jmce.commodore.vic20.Keyboard;
import jmce.commodore.vic20.Tape;
import jmce.commodore.vic20.VIC6561;
import jmce.mos.M6502;
import jmce.mos.VIA6522;
import jmce.sim.Loadable;
import jmce.sim.Memory;
import jmce.sim.SIMException;
import jmce.sim.cpu.Binary;
import jmce.sim.memory.PlainMemory;
import jmce.swing.Util;

public class VIC20
extends M6502 {
    VIA6522 via1;
    VIA6522 via2;
    VIC6561 vic;
    Keyboard kbd;
    Tape tape;
    private Binary ramexp = new Binary(0);

    public VIC20() {
        this.setName("VIC20");
        this.setRealTime(true);
        this.setClock(985248L);
        Util.setRepaintDelay(20);
    }

    public void setRamExp(int ramexp) {
        this.ramexp.setValue(ramexp);
    }

    public int getRamExp() {
        return this.ramexp.getValue();
    }

    @Override
    protected void initPeripherals() throws SIMException {
        if (this.getHardware((Class)Loadable.class) == null) {
            Loadable boot = new Loadable("commodore/vic20/char.rom", 32768);
            this.addHardware(boot);
            boot = new Loadable("commodore/vic20/kernal-pal.rom", 57344);
            this.addHardware(boot);
            boot = new Loadable("commodore/vic20/basic.rom", 49152);
            this.addHardware(boot);
        }
        this.vic = (VIC6561)this.getHardware((Class)VIC6561.class);
        if (this.vic == null) {
            this.vic = new VIC6561();
            this.addHardware(this.vic);
        }
        this.via1 = (VIA6522)this.getHardwareForName("VIA1");
        if (this.via1 == null) {
            this.via1 = new VIA6522("VIA1", 37136);
            this.addHardware(this.via1);
        }
        this.via2 = (VIA6522)this.getHardwareForName("VIA2");
        if (this.via2 == null) {
            this.via2 = new VIA6522("VIA2", 37152);
            this.addHardware(this.via2);
        }
        this.kbd = (Keyboard)this.getHardware((Class)Keyboard.class);
        if (this.kbd == null) {
            this.kbd = new Keyboard();
            this.addHardware(this.kbd);
        }
        this.tape = (Tape)this.getHardware((Class)Tape.class);
        if (this.tape == null) {
            this.tape = new Tape();
            this.addHardware(this.tape);
        }
        this.kbd.setComponent(this.vic.getComponent());
        this.kbd.setVia2(this.via2);
        this.kbd.setVia1(this.via1);
        this.tape.setVia2(this.via2);
        this.tape.setVia1(this.via1);
        super.initPeripherals();
    }

    @Override
    public void reset() throws SIMException {
        super.reset();
    }

    @Override
    protected void initMemories() throws SIMException {
        Memory m = this.getMemoryForName("MEMORY");
        if (m == null) {
            m = new PlainMemory("MEMORY", 65536);
            this.addHardware(m);
        }
        if (!this.ramexp.getBit(0)) {
            m.setReadOnly(1024, 3072);
        }
        if (!this.ramexp.getBit(1)) {
            m.setReadOnly(8192, 8192);
        }
        if (!this.ramexp.getBit(2)) {
            m.setReadOnly(8192, 8192);
        }
        if (!this.ramexp.getBit(3)) {
            m.setReadOnly(8192, 8192);
        }
        m.setReadOnly(32768, 4096);
        m.setReadOnly(40960, 8192);
        m.setReadOnly(49152, 8192);
        m.setReadOnly(57344, 8192);
        super.initMemories();
    }
}

