/*
 * Decompiled with CFR 0.152.
 */
package jmce.freescale;

import jmce.freescale.M68HC05Constants;
import jmce.sim.Hardware;
import jmce.sim.Interrupt;
import jmce.sim.Memory;
import jmce.sim.SIMException;
import jmce.sim.SIMSWException;
import jmce.sim.cpu.AbstractCPU;
import jmce.sim.cpu.AbstractOpcode;
import jmce.sim.cpu.StandardRegister;
import jmce.sim.memory.PlainMemory;
import jmce.util.Hex;

public class M68HC05
extends AbstractCPU
implements M68HC05Constants {
    int A;
    int X;
    int SP;
    int CCR;
    int PC;
    protected int resetVector = 65536;
    AddressingMode addressA = new AddressingMode(1, -1, 32, "\tA"){

        @Override
        public int getAddress(int pc) throws SIMException {
            throw new SIMSWException("A have ho address");
        }

        @Override
        public void setMemory(int pc, int value) throws SIMException {
            M68HC05.this.A = value;
        }

        @Override
        public int getMemory(int pc) throws SIMException {
            return M68HC05.this.A;
        }
    };
    AddressingMode addressX = new AddressingMode(1, -1, 48, "X"){

        @Override
        public int getAddress(int pc) throws SIMException {
            throw new SIMSWException("X have ho address");
        }

        @Override
        public void setMemory(int pc, int value) throws SIMException {
            M68HC05.this.X = value;
        }

        @Override
        public int getMemory(int pc) throws SIMException {
            return M68HC05.this.X;
        }
    };
    AddressingMode immediate = new AddressingMode(2, 0, 0, "\t#%byte"){

        @Override
        public void setMemory(int pc, int value) throws SIMException {
            throw new SIMSWException("Immediate operand cannoyt be set");
        }

        @Override
        public int getAddress(int pc) {
            return pc + 1;
        }
    };
    AddressingMode direct = new AddressingMode(2, 1, 16, "\t%byte"){

        @Override
        public int getAddress(int pc) throws SIMException {
            return M68HC05.this.getWord(M68HC05.this.getByte(pc + 1));
        }
    };
    AddressingMode extended = new AddressingMode(3, 2, 32, "\t%word"){

        @Override
        public int getAddress(int pc) throws SIMException {
            return M68HC05.this.getWord(pc + 1);
        }
    };
    AddressingMode indexed16 = new AddressingMode(3, 3, 48, "\t%word,X"){

        @Override
        public int getAddress(int pc) throws SIMException {
            return M68HC05.this.X + M68HC05.this.getWord(pc + 1);
        }
    };
    AddressingMode indexed8 = new AddressingMode(2, 2, 64, "\t%byte,X"){

        @Override
        public int getAddress(int pc) throws SIMException {
            return M68HC05.this.X + M68HC05.this.getByte(pc + 1);
        }
    };
    AddressingMode indexed = new AddressingMode(1, 1, 80, "\t,X"){

        @Override
        public int getAddress(int pc) throws SIMException {
            return M68HC05.this.X;
        }
    };

    protected M68HC05(String name) {
        super(name);
        this.setResetVector(2046);
        this.setEndian(0);
        this.setClockPerCycle(1);
        this.setClock(0x200B20L);
    }

    public M68HC05() {
        this("M68HC05");
    }

    protected void initRegisters() {
        this.addRegister(new StandardRegister("PC", 1, 16, 0){

            @Override
            public int getRegister() {
                return M68HC05.this.PC;
            }

            @Override
            public void setRegister(int value) {
                M68HC05.this.PC = value;
            }
        });
        this.addRegister(new StandardRegister("SP", 4, 16){

            @Override
            public int getRegister() {
                return M68HC05.this.SP;
            }

            @Override
            public void setRegister(int value) {
                M68HC05.this.SP = value;
            }
        });
        this.addRegister(new StandardRegister("CCR", 6, 8){

            @Override
            public String descValue() {
                String s = "";
                s = s + "[" + Hex.formatByte(M68HC05.this.CCR) + "]";
                s = s + "111";
                s = M68HC05.this.ccr(16) ? s + "H" : s + "-";
                s = M68HC05.this.ccr(8) ? s + "I" : s + "-";
                s = M68HC05.this.ccr(4) ? s + "N" : s + "-";
                s = M68HC05.this.ccr(2) ? s + "Z" : s + "-";
                s = M68HC05.this.ccr(1) ? s + "C" : s + "-";
                return s;
            }

            @Override
            public int getRegister() {
                return M68HC05.this.CCR;
            }

            @Override
            public void setRegister(int value) {
                M68HC05.this.CCR = value;
            }
        });
        this.addRegister(new StandardRegister("A", 2, 8){

            @Override
            public int getRegister() {
                return M68HC05.this.A;
            }

            @Override
            public void setRegister(int value) {
                M68HC05.this.A = value;
            }
        });
        this.addRegister(new StandardRegister("X", 3, 8){

            @Override
            public int getRegister() {
                return M68HC05.this.X;
            }

            @Override
            public void setRegister(int value) {
                M68HC05.this.X = value;
            }
        });
    }

    protected void push(int value) throws SIMException {
        this.setByte(this.SP, value);
        this.SP = this.SP - 1 & 0xFFFF;
    }

    protected int pop() throws SIMException {
        this.SP = this.SP + 1 & 0xFFFF;
        return this.getByte(this.SP);
    }

    protected void push16(int value) throws SIMException {
        this.push(value);
        this.push(value >>> 8);
    }

    protected int pop16() throws SIMException {
        int result = this.pop() << 8;
        return result | this.pop();
    }

    @Override
    public final void setWord(int a, int v) throws SIMException {
        this.setByte(a + 1, v & 0xFF);
        this.setByte(a + 0, v >>> 8);
    }

    @Override
    public void reset() throws SIMException {
        super.reset();
        this.PC = this.getWord(this.resetVector);
    }

    @Override
    public int fireISR(Interrupt irq) throws SIMException {
        this.push(this.CCR);
        this.push(this.A);
        this.push(this.X);
        this.push16(this.PC);
        this.CCR |= 8;
        this.PC = this.getWord(irq.getVector());
        return 10;
    }

    @Override
    public final int pc() throws SIMException {
        return this.PC;
    }

    @Override
    public final void pc(int pc) throws SIMException {
        this.PC = pc;
    }

    @Override
    public final boolean isInterruptEnabled() {
        return (this.CCR & 8) == 0;
    }

    @Override
    public final int getWord(int a) throws SIMException {
        return this.getByte(a + 1) | this.getByte(a + 0) << 8;
    }

    private final boolean ccr(int mask) {
        return (this.CCR & mask) != 0;
    }

    protected final void ccr(int mask, boolean mode) {
        this.CCR = mode ? (this.CCR |= mask) : (this.CCR &= ~mask);
    }

    private final int xor8(int value) throws SIMException {
        int result = this.A ^ value;
        this.ccr(4, M68HC05.bit7(result));
        this.ccr(2, result == 0);
        return result;
    }

    private final int ld8(int value) throws SIMException {
        this.ccr(4, M68HC05.bit7(value));
        this.ccr(2, value == 0);
        return value;
    }

    private final int and8(int value) throws SIMException {
        int result = this.A & value;
        this.ccr(4, M68HC05.bit7(result));
        this.ccr(2, result == 0);
        return result;
    }

    private final int or8(int value) throws SIMException {
        int result = this.A | value;
        this.ccr(4, M68HC05.bit7(result));
        this.ccr(2, result == 0);
        return result;
    }

    private final int adc8(int value) throws SIMException {
        int v = value + this.A;
        if (this.ccr(1)) {
            ++v;
        }
        this.ccr(1, v > 255);
        this.ccr(16, (v & 0x10) != 0);
        this.ccr(4, (v & 0x80) != 0);
        this.ccr(2, (v & 0xFF) == 0);
        return value;
    }

    private final int sbc8(int value) throws SIMException {
        int v = this.A - value;
        if (this.ccr(1)) {
            --v;
        }
        this.ccr(1, v > 255);
        this.ccr(4, (v & 0x80) != 0);
        this.ccr(2, (v & 0xFF) == 0);
        return value;
    }

    private final int sub8(int value) throws SIMException {
        int v = this.A - value;
        this.ccr(1, v > 255);
        this.ccr(4, (v & 0x80) != 0);
        this.ccr(2, (v & 0xFF) == 0);
        return value;
    }

    private final int add8(int value) throws SIMException {
        this.ccr(1, false);
        return this.adc8(value);
    }

    private final void cmp8(int v1, int v2) throws SIMException {
        int r = v1 - v2;
        this.ccr(2, r == 0);
        this.ccr(4, (r & 0x80) != 0);
        this.ccr(1, v2 > v1);
    }

    protected void initMemories() throws SIMException {
        Memory m = this.getMemoryForName("MEMORY");
        if (m == null) {
            m = new PlainMemory("MEMORY", 65536);
            this.addHardware(m);
        }
        this.setMemory(m);
        this.setIO(m);
    }

    protected void initPeripherals() throws SIMException {
    }

    @Override
    public void init(Hardware parent) throws SIMException {
        this.initMemories();
        this.initPeripherals();
        this.initRegisters();
        this.initOpcodes();
        super.init(parent);
    }

    protected void initOpcodesJumpAddressingMode(int base, CPUOperation op) {
        this.setOpcode(new OpcodeAddressingMode(base -= 16, op, this.direct));
        this.setOpcode(new OpcodeAddressingMode(base, op, this.extended));
        this.setOpcode(new OpcodeAddressingMode(base, op, this.indexed16));
        this.setOpcode(new OpcodeAddressingMode(base, op, this.indexed8));
        this.setOpcode(new OpcodeAddressingMode(base, op, this.indexed));
    }

    private void initOpcodesLogicalAddressingMode(int base, CPUOperation op) {
        this.setOpcode(new OpcodeAddressingMode(base -= 16, op, this.direct));
        this.setOpcode(new OpcodeAddressingMode(base, op, this.addressA));
        this.setOpcode(new OpcodeAddressingMode(base, op, this.addressX));
        this.setOpcode(new OpcodeAddressingMode(base, op, this.indexed8));
        this.setOpcode(new OpcodeAddressingMode(base, op, this.indexed));
    }

    private void initOpcodesAllAddressingMode(int base, CPUOperation op) {
        this.setOpcode(new OpcodeAddressingMode(base, op, this.immediate));
        this.setOpcode(new OpcodeAddressingMode(base, op, this.direct));
        this.setOpcode(new OpcodeAddressingMode(base, op, this.extended));
        this.setOpcode(new OpcodeAddressingMode(base, op, this.indexed16));
        this.setOpcode(new OpcodeAddressingMode(base, op, this.indexed8));
        this.setOpcode(new OpcodeAddressingMode(base, op, this.indexed));
    }

    protected void initOpcodes() {
        this.setOpcode(new AbstractOpcode(129, 1, 6, "RTS"){

            @Override
            public int exec(int pc) throws SIMException {
                M68HC05.this.PC = M68HC05.this.pop16();
                return 6;
            }
        });
        CPUOperation op = new CPUOperation("STX", 3){

            @Override
            public void exec(int pc, AddressingMode add) throws SIMException {
                add.setMemory(pc, M68HC05.this.X);
            }
        };
        this.initOpcodesJumpAddressingMode(191, op);
        op = new CPUOperation("JSR", 4){

            @Override
            public void exec(int pc, AddressingMode add) throws SIMException {
                M68HC05.this.push16(M68HC05.this.PC);
                M68HC05.this.PC = add.getAddress(pc);
            }
        };
        this.initOpcodesJumpAddressingMode(189, op);
        op = new CPUOperation("ROR", 4){

            @Override
            public void exec(int pc, AddressingMode add) throws SIMException {
                int v = add.getMemory(pc);
                if (AbstractCPU.bit0(v)) {
                    v >>= 1;
                    M68HC05.this.ccr(1, true);
                    v |= 0x80;
                } else {
                    v >>= 1;
                    M68HC05.this.ccr(1, false);
                }
                M68HC05.this.ccr(4, false);
                M68HC05.this.ccr(2, v == 0);
                add.setMemory(pc, v);
            }
        };
        this.initOpcodesLogicalAddressingMode(54, op);
        op = new CPUOperation("ROL", 4){

            @Override
            public void exec(int pc, AddressingMode add) throws SIMException {
                int v = add.getMemory(pc);
                if (AbstractCPU.bit7(v)) {
                    v <<= 1;
                    M68HC05.this.ccr(1, true);
                    v |= 1;
                } else {
                    v <<= 1;
                    M68HC05.this.ccr(1, false);
                }
                M68HC05.this.ccr(4, false);
                M68HC05.this.ccr(2, v == 0);
                add.setMemory(pc, v);
            }
        };
        this.initOpcodesLogicalAddressingMode(57, op);
        op = new CPUOperation("NEG", 4){

            @Override
            public void exec(int pc, AddressingMode add) throws SIMException {
                int v = add.getMemory(pc);
                M68HC05.this.ccr(1, v != 0);
                v = 0 - v & 0xFF;
                M68HC05.this.ccr(4, AbstractCPU.bit7(v));
                M68HC05.this.ccr(2, v == 0);
                add.setMemory(pc, v);
            }
        };
        this.initOpcodesLogicalAddressingMode(48, op);
        op = new CPUOperation("LSR", 4){

            @Override
            public void exec(int pc, AddressingMode add) throws SIMException {
                int v = add.getMemory(pc);
                M68HC05.this.ccr(1, AbstractCPU.bit0(v));
                M68HC05.this.ccr(4, false);
                M68HC05.this.ccr(2, (v >>= 1) == 0);
                add.setMemory(pc, v);
            }
        };
        this.initOpcodesLogicalAddressingMode(52, op);
        op = new CPUOperation("INC", 4){

            @Override
            public void exec(int pc, AddressingMode add) throws SIMException {
                int v = add.getMemory(pc);
                v = v + 1 & 0xFF;
                M68HC05.this.ccr(4, AbstractCPU.bit7(v));
                M68HC05.this.ccr(2, v == 0);
                add.setMemory(pc, v);
            }
        };
        this.initOpcodesLogicalAddressingMode(60, op);
        op = new CPUOperation("DEC", 4){

            @Override
            public void exec(int pc, AddressingMode add) throws SIMException {
                int v = add.getMemory(pc);
                v = v - 1 & 0xFF;
                M68HC05.this.ccr(4, AbstractCPU.bit7(v));
                M68HC05.this.ccr(2, v == 0);
                add.setMemory(pc, v);
            }
        };
        this.initOpcodesLogicalAddressingMode(58, op);
        op = new CPUOperation("COM", 4){

            @Override
            public void exec(int pc, AddressingMode add) throws SIMException {
                int v = add.getMemory(pc);
                v = 255 - v;
                M68HC05.this.ccr(1, true);
                M68HC05.this.ccr(4, AbstractCPU.bit7(v));
                M68HC05.this.ccr(2, v == 0);
                add.setMemory(pc, v);
            }
        };
        this.initOpcodesLogicalAddressingMode(51, op);
        op = new CPUOperation("CLR", 4){

            @Override
            public void exec(int pc, AddressingMode add) throws SIMException {
                M68HC05.this.ccr(4, false);
                M68HC05.this.ccr(2, true);
                add.setMemory(pc, 0);
            }
        };
        this.initOpcodesLogicalAddressingMode(63, op);
        op = new CPUOperation("ASL", 4){

            @Override
            public void exec(int pc, AddressingMode add) throws SIMException {
                int v = add.getMemory(pc);
                M68HC05.this.ccr(1, AbstractCPU.bit7(v));
                v = v << 1 & 0xFF;
                M68HC05.this.ccr(4, AbstractCPU.bit7(v));
                M68HC05.this.ccr(2, v == 0);
                add.setMemory(pc, v);
            }
        };
        this.initOpcodesLogicalAddressingMode(56, op);
        op = new CPUOperation("ASR", 4){

            @Override
            public void exec(int pc, AddressingMode add) throws SIMException {
                int v = add.getMemory(pc);
                v = AbstractCPU.bit7(v) ? 0x80 | v >> 1 : (v >>= 1);
                M68HC05.this.ccr(4, AbstractCPU.bit7(v));
                M68HC05.this.ccr(2, v == 0);
                M68HC05.this.ccr(1, AbstractCPU.bit0(v));
                add.setMemory(pc, v);
            }
        };
        this.initOpcodesLogicalAddressingMode(55, op);
        op = new CPUOperation("ADC", 2){

            @Override
            public void exec(int pc, AddressingMode add) throws SIMException {
                M68HC05.this.A = M68HC05.this.adc8(add.getMemory(pc));
            }
        };
        this.initOpcodesAllAddressingMode(169, op);
        op = new CPUOperation("ADD", 2){

            @Override
            public void exec(int pc, AddressingMode add) throws SIMException {
                M68HC05.this.A = M68HC05.this.add8(add.getMemory(pc));
            }
        };
        this.initOpcodesAllAddressingMode(171, op);
        op = new CPUOperation("AND", 2){

            @Override
            public void exec(int pc, AddressingMode add) throws SIMException {
                M68HC05.this.A = M68HC05.this.and8(add.getMemory(pc));
            }
        };
        this.initOpcodesAllAddressingMode(164, op);
        op = new CPUOperation("BIT", 2){

            @Override
            public void exec(int pc, AddressingMode add) throws SIMException {
                int result = M68HC05.this.A & add.getMemory(pc);
                M68HC05.this.ccr(2, result == 0);
                M68HC05.this.ccr(4, (result & 0x80) != 0);
            }
        };
        this.initOpcodesAllAddressingMode(165, op);
        op = new CPUOperation("CMP", 2){

            @Override
            public void exec(int pc, AddressingMode add) throws SIMException {
                M68HC05.this.cmp8(M68HC05.this.A, add.getMemory(pc));
            }
        };
        this.initOpcodesAllAddressingMode(161, op);
        op = new CPUOperation("CPX", 2){

            @Override
            public void exec(int pc, AddressingMode add) throws SIMException {
                M68HC05.this.cmp8(M68HC05.this.X, add.getMemory(pc));
            }
        };
        this.initOpcodesAllAddressingMode(163, op);
        op = new CPUOperation("EOR", 2){

            @Override
            public void exec(int pc, AddressingMode add) throws SIMException {
                M68HC05.this.A = M68HC05.this.xor8(add.getMemory(pc));
            }
        };
        this.initOpcodesAllAddressingMode(168, op);
        op = new CPUOperation("LDA", 2){

            @Override
            public void exec(int pc, AddressingMode add) throws SIMException {
                M68HC05.this.A = M68HC05.this.ld8(add.getMemory(pc));
            }
        };
        this.initOpcodesAllAddressingMode(166, op);
        op = new CPUOperation("LDX", 2){

            @Override
            public void exec(int pc, AddressingMode add) throws SIMException {
                M68HC05.this.X = M68HC05.this.ld8(add.getMemory(pc));
            }
        };
        this.initOpcodesAllAddressingMode(174, op);
        op = new CPUOperation("ORA", 2){

            @Override
            public void exec(int pc, AddressingMode add) throws SIMException {
                M68HC05.this.A = M68HC05.this.or8(add.getMemory(pc));
            }
        };
        this.initOpcodesAllAddressingMode(170, op);
        op = new CPUOperation("SBC", 2){

            @Override
            public void exec(int pc, AddressingMode add) throws SIMException {
                M68HC05.this.A = M68HC05.this.sbc8(add.getMemory(pc));
            }
        };
        this.initOpcodesAllAddressingMode(162, op);
        op = new CPUOperation("SUB", 2){

            @Override
            public void exec(int pc, AddressingMode add) throws SIMException {
                M68HC05.this.A = M68HC05.this.sub8(add.getMemory(pc));
            }
        };
        this.initOpcodesAllAddressingMode(160, op);
    }

    protected void setResetVector(int r) {
        this.resetVector = r;
    }

    abstract class CPUOperation {
        private int times;
        private String desc;

        public CPUOperation(String desc, int times) {
            this.desc = desc;
            this.times = times;
        }

        public int getTimes() {
            return this.times;
        }

        public String getDesc() {
            return this.desc;
        }

        public abstract void exec(int var1, AddressingMode var2) throws SIMException;
    }

    class OpcodeAddressingMode
    extends AbstractOpcode {
        private CPUOperation op;
        private AddressingMode add;

        public OpcodeAddressingMode(int base, CPUOperation op, AddressingMode add) {
            super(base + add.getOffset(), add.getLength(), op.getTimes() + add.getTimes(), op.getDesc() + add.getDesc());
            this.op = op;
            this.add = add;
        }

        @Override
        public int exec(int pc) throws SIMException {
            this.op.exec(pc, this.add);
            return this.times;
        }
    }

    abstract class AddressingMode {
        private int length;
        private int times;
        private int offset;
        private String desc;

        AddressingMode(int length, int times, int offset, String desc) {
            this.length = length;
            this.times = times;
            this.desc = desc;
            this.offset = offset;
        }

        public final int getOffset() {
            return this.offset;
        }

        public final String getDesc() {
            return this.desc;
        }

        public final int getLength() {
            return this.length;
        }

        public final int getTimes() {
            return this.times;
        }

        public void setMemory(int pc, int value) throws SIMException {
            M68HC05.this.setByte(this.getAddress(pc), value);
        }

        public int getMemory(int pc) throws SIMException {
            return M68HC05.this.getByte(this.getAddress(pc));
        }

        public abstract int getAddress(int var1) throws SIMException;
    }
}

