/*
 * Decompiled with CFR 0.152.
 */
package jmce.hitachi;

import jmce.sim.Memory;
import jmce.sim.MemoryReadListener;
import jmce.sim.MemoryWriteListener;
import jmce.sim.SIMException;
import jmce.swing.BitmapFont8x14;
import jmce.swing.KLcd;

public class HD44780
extends KLcd
implements MemoryReadListener,
MemoryWriteListener {
    private static final long serialVersionUID = 1L;
    private int cmdPort = 0;
    private int dataPort = 1;
    private int ddramAddress;
    private int[] displayRam = new int[128];
    private int halfByte = 0;
    private boolean half = false;
    private boolean use8 = true;
    private boolean autoIncDec = true;
    private boolean autoInc = true;
    private boolean ddram = true;

    public HD44780() {
        this.setNumRows(2);
        this.setNumColumns(16);
        this.setFont(new BitmapFont8x14());
    }

    private void hd44780Reset() {
        this.ddramAddress = 0;
        this.hd44780Clear();
    }

    private void hd44780Clear() {
        for (int i = 0; i < this.displayRam.length; ++i) {
            this.displayRam[i] = 32;
        }
        this.hd44780Repaint();
    }

    private void hd44780Repaint() {
        for (int r = 0; r < this.getNumRows(); ++r) {
            int pos = 0;
            for (int c = 0; c < this.getNumColumns(); ++c) {
                switch (r) {
                    case 0: {
                        pos = 0 + c;
                        break;
                    }
                    case 1: {
                        pos = 64 + c;
                        break;
                    }
                    case 2: {
                        pos = 20 + c;
                        break;
                    }
                    case 3: {
                        pos = 84 + c;
                    }
                }
                this.setCursor(r, c);
                this.putchar(this.displayRam[pos]);
            }
        }
        if (this.ddramAddress >= 0 && 0 + this.ddramAddress < this.getNumColumns()) {
            this.setCursor(0, this.ddramAddress);
        }
    }

    private int hd44780Command() {
        return 0;
    }

    private void hd44780Command(int cmd) {
        if ((cmd & 0x80) != 0) {
            this.ddramAddress = cmd & 0x7F;
            this.ddram = true;
            this.hd44780Repaint();
        } else if ((cmd & 0x40) != 0) {
            this.ddram = false;
        } else if ((cmd & 0x20) != 0) {
            if ((cmd & 0x10) != 0) {
                this.use8 = true;
            } else {
                this.use8 = false;
                this.half = false;
            }
        } else if ((cmd & 0x10) != 0) {
            if ((cmd & 8) == 0) {
                if ((cmd & 8) == 0) {
                    if (++this.ddramAddress >= this.displayRam.length) {
                        this.ddramAddress = 0;
                    }
                } else if (--this.ddramAddress < 0) {
                    this.ddramAddress = this.displayRam.length - 1;
                }
                this.hd44780Repaint();
            }
        } else if ((cmd & 8) != 0) {
            this.setDisplay((cmd & 4) != 0);
            this.setCursor((cmd & 2) != 0);
            this.setCursorBlink((cmd & 1) != 0);
        } else if ((cmd & 4) != 0) {
            this.autoIncDec = (cmd & 2) != 0;
            this.autoInc = (cmd & 1) == 0;
        } else if ((cmd & 2) != 0) {
            this.ddramAddress = 0;
            this.hd44780Repaint();
        } else if ((cmd & 1) != 0) {
            this.hd44780Reset();
        }
    }

    int hd44780Data() {
        int data = this.displayRam[this.ddramAddress];
        if (this.autoIncDec) {
            if (this.autoInc) {
                if (++this.ddramAddress >= this.displayRam.length) {
                    this.ddramAddress = 0;
                }
            } else if (--this.ddramAddress < 0) {
                this.ddramAddress = this.displayRam.length;
            }
        }
        return data;
    }

    void hd44780Data(int data) {
        if (this.ddram) {
            this.displayRam[this.ddramAddress] = data;
            if (this.autoIncDec) {
                if (this.autoInc) {
                    if (++this.ddramAddress >= this.displayRam.length) {
                        this.ddramAddress = 0;
                    }
                } else if (--this.ddramAddress < 0) {
                    this.ddramAddress = this.displayRam.length;
                }
            }
            this.hd44780Repaint();
        }
    }

    @Override
    public int readMemory(Memory memory, int address, int value) throws SIMException {
        if (!this.use8 && this.half) {
            this.half = false;
            return this.halfByte;
        }
        if (address == this.cmdPort) {
            value = this.hd44780Command();
        } else if (address == this.dataPort) {
            value = this.hd44780Data();
        }
        if (this.half) {
            this.halfByte = value << 4 & 0xF0;
            value &= 0xF0;
        }
        return value;
    }

    @Override
    public void writeMemory(Memory memory, int address, int value, int oldValue) throws SIMException {
        if (!this.use8) {
            if (this.half) {
                value = value >>> 4 | this.halfByte;
                this.half = false;
            } else {
                this.halfByte = value & 0xF0;
                this.half = true;
                return;
            }
        }
        if (address == this.cmdPort) {
            this.hd44780Command(value);
        } else if (address == this.dataPort) {
            this.hd44780Data(value);
        }
    }
}

