/*
 * Decompiled with CFR 0.152.
 */
package jmce.intel.mcs51;

import jmce.intel.mcs51.MCS51Constants;
import jmce.sim.AbstractPeripheral;
import jmce.sim.CPU;
import jmce.sim.Memory;
import jmce.sim.MemoryWriteListener;
import jmce.sim.SIMException;

public class Port
extends AbstractPeripheral
implements MCS51Constants,
MemoryWriteListener {
    public static int[] sfrPorts = new int[]{128, 144, 160, 176, -1, -1, -1, -1, -1, -1};
    public static int[] sfrM1s = new int[]{132, 145, 164, 177, -1, -1, -1, -1, -1, -1};
    public static int[] sfrM2s = new int[]{133, 146, 165, 178, -1, -1, -1, -1, -1, -1};
    private int sfrPort;
    private int sfrM1;
    private int sfrM2;
    private int port;
    private int m2;
    private int m1;
    private int disableMask;
    private int portNum;

    public Port() {
        this(0);
    }

    public Port(int port) {
        this.setPortNum(port);
    }

    @Override
    public void registerCPU(CPU cpu) throws SIMException {
        super.registerCPU(cpu);
        if (this.sfrPort != -1) {
            cpu.addIOWriteListener(this.sfrPort, this);
        }
        if (this.sfrM1 != -1) {
            cpu.addIOWriteListener(this.sfrM1, this);
        }
        if (this.sfrM2 != -1) {
            cpu.addIOWriteListener(this.sfrM2, this);
        }
    }

    public void setPortNum(int n) {
        this.setName("Port" + n);
        this.portNum = n;
        this.sfrPort = sfrPorts[n];
        this.sfrM1 = sfrM1s[n];
        this.sfrM2 = sfrM2s[n];
    }

    public int getPortNum() {
        return this.portNum;
    }

    public void setDisableMask(int mask) {
        this.disableMask = mask;
    }

    public int getDisableMask() {
        return this.disableMask;
    }

    protected void setPort(int value) {
        this.port = value;
    }

    protected void setM1(int value) {
        this.port = value;
    }

    protected void setM2(int value) {
        this.port = value;
    }

    protected int getPort() {
        return this.port;
    }

    protected int getM1() {
        return this.m1;
    }

    protected int getM2() {
        return this.m2;
    }

    @Override
    public void writeMemory(Memory m, int sfr, int value, int oldValue) throws SIMException {
        if (sfr == this.sfrPort) {
            this.setPort(value);
        } else if (sfr == this.sfrM1) {
            this.setM1(value);
        } else if (sfr == this.sfrM2) {
            this.setM2(value);
        }
    }

    public int readMemory(Memory m, int sfr, int v) throws SIMException {
        if (sfr == this.sfrPort) {
            return this.getPort();
        }
        if (sfr == this.sfrM1) {
            return this.getM1();
        }
        if (sfr == this.sfrM2) {
            return this.getM2();
        }
        return 0;
    }
}

