/*
 * Decompiled with CFR 0.152.
 */
package jmce.intel.mcs51;

import jmce.intel.mcs51.Interrupt8051;
import jmce.intel.mcs51.MCS51;
import jmce.intel.mcs51.MCS51Constants;
import jmce.sim.CPU;
import jmce.sim.Memory;
import jmce.sim.MemoryReadListener;
import jmce.sim.MemoryWriteListener;
import jmce.sim.SIMException;

public class Serial
extends jmce.sim.Serial
implements MemoryReadListener,
MemoryWriteListener,
MCS51Constants {
    private int sbuf;
    private int scon;
    private boolean sbufSent = true;
    private Interrupt8051 irq;

    public Serial() {
        super("Serial");
    }

    @Override
    public void registerCPU(CPU cpu) throws SIMException {
        super.registerCPU(cpu);
        cpu.addIOWriteListener(153, this);
        cpu.addIOReadListener(153, this);
        cpu.addIOWriteListener(152, this);
        this.irq = new Interrupt8051((MCS51)cpu, "Serial", 35);
        this.irq.addInterruptCondition(168, 16);
        this.irq.addInterruptCondition(152, 3);
    }

    @Override
    public void reset() throws SIMException {
        super.reset();
        this.sbuf = 63;
        this.scon = 0;
        this.sbufSent = true;
    }

    @Override
    public void writeInput(Integer c) throws SIMException {
        super.writeInput(c);
        this.feedCpu();
    }

    private void feedCpu() throws SIMException {
        if (!this.sbufSent || (this.scon & 1) != 0) {
            return;
        }
        if (this.readyRead()) {
            this.sbuf = (Integer)this.read();
            this.sbufSent = false;
            this.cpu.setIOByte(152, this.cpu.getIOByte(152) | 1);
        }
    }

    @Override
    public int readMemory(Memory m, int a, int v) throws SIMException {
        switch (a) {
            case 153: {
                v = this.sbuf;
                this.sbufSent = true;
                this.feedCpu();
                return v;
            }
        }
        return 0;
    }

    @Override
    public void writeMemory(Memory m, int a, int v, int oldValue) throws SIMException {
        switch (a) {
            case 152: {
                this.scon = v;
                this.feedCpu();
                break;
            }
            case 153: {
                this.write(v);
                this.cpu.setIOByte(152, this.cpu.getIOByte(152) | 2);
            }
        }
    }
}

