/*
 * Decompiled with CFR 0.152.
 */
package jmce.philips.lpc900;

import jmce.intel.mcs51.MCS52;
import jmce.philips.lpc900.LPC900Constants;
import jmce.philips.lpc900.Ports;
import jmce.sim.Memory;
import jmce.sim.SIMException;
import jmce.sim.memory.PersistentMemory;
import jmce.sim.memory.PlainMemory;

public class LPC900
extends MCS52
implements LPC900Constants {
    private int flashSize = 8192;

    public LPC900() {
        this.setName("LPC900");
        this.setClock(0x708000L);
        this.setClockPerCycle(2);
    }

    public void setFlashSize(int n) {
        this.flashSize = n;
    }

    @Override
    protected void initMemories() {
        Memory m = this.getMemoryForName("CODE");
        if (m == null) {
            m = new PersistentMemory("CODE", this.getName() + ".flash", this.flashSize);
            this.addHardware(m);
        }
        if ((m = this.getMemoryForName("XDATA")) == null) {
            m = (Memory)this.addHardware(new PlainMemory("XDATA", 768));
        }
        super.initMemories();
    }

    @Override
    protected void initPeripherals() throws SIMException {
        if (this.getHardware((Class)jmce.intel.mcs51.Ports.class) == null) {
            this.addHardware(new Ports());
        }
        super.initPeripherals();
    }

    @Override
    protected void initNames() {
        super.initNames();
        this.setSfrName(229, "FMDATA");
        this.setSfrName(228, "FMCON");
        this.setSfrName(230, "FMADRL");
        this.setSfrName(231, "FMADRH");
        this.setSfrName(241, "DEECON");
        this.setSfrName(242, "DEEDAT");
        this.setSfrName(243, "DEEADR");
        this.setSfrName(162, "AUXR1");
    }
}

