/*
 * Decompiled with CFR 0.152.
 */
package jmce.philips.p2000;

import java.io.FileInputStream;
import jmce.sim.AbstractPeripheral;
import jmce.sim.CPU;
import jmce.sim.Memory;
import jmce.sim.MemoryReadListener;
import jmce.sim.MemoryWriteListener;
import jmce.sim.SIMException;
import jmce.util.Hex;
import jmce.util.Logger;
import jmce.util.Timer;
import jmce.util.TimerListener;

class Cassette
extends AbstractPeripheral
implements MemoryReadListener,
MemoryWriteListener {
    private static Logger log = Logger.getLogger(Cassette.class);
    private FileInputStream is = null;
    private boolean clock = false;
    private int bit = 0;
    private int data = 0;
    private boolean rewind = false;
    private boolean forward = false;
    private Timer timerRewind = new Timer(500, false, new TimerListener(){

        @Override
        public void timerExpired() {
            Cassette.this.bit = 8;
            Cassette.this.rewind = true;
        }
    });
    private Timer timerForward = new Timer(500, false, new TimerListener(){

        @Override
        public void timerExpired() {
            Cassette.this.bit = 8;
            Cassette.this.forward = true;
        }
    });

    @Override
    public void writeMemory(Memory m, int address, int value, int oldValue) throws SIMException {
        log.info("WR=" + Hex.formatByte(value) + " PC=" + Hex.formatWord(this.cpu.pc()));
        if ((value & 4) != 0) {
            try {
                this.is = new FileInputStream("P2000/P2000.cas");
            }
            catch (Exception ex) {
                log.info(ex);
                this.is = null;
            }
            if (!this.timerRewind.isRunning()) {
                log.info("Start Rewind");
                this.cpu.addTimerMs(this.timerRewind);
            }
        } else {
            this.rewind = false;
        }
        if ((value & 8) != 0) {
            if (!this.timerForward.isRunning()) {
                log.info("Start Forward");
                this.cpu.addTimerMs(this.timerForward);
            }
        } else {
            this.forward = false;
        }
    }

    @Override
    public int readMemory(Memory memory, int address, int value) throws SIMException {
        value = 8;
        if (this.is == null) {
            // empty if block
        }
        log.info("R=" + this.rewind + " F=" + this.forward + " PC=" + Hex.formatWord(this.cpu.pc()));
        value = this.rewind || this.forward ? (value |= 0x20) : (value |= 0x10);
        boolean bl = this.clock = !this.clock;
        if (this.clock) {
            value |= 0x40;
        }
        if (this.is != null && !this.rewind && !this.forward) {
            if (this.clock && ++this.bit > 7) {
                this.bit = 0;
                try {
                    this.data = this.is.read();
                    log.info("Data=" + Hex.formatByte(this.data));
                }
                catch (Exception ex) {
                    log.info(ex);
                }
                if (this.data == -1) {
                    try {
                        this.is.close();
                    }
                    catch (Exception ex) {
                        log.info(ex);
                    }
                    this.is = null;
                }
            }
            if (this.bit > 7) {
                this.bit = 7;
            }
            if ((this.data & 1 << this.bit) != 0) {
                value |= 0x40;
            }
        }
        log.info("RD=" + Hex.formatByte(value));
        return value;
    }

    @Override
    public void registerCPU(CPU cpu) throws SIMException {
        super.registerCPU(cpu);
        for (int i = 0; i < 16; ++i) {
            cpu.addIOWriteListener(16 + i, this);
            cpu.addIOReadListener(32 + i, this);
        }
        try {
            this.is = new FileInputStream("p2000/P2000.cas");
        }
        catch (Exception ex) {
            log.info(ex);
        }
    }
}

