/*
 * Decompiled with CFR 0.152.
 */
package jmce.sim;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import jmce.JMonitor;
import jmce.Jmce;
import jmce.sim.CPU;
import jmce.sim.Hardware;
import jmce.sim.Peripheral;
import jmce.sim.SIMException;
import jmce.sim.SwingHardware;
import jmce.util.Logger;

public abstract class AbstractHardware
implements Hardware {
    private static Logger log = Logger.getLogger(AbstractHardware.class);
    private static CPU cpu = null;
    private Hardware parent = null;
    private ArrayList<Hardware> hardwares = new ArrayList();
    private String name;
    private JFrame frame = null;
    private Vector<JComponent> swingComponents = new Vector();

    public AbstractHardware() {
    }

    public AbstractHardware(String name) {
        this.setName(name);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void reset() throws SIMException {
        for (int i = 0; i < this.getHardwareCount(); ++i) {
            log.fine("Reset " + this.getHardware(i));
            this.getHardware(i).reset();
        }
        if (this.swingComponents.size() > 0) {
            this.createFrame(this.swingComponents);
        }
    }

    @Override
    public void init(Hardware parent) throws SIMException {
        this.parent = parent;
        if (this instanceof CPU) {
            cpu = (CPU)((Object)this);
        }
        log.fine("Start Init=" + this + " Parent=" + parent + " Cpu=" + cpu);
        for (int i = 0; i < this.getHardwareCount(); ++i) {
            Hardware child = this.getHardware(i);
            child.init(this);
            if (cpu == null || !(child instanceof Peripheral)) continue;
            ((Peripheral)child).registerCPU(cpu);
        }
        log.fine("End Init=" + this + " Parent=" + parent);
    }

    @Override
    public void initSwing(Hardware parent) throws SIMException {
        if (this instanceof SwingHardware) {
            SwingHardware sc = (SwingHardware)((Object)this);
            log.fine("Init swing " + this.getName());
            Component comp = sc.getComponent();
            boolean createFrame = false;
            if (comp instanceof JComponent) {
                JComponent jc = (JComponent)comp;
                if (jc.getParent() == null || !jc.isVisible()) {
                    createFrame = true;
                }
                if (createFrame) {
                    if (comp instanceof JComponent) {
                        jc = (JComponent)comp;
                    } else {
                        JPanel p = new JPanel();
                        p.add(comp);
                        jc = p;
                    }
                    AbstractHardware root = this.getRoot();
                    log.info("Add JComponent " + this + " to " + root);
                    root.swingComponents.add(jc);
                }
            }
        }
        for (int i = 0; i < this.getHardwareCount(); ++i) {
            Hardware child = this.getHardware(i);
            log.fine("initSwing " + child);
            child.initSwing(this);
        }
    }

    private AbstractHardware getRoot() {
        AbstractHardware root = this;
        while (root.parent != null) {
            root = (AbstractHardware)root.parent;
        }
        return root;
    }

    @Override
    public Hardware addHardware(Hardware h) {
        log.fine("Add " + h.toString() + " to " + this.toString());
        this.hardwares.add(h);
        return h;
    }

    @Override
    public int getHardwareCount() {
        return this.hardwares.size();
    }

    @Override
    public Hardware getHardware(int i) {
        return this.hardwares.get(i);
    }

    @Override
    public void removeHardware(int n) {
        this.hardwares.remove(n);
    }

    @Override
    public void removeHardware(Hardware h) {
        this.hardwares.remove(h);
    }

    @Override
    public void destroy() throws SIMException {
        for (int i = 0; i < this.getHardwareCount(); ++i) {
            log.fine("Destroy " + this.getHardware(i));
            this.getHardware(i).destroy();
        }
        log.fine("Destroy " + this);
        if (this.frame != null) {
            this.frame.setVisible(false);
        }
    }

    public Hardware getHardwareForName(String name) {
        for (int i = 0; i < this.getHardwareCount(); ++i) {
            Hardware h = this.getHardware(i);
            if (!h.getName().equalsIgnoreCase(name)) continue;
            return h;
        }
        return null;
    }

    @Override
    public Hardware getHardwareTree(Class ... classes) {
        Hardware parent = this;
        for (Class c : classes) {
            if (parent == null) {
                return null;
            }
            parent = parent.getHardware(c);
            if (c != null) continue;
            return null;
        }
        return parent;
    }

    public Hardware getHardware(Class ... classes) {
        Hardware h = this;
        for (Class c : classes) {
            for (int i = 0; i < h.getHardwareCount(); ++i) {
                System.out.println("" + i + " = " + h.getHardware(i));
            }
            if ((h = h.getHardware(c)) != null) continue;
            return h;
        }
        return h;
    }

    @Override
    public Hardware getHardware(Class c) {
        return this.getHardware(c, 0);
    }

    @Override
    public Hardware getHardware(Class c, int n) {
        for (int i = 0; i < this.getHardwareCount(); ++i) {
            Hardware o = this.getHardware(i);
            if (!c.isInstance(o) || n-- > 0) continue;
            return o;
        }
        return null;
    }

    @Override
    public Object[] getHardwareInstances(Class c) {
        ArrayList<Hardware> a = new ArrayList<Hardware>();
        for (int i = 0; i < this.getHardwareCount(); ++i) {
            Hardware o = this.getHardware(i);
            if (!c.isInstance(o)) continue;
            a.add(o);
        }
        return a.toArray();
    }

    @Override
    public Hardware[] getHardware() {
        if (this.hardwares.size() == 0) {
            return null;
        }
        return this.hardwares.toArray(new Hardware[this.hardwares.size()]);
    }

    @Override
    public void setHardware(int n, Hardware h) {
        this.hardwares.set(n, h);
    }

    @Override
    public void setHardware(Hardware[] h) {
        for (int i = 0; i < h.length; ++i) {
            this.addHardware(h[i]);
        }
    }

    @Override
    public Hardware getParent() {
        return this.parent;
    }

    public void createFrame(Vector<JComponent> j) {
        String name = this.toString();
        log.info("Create frame in Class=" + this.getClass().getName() + " Name=" + name + " Len=" + j.size());
        if (this.frame != null) {
            log.info("Destroy old frame");
            this.frame.setVisible(false);
            this.frame = null;
        }
        GridBagConstraints g = new GridBagConstraints();
        g.gridx = 0;
        g.gridy = 0;
        g.gridwidth = 1;
        g.gridheight = 1;
        g.fill = 1;
        g.insets = new Insets(2, 2, 2, 2);
        g.anchor = 10;
        JPanel p = new JPanel(new GridBagLayout());
        for (int i = 0; i < j.size(); ++i) {
            p.add((Component)j.get(i), g);
            ++g.gridy;
        }
        this.frame = new JMonitor(cpu, p);
        this.frame.setTitle(name + " - JMCE " + Jmce.versionNumber);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    public String toString() {
        return this.getName();
    }
}

