/*
 * Decompiled with CFR 0.152.
 */
package jmce.sim;

import jmce.sim.AbstractPeripheral;
import jmce.sim.BufferedDeviceProducer;
import jmce.sim.DeviceConsumer;
import jmce.sim.DeviceProducer;
import jmce.sim.SIMException;

public class Device<E>
extends AbstractPeripheral {
    private Device<E> connected = null;
    private BufferedDeviceProducer<E> input = new BufferedDeviceProducer();
    private BufferedDeviceProducer<E> output = new BufferedDeviceProducer();

    public void removeInputConsumer(DeviceConsumer<E> c) {
        this.input.removeConsumer(c);
    }

    public void addInputConsumer(DeviceConsumer<E> c) {
        this.input.addConsumer(c);
    }

    public void addInputProducer(DeviceProducer<E> c) throws SIMException {
        c.addConsumer(new DeviceConsumer<E>(){

            @Override
            public void consume(E c) throws SIMException {
                Device.this.input.produce(c);
            }
        });
    }

    public void removeOutputConsumer(DeviceConsumer<E> c) {
        this.output.removeConsumer(c);
    }

    public void addOutputConsumer(DeviceConsumer<E> c) throws SIMException {
        this.output.addConsumer(c);
    }

    public void addOutputProducer(DeviceProducer<E> c) throws SIMException {
        c.addConsumer(new DeviceConsumer<E>(){

            @Override
            public void consume(E c) throws SIMException {
                Device.this.output.produce(c);
            }
        });
    }

    public boolean readyRead() {
        return !this.input.isEmpty();
    }

    private E read(BufferedDeviceProducer<E> stream) throws SIMException {
        while (stream.isEmpty()) {
            this.idle();
        }
        return stream.consume();
    }

    public E read() throws SIMException {
        return this.read(this.input);
    }

    public boolean readyWrite() {
        return !this.output.isFull();
    }

    private void write(BufferedDeviceProducer<E> stream, E c) throws SIMException {
        while (stream.isFull()) {
            this.idle();
        }
        stream.produce(c);
    }

    public void write(E c) throws SIMException {
        this.write(this.output, c);
    }

    public boolean readyReadOutput() {
        return !this.output.isEmpty();
    }

    public E readOutput() throws SIMException {
        return this.read(this.output);
    }

    public void writeInput(E c) throws SIMException {
        this.write(this.input, c);
    }

    public Device(String name) {
        super(name);
    }

    public Device() {
        this("Device");
    }

    public Device<E> getConnected() {
        return this.connected;
    }

    public void setConnected(Device<E> c) throws SIMException {
        if (this.connected != null) {
            throw new Error("Multiple connected device not supported");
        }
        this.connected = c;
        this.addOutputConsumer(new DeviceConsumer<E>(){

            @Override
            public void consume(E c) throws SIMException {
                Device.this.connected.writeInput(c);
            }
        });
        this.connected.addOutputConsumer(new DeviceConsumer<E>(){

            @Override
            public void consume(E c) throws SIMException {
                Device.this.writeInput(c);
            }
        });
    }
}

