/*
 * Decompiled with CFR 0.152.
 */
package jmce.sim;

import jmce.sim.InterruptManager;
import jmce.sim.SIMException;
import jmce.util.FastArray;

public class Interrupt {
    private int counter;
    protected int vector = 0;
    private String name = "";
    private boolean active = false;
    private boolean enabled = false;
    private boolean nmi;
    private boolean autoReset;
    private FastArray<InterruptManager> mgrs = new FastArray();

    public Interrupt(InterruptManager mgr, String name, int vector, boolean nmi) {
        this.name = name;
        this.nmi = nmi;
        this.vector = vector;
        if (!nmi) {
            this.addInterruptManager(mgr);
        }
    }

    public Interrupt(InterruptManager cpu, String name, int vector) {
        this(cpu, name, vector, false);
    }

    public Interrupt(InterruptManager cpu, String name) {
        this(cpu, name, 0);
    }

    public void addInterruptManager(InterruptManager mgr) {
        mgr.addInterrupt(this);
        this.mgrs.add(mgr);
    }

    public boolean isNmi() {
        return this.nmi;
    }

    public void startISR() throws SIMException {
        ++this.counter;
    }

    public int getCounter() {
        return this.counter;
    }

    public void resetCounter() {
        this.counter = 0;
    }

    public void setVector(int n) {
        this.vector = n;
    }

    public int getVector() throws SIMException {
        return this.vector;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isActive() throws SIMException {
        return this.active;
    }

    public final void setEnabled(boolean mode) throws SIMException {
        this.enabled = mode;
        if (this.enabled) {
            this.checkReady();
        }
    }

    public final void setActive(boolean mode) throws SIMException {
        this.active = mode;
        if (this.active) {
            this.checkReady();
        }
    }

    public boolean isReady() throws SIMException {
        return this.isActive() & this.isEnabled();
    }

    protected final void checkReady() throws SIMException {
        int i = this.mgrs.getSize();
        while (--i >= 0) {
            this.mgrs.get(i).notifyInterrupt(this);
        }
    }

    public void setAutoReset(boolean mode) {
        this.autoReset = mode;
    }

    public boolean isAutoReset() {
        return this.autoReset;
    }

    public String toString() {
        return this.getName();
    }
}

