/*
 * Decompiled with CFR 0.152.
 */
package jmce.sim.cpu;

import jmce.sim.Opcode;
import jmce.util.Hex;
import jmce.util.Logger;

public abstract class AbstractOpcode
implements Opcode {
    private static Logger log = Logger.getLogger(AbstractOpcode.class);
    protected int opcode;
    protected int length;
    protected int times;
    protected String desc;
    private long execCounter = 0L;
    protected AbstractOpcode[] opcodes = null;
    protected boolean multiOpcode = false;
    protected boolean runtimeOpcode = false;
    protected boolean prefixOpcode = false;

    public AbstractOpcode(int opcode, int length, int times, String desc) {
        this.opcode = opcode;
        this.desc = desc;
        this.length = length;
        this.times = times;
    }

    @Override
    public final int getOpcode() {
        return this.opcode;
    }

    @Override
    public final int getLength() {
        return this.length;
    }

    @Override
    public final int getTimes() {
        return this.times;
    }

    @Override
    public void setDescription(String s) {
        this.desc = s;
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    @Override
    public void clearCounter() {
        this.execCounter = 0L;
    }

    @Override
    public long getCounter() {
        return this.execCounter;
    }

    @Override
    public final void incCounter() {
        ++this.execCounter;
    }

    public String toString() {
        return Hex.formatByte(this.getOpcode()) + " (" + this.getDescription() + ")";
    }

    public final boolean isMultiOpcode() {
        return this.multiOpcode;
    }

    public final AbstractOpcode getOpcode(int code) {
        return this.opcodes[code];
    }

    public void setOpcode(AbstractOpcode o) {
        int opcode = o.getOpcode();
        if (this.opcodes[opcode] != null) {
            log.warning("Duplicate opcode new " + o + " old " + this.opcodes[opcode]);
            System.exit(1);
        }
        this.opcodes[opcode] = o;
    }

    public int getMaxLength() {
        int len = -1;
        for (int i = 0; i < 256; ++i) {
            AbstractOpcode o = this.opcodes[i];
            int len1 = 0;
            if (o != null) {
                len1 = o.isMultiOpcode() ? o.getMaxLength() : o.getLength();
            }
            if (len1 <= len) continue;
            len = len1;
        }
        return len;
    }

    public int getOpcodeCount() {
        int count = 0;
        for (int i = 0; i < 256; ++i) {
            AbstractOpcode o = this.opcodes[i];
            if (o == null) continue;
            if (o.isMultiOpcode()) {
                count += o.getOpcodeCount();
                continue;
            }
            ++count;
        }
        return count;
    }
}

