/*
 * Decompiled with CFR 0.152.
 */
package jmce.sim.disk;

import jmce.sim.AbstractPeripheral;
import jmce.sim.Disk;
import jmce.sim.DiskController;
import jmce.sim.SIMException;
import jmce.sim.cpm.DPB;
import jmce.sim.cpm.DPB3740;
import jmce.sim.disk.DirDiskCPM;
import jmce.sim.disk.ImageDiskCPM;
import jmce.sim.disk.NullDisk;

public class AbstractDiskController
extends AbstractPeripheral
implements DiskController {
    protected int drive;
    protected final Disk nullDisk;
    protected Disk disk;

    public AbstractDiskController() {
        this.disk = this.nullDisk = new NullDisk();
    }

    @Override
    public int getDrive() {
        return this.drive;
    }

    @Override
    public void setDrive(int drive) throws SIMException {
        this.disk = this.getDisk(drive);
        this.drive = drive;
    }

    @Override
    public int getDiskCount() {
        return this.getHardwareCount();
    }

    @Override
    public Disk getDisk(int n) throws SIMException {
        return (Disk)this.getHardware(n);
    }

    public void addDirDiskIBM3740(String dir) {
        this.addDirDiskCPM(dir, new DPB3740());
    }

    public void addDirDiskCPM(String dir, DPB dpb) {
        DirDiskCPM d = new DirDiskCPM();
        d.setDirectory(dir);
        d.setDPB(dpb);
        this.addHardware(d);
    }

    public void addImageDisk(String name, DPB dpb) {
        ImageDiskCPM d = new ImageDiskCPM();
        d.setDPB(dpb);
        d.setImageName(name);
        this.addHardware(d);
    }

    public void addImageDiskIBM3740(String name) {
        this.addImageDisk(name, new DPB3740());
    }

    public void addNullDisk() {
        this.addHardware(this.nullDisk);
    }
}

