/*
 * Decompiled with CFR 0.152.
 */
package jmce.sim.disk;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import jmce.sim.SIMException;
import jmce.sim.SIMIOException;
import jmce.sim.disk.AbstractDisk;
import jmce.util.Logger;

public class ImageDisk
extends AbstractDisk {
    private static Logger log = Logger.getLogger(AbstractDisk.class);
    private String imageName;
    private RandomAccessFile rf = null;

    public ImageDisk(String name) {
        this(77, 1, 26, 128, name);
    }

    public ImageDisk() {
        this(77, 1, 26, 128, "ibm3740.dsk");
    }

    public ImageDisk(int t, int h, int s, int ss, String filename) {
        super(t, h, s, ss);
        this.setImageName(filename);
    }

    public void setImageName(String name) {
        this.imageName = name;
    }

    public String getImageName() {
        return this.imageName;
    }

    @Override
    public void dismount() throws SIMException {
        this.setMounted(false);
        try {
            if (this.rf != null) {
                this.rf.close();
                this.rf = null;
            }
        }
        catch (IOException e) {
            throw new SIMIOException(this.imageName, "close()");
        }
    }

    @Override
    public boolean mount() throws SIMException {
        if (this.isMounted()) {
            return true;
        }
        File file = new File(this.imageName);
        if (!file.exists()) {
            log.info(this.imageName + " do not exist");
            return this.setMounted(false);
        }
        if (!file.isFile()) {
            log.info(this.imageName + " is not a regular file");
            return this.setMounted(false);
        }
        try {
            this.rf = new RandomAccessFile(this.imageName, "rw");
        }
        catch (IOException e) {
            throw new SIMIOException(this.imageName, "open()");
        }
        return this.setMounted(true);
    }

    @Override
    public final int read(int pos) throws SIMException {
        if (!this.mounted) {
            throw new SIMException(this.imageName + " read without mount");
        }
        log.fine("Read at " + pos + " from " + this.imageName + " Len=" + this.buffer.length);
        try {
            this.rf.seek(pos);
            int n = this.rf.read(this.buffer, 0, this.sectorSize);
            return n;
        }
        catch (IOException e) {
            throw new SIMIOException(this.imageName, "Reading");
        }
    }

    @Override
    public final int write(int pos) throws SIMException {
        if (!this.mounted) {
            throw new SIMException(this.imageName + " write without mount");
        }
        log.fine("Write at " + pos + " to " + this.imageName + " len=" + this.buffer.length);
        try {
            this.rf.seek(pos);
            this.rf.write(this.buffer, 0, this.sectorSize);
            return this.sectorSize;
        }
        catch (IOException e) {
            throw new SIMIOException(this.imageName, "Writing");
        }
    }

    @Override
    public String toString() {
        return this.imageName + " " + this.getNumTrack() + "/" + this.getNumHead() + "/" + this.getNumSector() + "/" + this.getSectorSize() + " " + this.getDiskSizeString();
    }
}

