/*
 * Decompiled with CFR 0.152.
 */
package jmce.sim.tape;

import jmce.sim.AbstractPeripheral;
import jmce.sim.Tape;
import jmce.sim.TapeEventListener;
import jmce.util.FastArray;
import jmce.util.Logger;

public abstract class AbstractTape
extends AbstractPeripheral
implements Tape {
    private static Logger log = Logger.getLogger(AbstractTape.class);
    private FastArray<TapeEventListener> listeners = new FastArray();
    private boolean power = false;

    public AbstractTape(String name) {
        super(name);
    }

    @Override
    public void addTapeEventListener(TapeEventListener l) {
        this.listeners.add(l);
    }

    protected final void notifyStop() {
        for (int i = 0; i < this.listeners.getSize(); ++i) {
            this.listeners.get(i).tapeStop(this);
        }
    }

    protected final void notifyPlay() {
        for (int i = 0; i < this.listeners.getSize(); ++i) {
            this.listeners.get(i).tapePlay(this);
        }
    }

    protected final void notifyRec() {
        for (int i = 0; i < this.listeners.getSize(); ++i) {
            this.listeners.get(i).tapePlay(this);
        }
    }

    protected final void notifyPower() {
        for (int i = 0; i < this.listeners.getSize(); ++i) {
            this.listeners.get(i).tapePower(this);
        }
    }

    @Override
    public final void setPower(boolean mode) {
        if (this.power != mode) {
            this.power = mode;
            log.info(this + " Power=" + mode);
            this.notifyPower();
        }
    }

    @Override
    public final boolean getPower() {
        return this.power;
    }
}

