/*
 * Decompiled with CFR 0.152.
 */
package jmce.sinclair.spectrum;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import jmce.sim.AbstractPeripheral;
import jmce.sim.CPU;
import jmce.sim.CycleListener;
import jmce.sim.Hardware;
import jmce.sim.Memory;
import jmce.sim.MemoryWriteListener;
import jmce.sim.SIMException;
import jmce.sinclair.spectrum.Screen;
import jmce.sinclair.spectrum.SpectrumConstants;
import jmce.util.Logger;

public class Speaker
extends AbstractPeripheral
implements MemoryWriteListener,
CycleListener,
SpectrumConstants {
    private static Logger log = Logger.getLogger(Speaker.class);
    private byte[] buffer = new byte[1024];
    private int bufferLen = 0;
    private SourceDataLine line;
    private byte beeper = 0;
    private byte oldBeeper;
    private int noChangeCount = 0;
    private int cycle = 0;
    private boolean installed = false;
    private int sample = 44100;
    private int cycles;
    private long clock;
    private int border = 0;
    private Screen screen = null;

    @Override
    public void init(Hardware parent) throws SIMException {
        super.init(parent);
        try {
            AudioFormat fmt = new AudioFormat(this.sample, 8, 1, false, false);
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, fmt);
            this.line = (SourceDataLine)AudioSystem.getLine(info);
            this.line.open(fmt);
            this.line.start();
            this.installed = true;
        }
        catch (Exception ex) {
            this.installed = false;
            log.warning(ex);
        }
    }

    @Override
    public void writeMemory(Memory m, int port, int value, int oldValue) throws SIMException {
        this.beeper = (byte)((value & 0x10) != 0 ? 255 : 0);
        if ((value & 7) != this.border) {
            this.border = value & 7;
            if (this.screen != null) {
                this.screen.setBorder(this.border);
            }
        }
    }

    @Override
    public void cycle(int n) {
        if (this.beeper == this.oldBeeper) {
            if ((long)this.noChangeCount > this.clock) {
                return;
            }
            this.noChangeCount += n;
        } else {
            this.oldBeeper = this.beeper;
            this.noChangeCount = 0;
        }
        this.cycle += n;
        while (this.cycle > this.cycles) {
            this.buffer[this.bufferLen] = this.beeper;
            if (++this.bufferLen >= this.buffer.length) {
                if (this.line.available() >= this.bufferLen) {
                    this.line.write(this.buffer, 0, this.bufferLen);
                }
                this.bufferLen = 0;
            }
            this.cycle -= this.cycles;
        }
    }

    void setScreen(Screen scr) {
        this.screen = scr;
    }

    private void setClock(long clock) {
        this.clock = clock;
        int ncycles = (int)(clock / (long)this.sample) / 2;
        if (ncycles != this.cycles) {
            this.cycles = ncycles;
            this.buffer = new byte[this.sample / 100];
            log.info("Cycles=" + this.cycles + " Sample=" + this.sample + " Clock=" + clock + " Buffer=" + this.buffer.length);
        }
    }

    @Override
    public void registerCPU(CPU _cpu) throws SIMException {
        super.registerCPU(_cpu);
        this.setClock(this.cpu.getClock());
        this.cpu.addIOWriteListener(254, this);
        if (this.installed) {
            this.cpu.addCycleListener(this);
        }
    }

    @Override
    public String toString() {
        return "Speaker driver installed=" + this.installed;
    }
}

