/*
 * Decompiled with CFR 0.152.
 */
package jmce.sinclair.spectrum;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import jmce.sim.AbstractPeripheral;
import jmce.sim.CPU;
import jmce.sim.Hardware;
import jmce.sim.Memory;
import jmce.sim.MemoryReadListener;
import jmce.sim.SIMException;
import jmce.sim.SwingHardware;
import jmce.sinclair.spectrum.Spectrum;
import jmce.sinclair.spectrum.SpectrumConstants;

public class SwingKeyboard
extends AbstractPeripheral
implements FocusListener,
KeyListener,
SpectrumConstants {
    private Spectrum spectrum;
    public static final int[][] keys = new int[][]{{49, 81, 65, 48, 80, 16, 10, 32}, {50, 87, 83, 57, 79, 90, 76, 17}, {51, 69, 68, 56, 73, 88, 75, 77}, {52, 82, 70, 55, 85, 67, 74, 78}, {53, 84, 71, 54, 89, 86, 72, 66}};
    static final int[] rows = new int[]{11, 10, 9, 12, 13, 8, 14, 15};
    private int[] keyState = new int[8];
    private Component comp = null;

    @Override
    public void init(Hardware parent) throws SIMException {
        super.init(parent);
        if (parent instanceof SwingHardware) {
            this.comp = ((SwingHardware)((Object)parent)).getComponent();
            if (this.comp != null) {
                this.comp.setFocusable(true);
                this.comp.addFocusListener(this);
                this.comp.addKeyListener(this);
            }
        }
    }

    @Override
    public void registerCPU(CPU cpu) throws SIMException {
        super.registerCPU(cpu);
        this.spectrum = (Spectrum)cpu;
        this.spectrum.addIOReadListener(254, new MemoryReadListener(){

            @Override
            public int readMemory(Memory m, int add, int value) throws SIMException {
                return SwingKeyboard.this.inb(add, SwingKeyboard.this.spectrum.getPortHI());
            }
        });
    }

    public int inb(int port, int hi) {
        int result = this.spectrum.getUla() | 0x1F;
        port &= 0xFF;
        port |= (hi & 0xFF) << 8;
        for (int i = 0; i < 8; ++i) {
            if ((port & 1 << rows[i]) != 0) continue;
            result &= this.keyState[i];
        }
        return result;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.dokey(e.getKeyCode(), true);
        e.consume();
    }

    public void dokey(int key, boolean mode) {
        block0: for (int r = 0; r < 5; ++r) {
            for (int c = 0; c < 8; ++c) {
                if (keys[r][c] != key) continue;
                this.dokey(r, c, mode);
                continue block0;
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.dokey(e.getKeyCode(), false);
        e.consume();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public void dokey(int r, int c, boolean pressed) {
        if (pressed) {
            int n = c;
            this.keyState[n] = this.keyState[n] & ~(1 << r);
        } else {
            int n = c;
            this.keyState[n] = this.keyState[n] | 1 << r;
        }
    }

    private void keyboardReset() {
        for (int i = 0; i < 8; ++i) {
            this.keyState[i] = 255;
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.keyboardReset();
    }

    @Override
    public void focusLost(FocusEvent e) {
    }
}

