/*
 * Decompiled with CFR 0.152.
 */
package jmce.sinclair.spectrum;

import jmce.sim.CPU;
import jmce.sim.CycleListener;
import jmce.sim.SIMException;
import jmce.sim.TapePulse;
import jmce.sim.tape.TapeFile;
import jmce.sim.tape.TapeTZX;
import jmce.sinclair.spectrum.Spectrum;
import jmce.util.Logger;

public class Tape
extends TapeFile
implements CycleListener {
    private static Logger log = Logger.getLogger(Tape.class);
    private int pulse;
    private Spectrum spectrum;
    private TapePulse tp;

    public Tape() {
        super("ZX-Tape");
        this.setConfig("sinclair/binvader.tzx");
        this.addDecoder(new TapeTZX());
    }

    @Override
    public void reset() throws SIMException {
        super.reset();
        this.pulse = 0;
        this.tp = null;
        this.stop();
        this.setPower(true);
    }

    @Override
    public void registerCPU(CPU cpu) throws SIMException {
        super.registerCPU(cpu);
        cpu.addCycleListener(this);
        this.spectrum = (Spectrum)cpu;
    }

    @Override
    public void cycle(int n) throws SIMException {
        if (!this.isPlay() || !this.getPower()) {
            return;
        }
        if (this.pulse < 0) {
            return;
        }
        while (n > 0) {
            if (this.pulse >= n) {
                this.pulse -= n;
                n = 0;
            } else {
                n -= this.pulse;
                this.pulse = 0;
            }
            if (this.pulse != 0) continue;
            if (this.tp != null) {
                switch (this.tp.getType()) {
                    case 1: {
                        this.spectrum.setTapeIn(false);
                        break;
                    }
                    case 2: {
                        this.spectrum.setTapeIn(true);
                        break;
                    }
                    case 3: {
                        this.spectrum.setTapeIn(!this.spectrum.getTapeIn());
                    }
                }
            }
            this.tp = this.nextPulse();
            if (this.tp == null) {
                this.pulse = -1;
                break;
            }
            this.pulse = this.tp.getWidth();
        }
    }
}

