/*
 * Decompiled with CFR 0.152.
 */
package jmce.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import jmce.swing.BitmapFont;
import jmce.swing.BitmapFont6x8;
import jmce.swing.KMatrixKeyboard;
import jmce.util.Timer;
import jmce.util.TimerListener;

public class KLcd
extends JComponent {
    private static final long serialVersionUID = 1L;
    private int numPages = 2;
    private int displayPage = 0;
    private int currentPage = 0;
    private int dotSize = 2;
    private int numRows = 4;
    private int numColumns = 20;
    private int hSpace = 1;
    private int vSpace = 1;
    BitmapFont font = null;
    private Color colorBack = new Color(0, 0, 255);
    private Color colorFront = new Color(255, 255, 255);
    private Color colorSpace = new Color(0, 0, 127);
    private Image[] imageChar = new Image[256];
    private int[] memory;
    private Dimension size = null;
    private int row;
    private int col;
    private boolean cursor;
    private boolean on = true;
    private boolean cursorBlink = true;
    private boolean cursorBlinkStatus = true;

    @Override
    public Dimension getPreferredSize() {
        if (this.size == null) {
            this.initInternal();
        }
        return this.size;
    }

    private void initInternal() {
        this.size = new Dimension((this.numColumns * this.font.getWidth() + (this.numColumns + 1) * this.hSpace) * this.dotSize, (this.numRows * this.font.getHeight() + (this.numRows + 1) * this.hSpace) * this.dotSize);
        for (int i = 0; i < 256; ++i) {
            Image img = this.createImage(this.font.getWidth() * this.dotSize, this.font.getHeight() * this.dotSize);
            Graphics g = img.getGraphics();
            g.setColor(this.colorBack);
            g.fillRect(0, 0, this.font.getWidth() * this.dotSize, this.font.getHeight() * this.dotSize);
            g.setColor(this.colorFront);
            for (int x = 0; x < this.font.getWidth(); ++x) {
                for (int y = 0; y < this.font.getHeight(); ++y) {
                    if (!this.font.getPixel(i, x, y)) continue;
                    g.fillRect(x * this.dotSize, y * this.dotSize, this.dotSize, this.dotSize);
                }
            }
            this.imageChar[i] = img;
        }
        this.memory = new int[this.numPages * this.numRows * this.numColumns];
        this.resetDisplay();
        Timer timer = new Timer(410, true, new TimerListener(){

            @Override
            public void timerExpired() {
                if (KLcd.this.cursorBlink) {
                    KLcd.this.cursorBlinkStatus = !KLcd.this.cursorBlinkStatus;
                    KLcd.this.repaint();
                }
            }
        });
        Timer.addTimer(timer);
    }

    void resetDisplay() {
        for (int i = 0; i < this.memory.length; ++i) {
            this.memory[i] = 32;
        }
        this.setCursor(0, 0);
        this.setCursor(true);
        this.setPage(0);
        this.repaint();
    }

    public void setCursor(int row, int col) {
        this.row = row;
        this.col = col;
        if (this.cursor) {
            this.repaint();
        }
    }

    public void setDisplay(boolean mode) {
        if (this.on != mode) {
            this.on = mode;
            this.repaint();
        }
    }

    public void setCursorBlink(boolean mode) {
        if (mode != this.cursorBlink) {
            this.cursorBlink = mode;
            this.repaint();
        }
    }

    public void setCursor(boolean mode) {
        if (mode != this.cursor) {
            this.cursor = mode;
            this.repaint();
        }
    }

    public void setPage(int p) {
        this.setCurrentPage(p);
        this.setDisplayPage(p);
    }

    public void setCurrentPage(int p) {
        this.currentPage = p;
    }

    public void setDisplayPage(int p) {
        if (this.displayPage != p) {
            this.displayPage = p;
            this.repaint();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        int base = this.displayPage * this.numRows * this.numColumns;
        Insets insets = this.getInsets();
        g.translate(insets.left, insets.top);
        g.setColor(this.colorSpace);
        g.fillRect(0, 0, this.size.width, this.size.height);
        if (!this.on) {
            return;
        }
        int y = this.vSpace * this.dotSize;
        for (int r = 0; r < this.numRows; ++r) {
            int x = this.hSpace * this.dotSize;
            for (int c = 0; c < this.numColumns; ++c) {
                g.drawImage(this.imageChar[this.memory[base + r * this.numColumns + c]], x, y, null);
                if (this.cursor && c == this.col && r == this.row && this.displayPage == this.currentPage) {
                    if (this.cursorBlink) {
                        if (this.cursorBlinkStatus) {
                            g.setColor(this.colorFront);
                            g.fillRect(x, y, this.font.getWidth() * this.dotSize, this.font.getHeight() * this.dotSize);
                        }
                    } else {
                        g.setColor(this.colorFront);
                        for (int i = 0; i < this.dotSize; ++i) {
                            int x1 = x;
                            int y1 = y + this.font.getHeight() * this.dotSize - i;
                            int x2 = x + this.font.getWidth() * this.dotSize;
                            int y2 = y1;
                            g.drawLine(x1, y1, x2, y2);
                        }
                    }
                }
                x += (this.font.getWidth() + this.hSpace) * this.dotSize;
            }
            y += (this.font.getHeight() + this.vSpace) * this.dotSize;
        }
    }

    public void putchar(int ch) {
        int base = this.currentPage * this.numRows * this.numColumns;
        this.memory[base + this.row * this.numColumns + this.col] = ch &= 0xFF;
        if (++this.col >= this.numColumns) {
            this.col = 0;
            if (++this.row >= this.numRows) {
                this.row = 0;
            }
        }
        if (this.currentPage == this.displayPage) {
            this.repaint();
        }
    }

    public void setFont(BitmapFont f) {
        this.font = f;
    }

    public int getNumColumns() {
        return this.numColumns;
    }

    public void setNumColumns(int n) {
        this.numColumns = n;
    }

    public int getNumRows() {
        return this.numRows;
    }

    public void setNumRows(int n) {
        this.numRows = n;
    }

    public KLcd() {
        this.setFont(new BitmapFont6x8());
    }

    public static void main(String[] argv) {
        JFrame f = new JFrame("Test KLCD $Id: KLcd.java 695 2011-09-21 06:09:11Z mviara $");
        KLcd lcd = new KLcd();
        KMatrixKeyboard kbd = new KMatrixKeyboard();
        JPanel p = new JPanel();
        p.add(lcd);
        p.add(kbd);
        f.setContentPane(p);
        f.pack();
        f.setVisible(true);
        int i = 65;
        for (int r = 0; r < lcd.numRows / 2; ++r) {
            for (int c = 0; c < lcd.numColumns; ++c) {
                lcd.putchar(i++);
            }
        }
        lcd.setCursor(1, 5);
    }
}

