/*
 * Decompiled with CFR 0.152.
 */
package jmce.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import jmce.swing.Repaintable;
import jmce.swing.Util;

public class KLed
extends JComponent
implements Repaintable {
    private static final long serialVersionUID = 1L;
    private int width = 16;
    private int border = 3;
    private boolean led = false;
    private boolean polarity = true;
    private static Color defaultColor = Color.RED;

    public KLed() {
        this(defaultColor);
    }

    public KLed(Color color) {
        this(color, 20);
    }

    public KLed(Color color, int w) {
        this(color, w, w / 5);
    }

    public KLed(Color color, int w, int b) {
        this.setForeground(color);
        this.setBackground(Color.black);
        this.width = w;
        this.border = b;
        this.setOpaque(true);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.width);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.width, this.width);
    }

    @Override
    public final void paintComponent(Graphics g) {
        Insets insets = this.getInsets();
        g.translate(insets.left, insets.top);
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.width, this.width);
        g.setColor(this.getForeground());
        if (this.led == this.polarity) {
            g.fillOval(this.border, this.border, this.width - this.border * 2, this.width - this.border * 2);
        } else {
            g.drawOval(this.border, this.border, this.width - this.border * 2, this.width - this.border * 2);
        }
    }

    public final void setLed(boolean mode) {
        if (mode != this.led) {
            this.led = mode;
            Util.repaintLater(this);
        }
    }

    public final boolean getLed() {
        return this.led;
    }

    public final void setPolarity(boolean mode) {
        this.polarity = mode;
        this.repaint();
    }

    @Override
    public void updateComponent() {
        this.repaint();
    }
}

