/*
 * Decompiled with CFR 0.152.
 */
package jmce.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.TitledBorder;
import jmce.swing.KLed;
import jmce.swing.Util;

public class KLeds
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final Font labelLedFont = new Font("Monospaced", 0, 10);
    public static final Font labelTitleFont = new Font("Monospaced", 1, 12);
    KLed[] leds;
    JLabel[] labels;

    public KLeds(String title, int n) {
        super(new GridBagLayout());
        int i;
        this.setOpaque(true);
        this.setBackground(Color.black);
        GridBagConstraints g = new GridBagConstraints();
        g.gridx = 0;
        g.gridy = 0;
        g.gridwidth = 1;
        g.gridheight = 1;
        g.anchor = 10;
        g.fill = 0;
        g.weightx = 1.0;
        g.weighty = 1.0;
        g.insets = new Insets(0, 0, 0, 0);
        this.leds = new KLed[n];
        this.labels = new JLabel[n];
        for (i = 0; i < n; ++i) {
            String s = "" + i;
            if (n > 10 && i < 10) {
                s = "0" + s;
            }
            this.labels[i] = new JLabel(s, 0);
            this.labels[i].setFont(labelLedFont);
            this.labels[i].setForeground(Color.white);
            this.labels[i].setBackground(Color.black);
            this.labels[i].setOpaque(true);
            this.leds[i] = new KLed();
        }
        for (i = 0; i < n; ++i) {
            g.gridy = 0;
            this.add((Component)this.labels[n - i - 1], g);
            g.gridy = 1;
            this.add((Component)this.leds[n - i - 1], g);
            ++g.gridx;
        }
        TitledBorder t = Util.setTitle(this, title, Color.cyan);
        t.setTitleFont(labelTitleFont);
    }

    public void setPolarity(boolean mode) {
        for (int i = 0; i < this.leds.length; ++i) {
            this.setPolarity(i, mode);
        }
    }

    public void setPolarity(int i, boolean mode) {
        this.leds[i].setPolarity(mode);
    }

    public void invertLeds() {
        for (int i = 0; i < this.leds.length; ++i) {
            this.invertLed(i);
        }
    }

    public void invertLed(int i) {
        this.leds[i].setLed(!this.leds[i].getLed());
    }

    public void setPaintLabels(boolean mode) {
        for (int i = 0; i < this.labels.length; ++i) {
            this.labels[i].setVisible(mode);
        }
    }

    public boolean getPaintLabels() {
        return this.labels[0].isVisible();
    }

    public void setLedColors(Color color) {
        for (int i = 0; i < this.leds.length; ++i) {
            this.setLedColor(i, color);
        }
    }

    public void setLedColor(int i, Color color) {
        this.leds[i].setForeground(color);
    }

    public void setLeds(int value) {
        int mask = 1;
        for (int i = 0; i < this.leds.length; ++i) {
            this.setLed(i, (value & mask) != 0);
            mask <<= 1;
        }
    }

    public void setLeds(boolean mode) {
        for (int i = 0; i < this.leds.length; ++i) {
            this.setLed(i, mode);
        }
    }

    public void setLed(int i, boolean mode) {
        this.leds[i].setLed(mode);
    }

    public boolean getLed(int i) {
        return this.leds[i].getLed();
    }

    public int getLedCount() {
        return this.leds.length;
    }

    public static void main(String[] argv) {
        final KLeds address = new KLeds("Address", 16);
        final KLeds test = new KLeds("No address", 20);
        test.setPaintLabels(false);
        for (int i = 0; i < test.getLedCount(); ++i) {
            if (i >= 0 && i <= 4) {
                test.setLedColor(i, new Color(255, 0, 0));
            }
            if (i >= 4 && i <= 8) {
                test.setLedColor(i, new Color(0, 255, 0));
            }
            if (i >= 8 && i <= 12) {
                test.setLedColor(i, new Color(0, 0, 255));
            }
            if (i >= 12 && i <= 16) {
                test.setLedColor(i, new Color(255, 255, 255));
            }
            if (i < 16 || i > 20) continue;
            test.setLedColor(i, new Color(255, 255, 0));
        }
        JPanel p = new JPanel();
        p.add(address);
        p.add(test);
        JFrame f = new JFrame("Led Test");
        f.setContentPane(p);
        f.pack();
        f.setVisible(true);
        Timer t = new Timer(500, new ActionListener(){
            int count = 0;

            @Override
            public void actionPerformed(ActionEvent e) {
                address.invertLeds();
                test.invertLeds();
                if (++this.count == 10) {
                    test.setLeds(true);
                }
            }
        });
        t.setRepeats(true);
        t.start();
    }
}

