/*
 * Decompiled with CFR 0.152.
 */
package jmce.swing;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import jmce.swing.KFixedField;

public class KLongField
extends KFixedField
implements KeyListener {
    private static final long serialVersionUID = 1L;

    public KLongField() {
        this(10);
    }

    public KLongField(int len) {
        super(len);
        this.setHorizontalAlignment(4);
        this.setValue(0L);
        this.addKeyListener(this);
    }

    public long getValue() {
        String s = this.getText();
        long value = 0L;
        try {
            value = Long.parseLong(s);
        }
        catch (Exception e) {
            // empty catch block
        }
        return value;
    }

    public void setValue(long value) {
        String s = "0";
        long old = 0L;
        try {
            s = Long.toString(value);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            old = this.getValue();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.setText(s);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.key(e);
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    private void key(KeyEvent e) {
        int offset = 0;
        if (this.isEditable()) {
            switch (e.getKeyCode()) {
                case 33: {
                    offset = 16;
                    break;
                }
                case 34: {
                    offset = -16;
                    break;
                }
                case 38: {
                    offset = 1;
                    break;
                }
                case 40: {
                    offset = -1;
                }
            }
            if (offset != 0) {
                try {
                    long value = this.getValue();
                    this.setValue(value + (long)offset & 0xFFFFL);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (offset != 0) {
            e.setKeyCode(10);
        }
    }
}

