/*
 * Decompiled with CFR 0.152.
 */
package jmce.swing;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import jmce.sim.AbstractPeripheral;
import jmce.util.Logger;

public class KeyboardMatrix
extends AbstractPeripheral
implements FocusListener,
KeyListener {
    private static Logger log = Logger.getLogger(KeyboardMatrix.class);
    protected int numRows = 16;
    private int numCols = 16;
    private int[][] keysMap = new int[16][16];
    protected int[] keyState = new int[16];
    protected int[][] keysLoc = new int[16][16];

    public KeyboardMatrix() {
        this.setName("Matrix Kbd");
        this.initKeyboard();
    }

    private void initKeyboard() {
        this.keysMap = new int[this.numRows][this.numCols];
        this.keysLoc = new int[this.numRows][this.numCols];
        this.keyState = new int[this.numRows];
        for (int r = 0; r < this.numRows; ++r) {
            for (int c = 0; c < this.numCols; ++c) {
                this.keysMap[r][c] = 0;
                this.keysLoc[r][c] = 0;
            }
        }
        this.resetKeyboard();
    }

    protected void resetKeyboard() {
        for (int i = 0; i < this.numRows; ++i) {
            this.keyState[i] = (1 << this.numCols) - 1;
        }
    }

    public void setNumRows(int r) {
        this.numRows = r;
        this.initKeyboard();
    }

    public void setNumCols(int c) {
        this.numCols = c;
        this.initKeyboard();
    }

    public void setComponent(Component c) {
        c.setFocusable(true);
        c.addFocusListener(this);
        c.addKeyListener(this);
    }

    public int getRow(int r) {
        return this.keyState[r];
    }

    public void setKeyLocation(int r, int c, int ... keys) {
        for (int k : keys) {
            this.keysLoc[r][c++] = k;
        }
    }

    public void setKey(int r, int c, int ... keys) {
        for (int k : keys) {
            this.keysMap[r][c++] = k;
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.resetKeyboard();
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.keyEvent(e, true);
        e.consume();
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.keyEvent(e, false);
        e.consume();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public void keyEvent(KeyEvent e, boolean pressed) {
        int key = e.getKeyCode();
        int loc = e.getKeyLocation();
        for (int r = 0; r < this.numRows; ++r) {
            for (int c = 0; c < this.numCols; ++c) {
                if (this.keysMap[r][c] == 0 || this.keysLoc[r][c] != 0 && this.keysLoc[r][c] != loc || this.keysMap[r][c] != key) continue;
                log.fine("Key=" + KeyEvent.getKeyText(e.getKeyCode()) + " Pressed=" + pressed + " R=" + r + " C=" + c);
                this.keyEvent(r, c, pressed);
                return;
            }
        }
    }

    protected void keyEvent(int r, int c, boolean pressed) {
        if (pressed) {
            int n = r;
            this.keyState[n] = this.keyState[n] & ~(1 << c);
        } else {
            int n = r;
            this.keyState[n] = this.keyState[n] | 1 << c;
        }
    }

    @Override
    public String toString() {
        return this.getName() + " R=" + this.numRows + " C=" + this.numCols;
    }
}

