/*
 * Decompiled with CFR 0.152.
 */
package jmce.z80pack;

import jmce.sim.CPU;
import jmce.sim.Memory;
import jmce.sim.MemoryReadListener;
import jmce.sim.MemoryWriteListener;
import jmce.sim.SIMException;
import jmce.sim.Serial;
import jmce.z80pack.Z80PackConstants;

public class Console
extends Serial
implements Z80PackConstants,
MemoryReadListener,
MemoryWriteListener {
    public Console() {
        this.setName("Z80pack Console");
    }

    @Override
    public void registerCPU(CPU cpu) throws SIMException {
        super.registerCPU(cpu);
        cpu.addIOWriteListener(1, this);
        cpu.addIOReadListener(1, this);
        cpu.addIOReadListener(0, this);
    }

    @Override
    public int readMemory(Memory m, int address, int value) throws SIMException {
        switch (address) {
            case 0: {
                this.setIdle();
                if (this.readyRead()) {
                    return 255;
                }
                return 0;
            }
            case 1: {
                this.setLive();
                return (Integer)this.read();
            }
        }
        return 0;
    }

    @Override
    public void writeMemory(Memory m, int address, int value, int oldValue) throws SIMException {
        switch (address) {
            case 1: {
                this.setLive();
                this.write(value);
            }
        }
    }

    @Override
    public String toString() {
        return "Z80Pack console Status=0 Data=1";
    }
}

