/*
 * Decompiled with CFR 0.152.
 */
package jmce.zilog.z80;

import jmce.intel.i8080.I8080;
import jmce.sim.SIMException;
import jmce.sim.cpu.AbstractOpcode;
import jmce.sim.cpu.MultiOpcode;
import jmce.sim.cpu.StandardRegister;
import jmce.util.Hex;

public class Z80
extends I8080 {
    private int A1;
    private int F1;
    private int BC1;
    private int DE1;
    private int HL1;
    public int IX;
    public int IY;
    public int I;
    public int R;
    private int interruptMode;

    public Z80() {
        this("Z80");
    }

    public Z80(String name) {
        super(name);
        this.setClock(4500000L);
    }

    @Override
    protected void initRegisters() {
        super.initRegisters();
        this.addRegister(new StandardRegister("IX", 3, 16, 0){

            @Override
            public int getRegister() {
                return Z80.this.IX;
            }

            @Override
            public void setRegister(int value) {
                Z80.this.IX = value;
            }
        });
        this.addRegister(new StandardRegister("IY", 3, 16, 0){

            @Override
            public int getRegister() {
                return Z80.this.IY;
            }

            @Override
            public void setRegister(int value) {
                Z80.this.IY = value;
            }
        });
        this.addRegister(new StandardRegister("I", 5, 8, 0){

            @Override
            public int getRegister() {
                return Z80.this.I;
            }

            @Override
            public void setRegister(int value) {
                Z80.this.I = value;
            }
        });
        this.addRegister(new StandardRegister("R", 5, 8, 0){

            @Override
            public int getRegister() {
                return (int)(Z80.this.getCycle() & 0xFFL);
            }

            @Override
            public void setRegister(int value) {
                Z80.this.R = value;
            }
        });
    }

    public final int I() {
        return this.I;
    }

    public final int srl(int value) {
        boolean c = (value & 1) != 0;
        this.F = booleanTable[value >>>= 1];
        this.FLAG_C(c);
        return value;
    }

    public final int sll(int value) {
        boolean c = (value & 0x80) != 0;
        value = (value << 1 | 1) & 0xFF;
        this.F = booleanTable[value];
        this.FLAG_C(c);
        return value;
    }

    public final int sra(int value) {
        boolean c = (value & 1) != 0;
        value = (value >>> 1 | value & 0x80) & 0xFF;
        this.F = booleanTable[value];
        this.FLAG_C(c);
        return value;
    }

    public final int sla(int value) {
        boolean c = (value & 0x80) != 0;
        value = value << 1 & 0xFF;
        this.F = booleanTable[value];
        this.FLAG_C(c);
        return value;
    }

    void rld() throws SIMException {
        int t = this.A;
        int m = this.getByte(this.HL);
        this.A = this.A & 0xF0 | (m & 0xF0) >>> 4;
        m = (m & 0xF) << 4 | t & 0xF;
        this.setByte(this.HL, m);
        this.FLAG_S((this.A & 0x80) != 0);
        this.FLAG_5((this.A & 0x20) != 0);
        this.FLAG_3((this.A & 8) != 0);
        this.FLAG_Z(this.A == 0);
        this.FLAG_H(false);
        this.FLAG_N(false);
        this.FLAG_V(parityTable[this.A]);
    }

    void rrd() throws SIMException {
        int t = this.A;
        int m = this.getByte(this.HL);
        this.A = this.A & 0xF0 | m & 0xF;
        m = m >>> 4 | (t & 0xF) << 4;
        this.setByte(this.HL, m);
        this.FLAG_S((this.A & 0x80) != 0);
        this.FLAG_5((this.A & 0x20) != 0);
        this.FLAG_3((this.A & 8) != 0);
        this.FLAG_Z(this.A == 0);
        this.FLAG_H(false);
        this.FLAG_N(false);
        this.FLAG_V(parityTable[this.A]);
    }

    private final void neg() {
        int t = this.A;
        this.A = -this.A & 0xFF;
        this.F = 0;
        this.FLAG_S((this.A & 0x80) != 0);
        this.FLAG_5((this.A & 0x20) != 0);
        this.FLAG_3((this.A & 8) != 0);
        this.FLAG_Z(this.A == 0);
        this.FLAG_H((t & 0xF) != 0);
        this.FLAG_V(t == 128);
        this.FLAG_N(true);
        this.FLAG_C(t != 0);
    }

    public final int res(int value, int bit) {
        return value & ~(1 << bit);
    }

    public final int set(int value, int bit) {
        return value | 1 << bit;
    }

    public final int bit(int value, int bit) {
        this.FLAG_Z((value &= 1 << bit) == 0);
        this.FLAG_S((value & 0x80) != 0);
        this.FLAG_H(true);
        this.FLAG_N(false);
        return value;
    }

    public final void ex_af_af1() {
        int v = this.F;
        this.F = this.F1;
        this.F1 = v;
        v = this.A;
        this.A = this.A1;
        this.A1 = v;
    }

    public final int im() {
        return this.interruptMode;
    }

    public final void im(int n) {
        this.interruptMode = n;
    }

    public final void exx() {
        int v = this.BC;
        this.BC = this.BC1;
        this.BC1 = v;
        v = this.DE;
        this.DE = this.DE1;
        this.DE1 = v;
        v = this.HL;
        this.HL = this.HL1;
        this.HL1 = v;
    }

    @Override
    protected void resetRegisters() throws SIMException {
        super.resetRegisters();
        this.HL1 = 0;
        this.DE1 = 0;
        this.BC1 = 0;
        this.F1 = 0;
        this.A1 = 0;
        this.im(1);
    }

    public final void cpSpecial(int v) {
        int savedF = this.F;
        this.cp(v);
        this.FLAG_C((savedF & 1) != 0);
        this.FLAG_V((savedF & 4) != 0);
    }

    public void cpi() throws SIMException {
        this.cpSpecial(this.getByte(this.HL));
        this.HL = this.HL + 1 & 0xFFFF;
        this.BC = this.BC - 1 & 0xFFFF;
        this.FLAG_V(this.BC != 0);
    }

    public void cpd() throws SIMException {
        this.cpSpecial(this.getByte(this.HL));
        this.HL = this.HL - 1 & 0xFFFF;
        this.BC = this.BC - 1 & 0xFFFF;
        this.FLAG_V(this.BC != 0);
    }

    public void ind() throws SIMException {
        int v = this.in(this.BC & 0xFF, this.BC >> 8);
        this.setByte(this.HL, v);
        this.HL = this.HL - 1 & 0xFFFF;
        v = (this.BC >>> 8) - 1 & 0xFF;
        this.b(v);
        this.FLAG_Z(v == 0);
        this.FLAG_N(true);
    }

    public void ini() throws SIMException {
        int v = this.in(this.BC & 0xFF, this.BC >> 8);
        this.setByte(this.HL, v);
        this.HL = this.HL + 1 & 0xFFFF;
        v = (this.BC >>> 8) - 1 & 0xFF;
        this.b(v);
        this.FLAG_Z(v == 0);
        this.FLAG_N(true);
    }

    public void outd() throws SIMException {
        int v = (this.BC >>> 8) - 1 & 0xFF;
        this.b(v);
        this.out(this.BC & 0xFF, this.BC >> 8, this.getByte(this.HL));
        this.HL = this.HL - 1 & 0xFFFF;
        this.FLAG_Z(v == 0);
        this.FLAG_N(true);
    }

    public void outi() throws SIMException {
        int v = (this.BC >>> 8) - 1 & 0xFF;
        this.b(v);
        this.out(this.BC & 0xFF, this.BC >> 8, this.getByte(this.HL));
        this.HL = this.HL + 1 & 0xFFFF;
        this.FLAG_Z(v == 0);
        this.FLAG_N(true);
    }

    public void ldi() throws SIMException {
        this.setByte(this.DE, this.getByte(this.HL));
        this.HL = this.HL + 1 & 0xFFFF;
        this.DE = this.DE + 1 & 0xFFFF;
        this.BC = this.BC - 1 & 0xFFFF;
        this.FLAG_H(false);
        this.FLAG_N(false);
        this.FLAG_5(false);
        this.FLAG_3(false);
        this.FLAG_V(this.BC != 0);
    }

    public void ldd() throws SIMException {
        this.setByte(this.DE, this.getByte(this.HL));
        this.HL = this.HL - 1 & 0xFFFF;
        this.DE = this.DE - 1 & 0xFFFF;
        this.BC = this.BC - 1 & 0xFFFF;
        this.FLAG_H(false);
        this.FLAG_N(false);
        this.FLAG_5(false);
        this.FLAG_3(false);
        this.FLAG_V(this.BC != 0);
    }

    private void initOpcodes_ED() {
        int i;
        MultiOpcode ed = new MultiOpcode(237);
        for (i = 0; i < 8; ++i) {
            if (i == 6) continue;
            ed.setOpcode(new AbstractOpcode(0x41 | i << 3, 2, 9, "OUT\t(C),%1%rr3"){

                @Override
                public int exec(int pc) throws SIMException {
                    Z80.this.out(Z80.this.BC & 0xFF, Z80.this.BC >> 8, Z80.this.getValueRRR(this.opcode >> 3));
                    return 9;
                }
            });
            ed.setOpcode(new AbstractOpcode(0x40 | i << 3, 2, 9, "IN\t%1%rr3,(C)"){

                @Override
                public int exec(int pc) throws SIMException {
                    int n = Z80.this.in(Z80.this.BC & 0xFF, Z80.this.BC >> 8);
                    Z80.this.FLAG_S((n & 0x80) != 0);
                    Z80.this.FLAG_Z(n == 0);
                    Z80.this.FLAG_H(false);
                    Z80.this.FLAG_V(parityTable[n]);
                    Z80.this.FLAG_N(false);
                    Z80.this.setValueRRR(this.opcode >> 3, n);
                    return 9;
                }
            });
        }
        ed.setOpcode(new AbstractOpcode(71, 2, 9, "LD\tI,A"){

            @Override
            public int exec(int pc) throws SIMException {
                Z80.this.I = Z80.this.A;
                return 9;
            }
        });
        ed.setOpcode(new AbstractOpcode(87, 2, 9, "LD\tA,I"){

            @Override
            public int exec(int pc) throws SIMException {
                Z80.this.A = Z80.this.I;
                Z80.this.F = booleanTable[Z80.this.A];
                Z80.this.FLAG_V(Z80.this.iff2);
                return 9;
            }
        });
        ed.setOpcode(new AbstractOpcode(79, 2, 9, "LD\tA,R"){

            @Override
            public int exec(int pc) throws SIMException {
                Z80.this.R = (int)(Z80.this.getCycle() & 0xFFL);
                return 9;
            }
        });
        ed.setOpcode(new AbstractOpcode(95, 2, 9, "LD\tA,R"){

            @Override
            public int exec(int pc) throws SIMException {
                Z80.this.A = Z80.this.R;
                Z80.this.F = booleanTable[Z80.this.A];
                Z80.this.FLAG_V(Z80.this.iff2);
                return 9;
            }
        });
        ed.setOpcode(new AbstractOpcode(111, 2, 18, "RLD\t(HL)"){

            @Override
            public int exec(int pc) throws SIMException {
                Z80.this.rld();
                return 18;
            }
        });
        ed.setOpcode(new AbstractOpcode(103, 2, 18, "RRD\t(HL)"){

            @Override
            public int exec(int pc) throws SIMException {
                Z80.this.rrd();
                return 18;
            }
        });
        ed.setOpcode(new AbstractOpcode(68, 2, 8, "NEG"){

            @Override
            public int exec(int pc) throws SIMException {
                Z80.this.neg();
                return 8;
            }
        });
        ed.setOpcode(new AbstractOpcode(76, 2, 8, "NEG"){

            @Override
            public int exec(int pc) throws SIMException {
                Z80.this.neg();
                return 8;
            }
        });
        ed.setOpcode(new AbstractOpcode(84, 2, 8, "NEG"){

            @Override
            public int exec(int pc) throws SIMException {
                Z80.this.neg();
                return 8;
            }
        });
        ed.setOpcode(new AbstractOpcode(92, 2, 8, "NEG"){

            @Override
            public int exec(int pc) throws SIMException {
                Z80.this.neg();
                return 8;
            }
        });
        ed.setOpcode(new AbstractOpcode(100, 2, 8, "NEG"){

            @Override
            public int exec(int pc) throws SIMException {
                Z80.this.neg();
                return 8;
            }
        });
        ed.setOpcode(new AbstractOpcode(108, 2, 8, "NEG"){

            @Override
            public int exec(int pc) throws SIMException {
                Z80.this.neg();
                return 8;
            }
        });
        ed.setOpcode(new AbstractOpcode(116, 2, 8, "NEG"){

            @Override
            public int exec(int pc) throws SIMException {
                Z80.this.neg();
                return 8;
            }
        });
        ed.setOpcode(new AbstractOpcode(124, 2, 8, "NEG"){

            @Override
            public int exec(int pc) throws SIMException {
                Z80.this.neg();
                return 8;
            }
        });
        ed.setOpcode(new AbstractOpcode(69, 2, 14, "RETN"){

            @Override
            public int exec(int pc) throws SIMException {
                Z80.this.pc(Z80.this.pop());
                Z80.this.iff1 = Z80.this.iff2;
                return 14;
            }
        });
        ed.setOpcode(new AbstractOpcode(77, 2, 14, "RETI"){

            @Override
            public int exec(int pc) throws SIMException {
                Z80.this.pc(Z80.this.pop());
                return 20;
            }
        });
        for (i = 0; i < 4; ++i) {
            ed.setOpcode(new AbstractOpcode(0x43 | i << 4, 4, 20, "LD\t(%2%word),%-2%pp"){

                @Override
                public final int exec(int pc) throws SIMException {
                    Z80.this.setWord(Z80.this.getWord(pc + 2), Z80.this.getValuePP(this.opcode));
                    return 20;
                }
            });
            ed.setOpcode(new AbstractOpcode(0x42 | i << 4, 2, 15, "SBC\tHL,%1%pp"){

                @Override
                public int exec(int pc) throws SIMException {
                    Z80.this.HL = Z80.this.sbc16(Z80.this.HL, Z80.this.getValuePP(this.opcode), Z80.this.FLAG_C() ? 1 : 0);
                    return 11;
                }
            });
            ed.setOpcode(new AbstractOpcode(0x4A | i << 4, 2, 15, "ADC\tHL,%1%pp"){

                @Override
                public int exec(int pc) throws SIMException {
                    Z80.this.HL = Z80.this.adc16(Z80.this.HL, Z80.this.getValuePP(this.opcode), Z80.this.FLAG_C() ? 1 : 0);
                    return 15;
                }
            });
            ed.setOpcode(new AbstractOpcode(0x4B | i << 4, 4, 20, "LD\t%1%pp,(%word)"){

                @Override
                public int exec(int pc) throws SIMException {
                    Z80.this.setValuePP(this.opcode, Z80.this.getWord(Z80.this.getWord(pc + 2)));
                    return 20;
                }
            });
        }
        ed.setOpcode(new AbstractOpcode(176, 2, 21, "LDIR"){

            @Override
            public int exec(int pc) throws SIMException {
                Z80.this.ldi();
                if (Z80.this.BC != 0) {
                    Z80.this.pc(pc);
                    return 21;
                }
                return 16;
            }
        });
        ed.setOpcode(new AbstractOpcode(169, 2, 21, "CPD"){

            @Override
            public int exec(int pc) throws SIMException {
                Z80.this.cpd();
                return 16;
            }
        });
        ed.setOpcode(new AbstractOpcode(185, 2, 21, "CPDR"){

            @Override
            public int exec(int pc) throws SIMException {
                Z80.this.cpd();
                if (Z80.this.BC != 0 && !Z80.this.FLAG_Z()) {
                    Z80.this.pc(pc);
                    return 21;
                }
                return 16;
            }
        });
        ed.setOpcode(new AbstractOpcode(161, 2, 21, "CPI"){

            @Override
            public int exec(int pc) throws SIMException {
                Z80.this.cpi();
                return 16;
            }
        });
        ed.setOpcode(new AbstractOpcode(177, 2, 21, "CPIR"){

            @Override
            public int exec(int pc) throws SIMException {
                Z80.this.cpi();
                if (Z80.this.BC != 0 && !Z80.this.FLAG_Z()) {
                    Z80.this.pc(pc);
                    return 21;
                }
                return 16;
            }
        });
        ed.setOpcode(new AbstractOpcode(163, 2, 21, "OUTI"){

            @Override
            public int exec(int pc) throws SIMException {
                Z80.this.outi();
                return 16;
            }
        });
        ed.setOpcode(new AbstractOpcode(179, 2, 21, "OTIR"){

            @Override
            public int exec(int pc) throws SIMException {
                Z80.this.outi();
                if ((Z80.this.BC >>> 8 & 0xFF) != 0) {
                    Z80.this.pc(pc);
                }
                return 16;
            }
        });
        ed.setOpcode(new AbstractOpcode(171, 2, 21, "OUTD"){

            @Override
            public int exec(int pc) throws SIMException {
                Z80.this.outd();
                return 16;
            }
        });
        ed.setOpcode(new AbstractOpcode(187, 2, 21, "OTDR"){

            @Override
            public int exec(int pc) throws SIMException {
                Z80.this.outd();
                if ((Z80.this.BC >>> 8 & 0xFF) != 0) {
                    Z80.this.pc(pc);
                }
                return 16;
            }
        });
        ed.setOpcode(new AbstractOpcode(162, 2, 21, "INI"){

            @Override
            public int exec(int pc) throws SIMException {
                Z80.this.ini();
                return 16;
            }
        });
        ed.setOpcode(new AbstractOpcode(178, 2, 21, "INIR"){

            @Override
            public int exec(int pc) throws SIMException {
                Z80.this.ini();
                if ((Z80.this.BC >>> 8 & 0xFF) != 0) {
                    Z80.this.pc(pc);
                }
                return 16;
            }
        });
        ed.setOpcode(new AbstractOpcode(170, 2, 21, "IND"){

            @Override
            public int exec(int pc) throws SIMException {
                Z80.this.ind();
                return 16;
            }
        });
        ed.setOpcode(new AbstractOpcode(186, 2, 21, "INDR"){

            @Override
            public int exec(int pc) throws SIMException {
                Z80.this.ind();
                if ((Z80.this.BC >>> 8 & 0xFF) != 0) {
                    Z80.this.pc(pc);
                }
                return 16;
            }
        });
        ed.setOpcode(new AbstractOpcode(160, 2, 21, "LDI"){

            @Override
            public int exec(int pc) throws SIMException {
                Z80.this.ldi();
                return 16;
            }
        });
        ed.setOpcode(new AbstractOpcode(168, 2, 21, "LDD"){

            @Override
            public int exec(int pc) throws SIMException {
                Z80.this.ldd();
                return 16;
            }
        });
        ed.setOpcode(new AbstractOpcode(184, 2, 21, "LDDR"){

            @Override
            public int exec(int pc) throws SIMException {
                Z80.this.ldd();
                if (Z80.this.BC != 0) {
                    Z80.this.pc(pc);
                    return 21;
                }
                return 16;
            }
        });
        ed.setOpcode(new AbstractOpcode(70, 2, 8, "IM\t0"){

            @Override
            public int exec(int pc) throws SIMException {
                Z80.this.im(0);
                return 8;
            }
        });
        ed.setOpcode(new AbstractOpcode(86, 2, 8, "IM\t1"){

            @Override
            public int exec(int pc) throws SIMException {
                Z80.this.im(1);
                return 8;
            }
        });
        ed.setOpcode(new AbstractOpcode(94, 2, 8, "IM\t2"){

            @Override
            public int exec(int pc) throws SIMException {
                Z80.this.im(2);
                return 8;
            }
        });
        this.setOpcode(ed);
    }

    private void addIndexAlu(MultiOpcode m, IndexRegister id, int opcode, String s, ALU alu) {
        m.setOpcode(new AbstractIndexALUidH(id, opcode + 0, 2, 10, s + "\tA," + id.name() + "H", alu));
        m.setOpcode(new AbstractIndexALUidL(id, opcode + 1, 2, 10, s + "\tA," + id.name() + "L", alu));
        m.setOpcode(new AbstractIndexALUidOffset(id, opcode + 2, 3, 15, s + "\tA,(" + id.name() + "+%1%offset)", alu));
    }

    void addIndex8Alu(MultiOpcode m, IndexRegister xy, int opcode, String s, OP1 op1) {
        for (int i = 0; i < 256; ++i) {
            MultiOpcode m1 = (MultiOpcode)m.getOpcode(i);
            if (m1 == null) {
                m1 = new MultiOpcode(i);
                m.setOpcode(m1);
            }
            for (int r = 0; r < 8; ++r) {
                m1.setOpcode(new AbstractIndexOp1(xy, opcode | r, 4, 10, s + "(" + xy.name() + "+%1%byte)", op1){

                    @Override
                    public int exec(int pc) throws SIMException {
                        int i = Z80.this.addOffset(this.getXY(), Z80.this.getByte(pc + 2));
                        this.op1.op1(Z80.this.getByte(i));
                        return 10;
                    }
                });
            }
        }
    }

    void addIndexRrrAlu(MultiOpcode m, IndexRegister xy, int opcode, String s, OP1 op1) {
        for (int i = 0; i < 256; ++i) {
            MultiOpcode m1 = (MultiOpcode)m.getOpcode(i);
            if (m1 == null) {
                m1 = new MultiOpcode(i);
                m.setOpcode(m1);
            }
            for (int r = 0; r < 8; ++r) {
                if (r != 6) {
                    m1.setOpcode(new AbstractIndexOp1(xy, opcode | r, 4, 10, "LD\t%1%rrr," + s + "(" + xy.name() + "+%1%byte)", op1){

                        @Override
                        public int exec(int pc) throws SIMException {
                            int i = Z80.this.addOffset(this.getXY(), Z80.this.getByte(pc + 2));
                            int v = Z80.this.getByte(i);
                            v = this.op1.op1(v);
                            Z80.this.setValueRRR(this.opcode, v);
                            Z80.this.setByte(i, v);
                            return 10;
                        }
                    });
                    continue;
                }
                m1.setOpcode(new AbstractIndexOp1(xy, opcode | r, 4, 10, s + "(" + xy.name() + "+%1%byte)", op1){

                    @Override
                    public int exec(int pc) throws SIMException {
                        int i = Z80.this.addOffset(this.getXY(), Z80.this.getByte(pc + 2));
                        int v = Z80.this.getByte(i);
                        v = this.op1.op1(v);
                        Z80.this.setByte(i, v);
                        return 10;
                    }
                });
            }
        }
    }

    private void initOpcodeIdCB(MultiOpcode m, IndexRegister id) {
        MultiOpcode cb = new MultiOpcode(203);
        m.setOpcode(cb);
        for (int i = 0; i < 256; ++i) {
            MultiOpcode m1 = (MultiOpcode)cb.getOpcode(i);
            if (m1 != null) continue;
            m1 = new MultiOpcode(i);
            cb.setOpcode(m1);
        }
        for (int b = 0; b < 8; ++b) {
            this.addIndex8Alu(cb, id, 64 + b * 8, "BIT \t" + b + ",", new OP1BIT(b){

                @Override
                public int op1(int value) {
                    return Z80.this.bit(value, this.bit);
                }
            });
            this.addIndexRrrAlu(cb, id, 192 + b * 8, "SET \t" + b + ",", new OP1BIT(b){

                @Override
                public int op1(int value) {
                    return Z80.this.set(value, this.bit);
                }
            });
            this.addIndexRrrAlu(cb, id, 128 + b * 8, "RES \t" + b + ",", new OP1BIT(b){

                @Override
                public int op1(int value) {
                    return Z80.this.res(value, this.bit);
                }
            });
        }
        this.addIndexRrrAlu(cb, id, 0, "RLC", new OP1(){

            @Override
            public int op1(int value) {
                return Z80.this.rlc(value);
            }
        });
        this.addIndexRrrAlu(cb, id, 8, "RRC", new OP1(){

            @Override
            public int op1(int value) {
                return Z80.this.rrc(value);
            }
        });
        this.addIndexRrrAlu(cb, id, 16, "RL", new OP1(){

            @Override
            public int op1(int value) {
                return Z80.this.rl(value);
            }
        });
        this.addIndexRrrAlu(cb, id, 24, "RR", new OP1(){

            @Override
            public int op1(int value) {
                return Z80.this.rr(value);
            }
        });
        this.addIndexRrrAlu(cb, id, 32, "SLA", new OP1(){

            @Override
            public int op1(int value) {
                return Z80.this.sla(value);
            }
        });
        this.addIndexRrrAlu(cb, id, 40, "SRA", new OP1(){

            @Override
            public int op1(int value) {
                return Z80.this.sra(value);
            }
        });
        this.addIndexRrrAlu(cb, id, 48, "SLL", new OP1(){

            @Override
            public int op1(int value) {
                return Z80.this.sll(value);
            }
        });
        this.addIndexRrrAlu(cb, id, 56, "SRL", new OP1(){

            @Override
            public int op1(int value) {
                return Z80.this.srl(value);
            }
        });
    }

    private void initOpcodeXY(MultiOpcode m, IndexRegister id) {
        int i;
        this.initOpcodeIdCB(m, id);
        for (i = 64; i < 68; ++i) {
            m.setOpcode(new SKIP(i));
        }
        for (i = 71; i < 76; ++i) {
            m.setOpcode(new SKIP(i));
        }
        for (i = 79; i < 84; ++i) {
            m.setOpcode(new SKIP(i));
        }
        for (i = 87; i < 92; ++i) {
            m.setOpcode(new SKIP(i));
        }
        m.setOpcode(new SKIP(95));
        for (i = 120; i < 124; ++i) {
            m.setOpcode(new SKIP(i));
        }
        for (i = 127; i < 132; ++i) {
            m.setOpcode(new SKIP(i));
        }
        m.setOpcode(new AbstractIndex(id, 227, 2, 20, "EX\t(SP)," + id.name()){

            @Override
            public int exec(int pc) throws SIMException {
                int tmp = Z80.this.getByte(Z80.this.SP);
                Z80.this.setByte(Z80.this.SP, this.getXY() & 0xFF);
                this.setXYL(tmp);
                tmp = Z80.this.getByte(Z80.this.SP + 1);
                Z80.this.setByte(Z80.this.SP + 1, this.getXY() >>> 8);
                this.setXYH(tmp);
                return 20;
            }
        });
        m.setOpcode(new AbstractIndex(id, 249, 2, 8, "LD\tSP," + id.name()){

            @Override
            public int exec(int pc) throws SIMException {
                Z80.this.SP = this.getXY();
                return 8;
            }
        });
        m.setOpcode(new AbstractIndex(id, 34, 4, 22, "LD\t%1(%word%)," + id.name()){

            @Override
            public int exec(int pc) throws SIMException {
                Z80.this.setWord(Z80.this.getWord(pc + 2), this.getXY());
                return 22;
            }
        });
        m.setOpcode(new AbstractIndex(id, 42, 4, 20, "LD\t" + id.name() + ",%1(%word%)"){

            @Override
            public int exec(int pc) throws SIMException {
                this.setXY(Z80.this.getWord(Z80.this.getWord(pc + 2)));
                return 20;
            }
        });
        m.setOpcode(new AbstractIndex(id, 43, 2, 10, "DEC\t" + id.name()){

            @Override
            public int exec(int pc) throws SIMException {
                this.setXY(this.getXY() - 1 & 0xFFFF);
                return 10;
            }
        });
        m.setOpcode(new AbstractIndex(id, 35, 2, 10, "INC\t" + id.name()){

            @Override
            public int exec(int pc) throws SIMException {
                this.setXY(this.getXY() + 1 & 0xFFFF);
                return 10;
            }
        });
        m.setOpcode(new AbstractIndex(id, 52, 3, 23, "INC\t(" + id.name() + "+%1%byte)"){

            @Override
            public int exec(int pc) throws SIMException {
                int i = this.getXYOffset(pc + 2);
                Z80.this.setByte(i, Z80.this.inc(Z80.this.getByte(i)));
                return 23;
            }
        });
        m.setOpcode(new AbstractIndex(id, 53, 3, 23, "DEC\t(" + id.name() + "+%1%byte)"){

            @Override
            public int exec(int pc) throws SIMException {
                int i = this.getXYOffset(pc + 2);
                Z80.this.setByte(i, Z80.this.dec(Z80.this.getByte(i)));
                return 23;
            }
        });
        m.setOpcode(new AbstractIndex(id, 54, 4, 19, "LD\t(" + id.name() + "+%1%byte),%byte"){

            @Override
            public int exec(int pc) throws SIMException {
                int i = this.getXYOffset(pc + 2);
                Z80.this.setByte(i, Z80.this.getByte(pc + 3));
                return 19;
            }
        });
        this.addIndexAlu(m, id, 148, "SUB", new ALU(){

            @Override
            public void alu(int v) {
                Z80.this.sub8(v);
            }
        });
        this.addIndexAlu(m, id, 156, "SBC", new ALU(){

            @Override
            public void alu(int v) {
                Z80.this.sbc8(v, Z80.this.FLAG_C() ? 1 : 0);
            }
        });
        this.addIndexAlu(m, id, 132, "ADD", new ALU(){

            @Override
            public void alu(int v) {
                Z80.this.add8(v);
            }
        });
        this.addIndexAlu(m, id, 140, "ADC", new ALU(){

            @Override
            public void alu(int v) {
                Z80.this.adc8(v, Z80.this.FLAG_C() ? 1 : 0);
            }
        });
        this.addIndexAlu(m, id, 164, "AND", new ALU(){

            @Override
            public void alu(int v) {
                Z80.this.and(v);
            }
        });
        this.addIndexAlu(m, id, 172, "XOR", new ALU(){

            @Override
            public void alu(int v) {
                Z80.this.xor(v);
            }
        });
        this.addIndexAlu(m, id, 180, "OR", new ALU(){

            @Override
            public void alu(int v) {
                Z80.this.or(v);
            }
        });
        this.addIndexAlu(m, id, 188, "CP", new ALU(){

            @Override
            public void alu(int v) {
                Z80.this.cp(v);
            }
        });
        m.setOpcode(new AbstractIndex(id, 46, 3, 15, "LD\t" + id.name() + "L,%1%byte"){

            @Override
            public int exec(int pc) throws SIMException {
                int id = this.getXY();
                id = Z80.this.getByte(pc + 2) | id & 0xFF00;
                this.setXY(id);
                return 10;
            }
        });
        m.setOpcode(new AbstractIndex(id, 38, 3, 15, "LD\t" + id.name() + "H,%1%byte"){

            @Override
            public int exec(int pc) throws SIMException {
                int id = this.getXY();
                id = Z80.this.getByte(pc + 2) << 8 | id & 0xFF;
                this.setXY(id);
                return 10;
            }
        });
        m.setOpcode(new AbstractIndex(id, 44, 2, 15, "INC\t" + id.name() + "L"){

            @Override
            public int exec(int pc) throws SIMException {
                int id = this.getXY();
                id = Z80.this.inc(id & 0xFF) | id & 0xFF00;
                this.setXY(id);
                return 10;
            }
        });
        m.setOpcode(new AbstractIndex(id, 45, 2, 15, "DEC\t" + id.name() + "L"){

            @Override
            public int exec(int pc) throws SIMException {
                int id = this.getXY();
                id = Z80.this.dec(id & 0xFF) | id & 0xFF00;
                this.setXY(id);
                return 10;
            }
        });
        m.setOpcode(new AbstractIndex(id, 37, 2, 15, "DEC\t" + id.name() + "H"){

            @Override
            public int exec(int pc) throws SIMException {
                int id = this.getXY();
                id = Z80.this.dec(id >> 8) << 8 | id & 0xFF;
                this.setXY(id);
                return 10;
            }
        });
        m.setOpcode(new AbstractIndex(id, 36, 2, 15, "INC\t" + id.name() + "H"){

            @Override
            public int exec(int pc) throws SIMException {
                int id = this.getXY();
                id = Z80.this.inc(id >> 8) << 8 | id & 0xFF;
                this.setXY(id);
                return 10;
            }
        });
        for (i = 0; i < 4; ++i) {
            if (i != 2) {
                m.setOpcode(new AbstractIndex(id, 9 | i << 4, 2, 15, "ADD\t" + id.name() + ",%1%pp"){

                    @Override
                    public int exec(int pc) throws SIMException {
                        this.setXY(Z80.this.add16(this.getXY(), Z80.this.getValuePP(this.opcode)));
                        return 20;
                    }
                });
                continue;
            }
            m.setOpcode(new AbstractIndex(id, 9 | i << 4, 2, 15, "ADD\t" + id.name() + "," + id.name()){

                @Override
                public int exec(int pc) throws SIMException {
                    this.setXY(Z80.this.add16(this.getXY(), this.getXY()));
                    return 20;
                }
            });
        }
        block12: for (i = 0; i < 8; ++i) {
            if (i != 6) {
                m.setOpcode(new AbstractIndex(id, 0x46 | i << 3, 3, 19, "LD\t%1%rr3,(" + id.name() + "+%byte)"){

                    @Override
                    public int exec(int pc) throws SIMException {
                        int offset = Z80.this.getByte(pc + 2);
                        offset = Z80.this.addOffset(this.getXY(), offset);
                        Z80.this.setValueRRR(this.opcode >> 3, Z80.this.getByte(offset));
                        return 19;
                    }
                });
                m.setOpcode(new AbstractIndex(id, 0x70 | i, 3, 19, "LD\t(" + id.name() + "+%1%byte),%-2%rrr"){

                    @Override
                    public int exec(int pc) throws SIMException {
                        int offset = Z80.this.getByte(pc + 2);
                        offset = Z80.this.addOffset(this.getXY(), offset);
                        Z80.this.setByte(offset, Z80.this.getValueRRR(this.opcode));
                        return 19;
                    }
                });
            }
            switch (i) {
                case 6: {
                    continue block12;
                }
                case 5: {
                    m.setOpcode(new AbstractIndex(id, 109, 2, 10, "LD\t" + id.name() + "L," + id.name() + "L"){

                        @Override
                        public int exec(int pc) throws SIMException {
                            return 10;
                        }
                    });
                    m.setOpcode(new AbstractIndex(id, 101, 2, 10, "LD\t" + id.name() + "H," + id.name() + "H"){

                        @Override
                        public int exec(int pc) throws SIMException {
                            this.setXY(this.getXY() & 0xFF | (this.getXY() & 0xFF) << 8);
                            return 10;
                        }
                    });
                    continue block12;
                }
                case 4: {
                    m.setOpcode(new AbstractIndex(id, 108, 2, 10, "LD\t" + id.name() + "L," + id.name() + "H"){

                        @Override
                        public int exec(int pc) throws SIMException {
                            this.setXYL(this.getXYH());
                            return 10;
                        }
                    });
                    m.setOpcode(new AbstractIndex(id, 100, 2, 10, "LD\t" + id.name() + "H," + id.name() + "H"){

                        @Override
                        public int exec(int pc) throws SIMException {
                            return 10;
                        }
                    });
                    continue block12;
                }
                default: {
                    m.setOpcode(new AbstractIndex(id, 0x68 | i, 2, 10, "LD\t" + id.name() + "L,%1%rrr"){

                        @Override
                        public int exec(int pc) throws SIMException {
                            this.setXYL(Z80.this.getValueRRR(this.opcode));
                            return 10;
                        }
                    });
                    m.setOpcode(new AbstractIndex(id, 0x60 | i, 2, 10, "LD\t" + id.name() + "H,%1%rrr"){

                        @Override
                        public int exec(int pc) throws SIMException {
                            this.setXYH(Z80.this.getValueRRR(this.opcode));
                            return 10;
                        }
                    });
                    m.setOpcode(new AbstractIndex(id, 0x44 | i << 3, 2, 10, "LD\t%1%rr3," + id.name() + "H"){

                        @Override
                        public int exec(int pc) throws SIMException {
                            Z80.this.setValueRRR(this.opcode >> 3, this.getXY() >> 8);
                            return 10;
                        }
                    });
                    m.setOpcode(new AbstractIndex(id, 0x45 | i << 3, 2, 10, "LD\t%1%rr3," + id.name() + "L"){

                        @Override
                        public int exec(int pc) throws SIMException {
                            Z80.this.setValueRRR(this.opcode >> 3, this.getXY() & 0xFF);
                            return 10;
                        }
                    });
                }
            }
        }
        m.setOpcode(new AbstractIndex(id, 233, 2, 8, "JP\t" + id.name()){

            @Override
            public int exec(int pc) throws SIMException {
                Z80.this.pc(this.getXY());
                return 8;
            }
        });
        m.setOpcode(new AbstractIndex(id, 229, 2, 10, "PUSH\t" + id.name()){

            @Override
            public int exec(int pc) throws SIMException {
                Z80.this.push(this.getXY());
                return 10;
            }
        });
        m.setOpcode(new AbstractIndex(id, 225, 2, 10, "POP\t" + id.name()){

            @Override
            public int exec(int pc) throws SIMException {
                this.setXY(Z80.this.pop());
                return 10;
            }
        });
        m.setOpcode(new AbstractIndex(id, 33, 4, 14, "LD\t" + id.name() + ",%1%word"){

            @Override
            public int exec(int pc) throws SIMException {
                this.setXY(Z80.this.getWord(pc + 2));
                return 14;
            }
        });
    }

    private void initOpcodes_FD() {
        MultiOpcode fd = new MultiOpcode(253);
        this.initOpcodeXY(fd, new IndexRegister(){

            @Override
            public final void set(int value) {
                Z80.this.IY = value;
            }

            @Override
            public final int get() {
                return Z80.this.IY;
            }

            @Override
            public String name() {
                return "IY";
            }
        });
        this.setOpcode(fd);
    }

    private void initOpcodes_DD() {
        MultiOpcode dd = new MultiOpcode(221);
        this.initOpcodeXY(dd, new IndexRegister(){

            @Override
            public final void set(int value) {
                Z80.this.IX = value;
            }

            @Override
            public final int get() {
                return Z80.this.IX;
            }

            @Override
            public String name() {
                return "IX";
            }
        });
        this.setOpcode(dd);
    }

    private void initOpcodes_CB() {
        MultiOpcode cb = new MultiOpcode(203);
        for (int r = 0; r < 8; ++r) {
            cb.setOpcode(new RLC_R(r));
            cb.setOpcode(new SRL_R(r));
            cb.setOpcode(new RR_R(r));
            cb.setOpcode(new AbstractOpcode(8 | r, 2, 8, "RRC\t%1%rrr"){

                @Override
                public int exec(int pc) throws SIMException {
                    Z80.this.setValueRRR(this.opcode, Z80.this.rrc(Z80.this.getValueRRR(this.opcode)));
                    return 8;
                }
            });
            cb.setOpcode(new AbstractOpcode(0x10 | r, 2, 8, "RL\t%1%rrr"){

                @Override
                public int exec(int pc) throws SIMException {
                    Z80.this.setValueRRR(this.opcode, Z80.this.rl(Z80.this.getValueRRR(this.opcode)));
                    return 8;
                }
            });
            cb.setOpcode(new AbstractOpcode(0x20 | r, 2, 8, "SLA\t%1%rrr"){

                @Override
                public int exec(int pc) throws SIMException {
                    Z80.this.setValueRRR(this.opcode, Z80.this.sla(Z80.this.getValueRRR(this.opcode)));
                    return 8;
                }
            });
            cb.setOpcode(new AbstractOpcode(0x28 | r, 2, 8, "SRA\t%1%rrr"){

                @Override
                public int exec(int pc) throws SIMException {
                    Z80.this.setValueRRR(this.opcode, Z80.this.sra(Z80.this.getValueRRR(this.opcode)));
                    return 8;
                }
            });
            cb.setOpcode(new AbstractOpcode(0x30 | r, 2, 8, "SLL\t%1%rrr"){

                @Override
                public int exec(int pc) throws SIMException {
                    Z80.this.setValueRRR(this.opcode, Z80.this.sll(Z80.this.getValueRRR(this.opcode)));
                    return 8;
                }
            });
        }
        for (int b = 0; b < 8; ++b) {
            for (int r = 0; r < 8; ++r) {
                cb.setOpcode(new BIT_B_R(b, r));
                cb.setOpcode(new RES_B_R(b, r));
                cb.setOpcode(new SET_B_R(b, r));
            }
        }
        this.setOpcode(cb);
    }

    @Override
    protected void initOpcodes() {
        super.initOpcodes();
        this.setOpcode(new AbstractOpcode(217, 1, 4, "EXX"){

            @Override
            public int exec(int pc) throws SIMException {
                Z80.this.exx();
                return 4;
            }
        });
        this.setOpcode(new AbstractOpcode(8, 1, 4, "EX\tAF,AF'"){

            @Override
            public int exec(int pc) throws SIMException {
                Z80.this.ex_af_af1();
                return 4;
            }
        });
        this.setOpcode(new JR(16, 2, 13, 8, "DJNZ\t%byte"){

            @Override
            public int exec(int pc) throws SIMException {
                int v = (Z80.this.BC >>> 8) - 1 & 0xFF;
                Z80.this.BC = Z80.this.BC & 0xFF | v << 8;
                if (v != 0) {
                    return this.jr(Z80.this.getByte(pc + 1));
                }
                return 8;
            }
        });
        this.setOpcode(new JR(24, 2, 12, 12, "JR\t%offset"){

            @Override
            public int exec(int pc) throws SIMException {
                return this.jr(Z80.this.getByte(pc + 1));
            }
        });
        this.setOpcode(new JR(40, 2, 12, 7, "JR\tZ,%offset"){

            @Override
            public int exec(int pc) throws SIMException {
                if (Z80.this.FLAG_Z()) {
                    return this.jr(Z80.this.getByte(pc + 1));
                }
                return 7;
            }
        });
        this.setOpcode(new JR(32, 2, 12, 7, "JR\tNZ,%offset"){

            @Override
            public int exec(int pc) throws SIMException {
                if (Z80.this.FLAG_Z()) {
                    return 7;
                }
                return this.jr(Z80.this.getByte(pc + 1));
            }
        });
        this.setOpcode(new JR(48, 2, 12, 7, "JR\tNC,%offset"){

            @Override
            public int exec(int pc) throws SIMException {
                if (Z80.this.FLAG_C()) {
                    return 7;
                }
                return this.jr(Z80.this.getByte(pc + 1));
            }
        });
        this.setOpcode(new JR(56, 2, 12, 7, "JR\tC,%offset"){

            @Override
            public int exec(int pc) throws SIMException {
                if (Z80.this.FLAG_C()) {
                    return this.jr(Z80.this.getByte(pc + 1));
                }
                return 7;
            }
        });
        this.initOpcodes_CB();
        this.initOpcodes_ED();
        this.initOpcodes_FD();
        this.initOpcodes_DD();
    }

    class AbstractIndexALUidOffset
    extends AbstractIndex {
        private ALU alu;

        AbstractIndexALUidOffset(IndexRegister id, int opcode, int l, int t, String s, ALU alu) {
            super(id, opcode, l, t, s);
            this.alu = alu;
        }

        @Override
        public int exec(int pc) throws SIMException {
            this.alu.alu(Z80.this.getByte(Z80.this.addOffset(this.getXY(), Z80.this.getByte(pc + 2))));
            return 10;
        }
    }

    class AbstractIndexALUidL
    extends AbstractIndex {
        private ALU alu;

        AbstractIndexALUidL(IndexRegister id, int opcode, int l, int t, String s, ALU alu) {
            super(id, opcode, l, t, s);
            this.alu = alu;
        }

        @Override
        public final int exec(int pc) throws SIMException {
            this.alu.alu(this.getXY() & 0xFF);
            return 10;
        }
    }

    class AbstractIndexALUidH
    extends AbstractIndex {
        private ALU alu;

        AbstractIndexALUidH(IndexRegister id, int opcode, int l, int t, String s, ALU alu) {
            super(id, opcode, l, t, s);
            this.alu = alu;
        }

        @Override
        public final int exec(int pc) throws SIMException {
            this.alu.alu(this.getXY() >> 8);
            return 10;
        }
    }

    static interface ALU {
        public void alu(int var1);
    }

    abstract class OP1BIT
    implements OP1 {
        protected int bit;

        OP1BIT(int bit) {
            this.bit = bit;
        }
    }

    static interface OP1 {
        public int op1(int var1);
    }

    abstract class AbstractIndexOp1
    extends AbstractIndex {
        OP1 op1;

        AbstractIndexOp1(IndexRegister id, int opcode, int l, int t, String s, OP1 op1) {
            super(id, opcode, l, t, s);
            this.op1 = op1;
        }
    }

    abstract class AbstractIndex
    extends AbstractOpcode {
        IndexRegister id;

        AbstractIndex(IndexRegister id, int opcode, int l, int t, String s) {
            super(opcode, l, t, s);
            this.id = id;
        }

        public final void setXYH(int v) {
            this.setXY(this.getXY() & 0xFF | v << 8);
        }

        public final void setXYL(int v) {
            this.setXY(this.getXY() & 0xFF00 | v & 0xFF);
        }

        public final int getXYL() {
            return this.getXY() & 0xFF;
        }

        public final int getXYH() {
            return this.getXY() >>> 8;
        }

        public final int getXY() {
            return this.id.get();
        }

        public void setXY(int value) {
            this.id.set(value);
        }

        public int getXYOffset(int n) throws SIMException {
            int offset = Z80.this.getByte(n);
            return Z80.this.addOffset(this.getXY(), offset);
        }
    }

    static interface IndexRegister {
        public void set(int var1);

        public int get();

        public String name();
    }

    class BIT_B_R
    extends AbstractOpcode {
        BIT_B_R(int b, int r) {
            super(64 + b * 8 + r, 2, 8, "BIT\t" + b + ",%1%rrr");
        }

        @Override
        public final int exec(int pc) throws SIMException {
            Z80.this.bit(Z80.this.getValueRRR(this.opcode), this.opcode >> 3 & 7);
            return (this.opcode & 7) == 6 ? 12 : 8;
        }
    }

    class RLC_R
    extends AbstractOpcode {
        RLC_R(int r) {
            super(0 | r, 2, 4, "RLC\t%1%rrr");
        }

        @Override
        public final int exec(int pc) throws SIMException {
            Z80.this.setValueRRR(this.opcode, Z80.this.rlc(Z80.this.getValueRRR(this.opcode)));
            return (this.opcode & 7) == 6 ? 4 : 2;
        }
    }

    class SRL_R
    extends AbstractOpcode {
        SRL_R(int r) {
            super(0x38 | r, 2, 4, "SRL\t%rrr");
        }

        @Override
        public final int exec(int pc) throws SIMException {
            Z80.this.setValueRRR(this.opcode, Z80.this.srl(Z80.this.getValueRRR(this.opcode)));
            return (this.opcode & 7) == 6 ? 4 : 2;
        }
    }

    class RR_R
    extends AbstractOpcode {
        RR_R(int r) {
            super(0x18 | r, 2, 4, "RR\t%rrr");
        }

        @Override
        public final int exec(int pc) throws SIMException {
            Z80.this.setValueRRR(this.opcode, Z80.this.rr(Z80.this.getValueRRR(this.opcode)));
            return (this.opcode & 7) == 6 ? 4 : 2;
        }
    }

    class RES_B_R
    extends AbstractOpcode {
        RES_B_R(int b, int r) {
            super(128 + b * 8 + r, 2, 8, "RES\t" + b + "," + Z80.this.getRRR(r));
        }

        @Override
        public int exec(int pc) throws SIMException {
            int bit = this.opcode >> 3 & 7;
            int value = Z80.this.getValueRRR(this.opcode);
            Z80.this.setValueRRR(this.opcode, value &= ~(1 << bit));
            return (this.opcode & 7) == 6 ? 15 : 8;
        }
    }

    class SET_B_R
    extends AbstractOpcode {
        SET_B_R(int b, int r) {
            super(192 + b * 8 + r, 2, 8, "SET\t" + b + ",%1%rrr");
        }

        @Override
        public int exec(int pc) throws SIMException {
            int bit = this.opcode >> 3 & 7;
            int value = Z80.this.getValueRRR(this.opcode);
            Z80.this.setValueRRR(this.opcode, value |= 1 << bit);
            return (this.opcode & 7) == 6 ? 15 : 8;
        }
    }

    class SKIP
    extends AbstractOpcode {
        SKIP(int opcode) {
            super(opcode, 1, 0, "Skip\t" + Hex.formatByte(opcode));
        }

        @Override
        public int exec(int pc) throws SIMException {
            return 0;
        }
    }

    abstract class JR
    extends AbstractOpcode {
        private int tjmp;

        JR(int opcode, int l, int tjmp, int tnojmp, String s) {
            super(opcode, l, tnojmp, s);
            this.tjmp = tjmp;
        }

        protected final int jr(int offset) {
            Z80.this.PC = Z80.this.addOffset(Z80.this.PC, offset);
            return this.tjmp;
        }
    }
}

