/*
 * Decompiled with CFR 0.152.
 */
package jmce;

import jmce.Monitor;
import jmce.StringToken;
import jmce.sim.CPU;

public abstract class Command {
    StringToken st;
    Monitor monitor;
    private String help = "";
    private String cmd;

    public CPU getCPU() {
        return this.monitor.getCPU();
    }

    public Command(Monitor m, String s, String help) {
        this.monitor = m;
        this.help = help;
        int n = s.indexOf(9);
        if (n != -1) {
            this.st = new StringToken(s.substring(0, n));
            this.cmd = s.substring(0, n) + " " + s.substring(n + 1);
        } else {
            this.st = new StringToken(s);
            this.cmd = s;
        }
    }

    public abstract void exec(StringToken var1) throws Exception;

    public boolean pressToContinue(int row) throws Exception {
        if ((row + 1) % 23 == 0) {
            this.print("ESC-Quit");
            if (this.getch() == 27) {
                this.println();
                return true;
            }
            this.print("\r        \r");
        }
        return false;
    }

    public boolean compare(StringToken cmdLine) {
        for (int i = 0; i < this.st.getTokenCount(); ++i) {
            if (i >= cmdLine.getTokenCount()) {
                return false;
            }
            String s1 = this.st.getTokenAt(i);
            String s2 = cmdLine.getTokenAt(i);
            if (s1.length() > s2.length()) {
                s1 = s1.substring(0, s2.length());
            }
            if (s1.equalsIgnoreCase(s2)) continue;
            return false;
        }
        return true;
    }

    public int getch() throws Exception {
        return this.monitor.getch();
    }

    public void print(Object o) {
        this.monitor.print(o);
    }

    public void println() {
        this.monitor.println();
    }

    public void println(Object o) {
        this.monitor.println(o);
    }

    public void getLine(String prompt, StringBuffer sb) throws Exception {
        this.monitor.getLine(prompt, sb);
    }

    int getHexNumber(StringToken st, int i) throws Exception {
        return this.monitor.getHexNumber(st, i);
    }

    public String getCmd() {
        return this.cmd;
    }

    public String getHelp() {
        return this.help;
    }

    public String toString() {
        return this.st.toString();
    }
}

