/*
 * Decompiled with CFR 0.152.
 */
package jmce;

import jmce.Command;
import jmce.Monitor;
import jmce.StringToken;
import jmce.sim.Memory;
import jmce.sim.MemoryReadListener;
import jmce.sim.MemoryWriteListener;
import jmce.sim.SIMException;
import jmce.util.Hex;

class CommandTrap
extends Command
implements MemoryReadListener,
MemoryWriteListener {
    CommandTrap(Monitor m) {
        super(m, "trap\t[mem] [on|off]", "Set / unset / show trap on memory");
    }

    @Override
    public void exec(StringToken st) throws Exception {
        this.monitor.checkCPU();
        Memory m = this.monitor.cpu.getMemoryForName("IO");
        String cmd = "";
        if (st.getTokenCount() > 2) {
            m = this.monitor.getArgMemory(st, 1);
            cmd = st.getTokenAt(2);
        } else if (st.getTokenCount() > 1) {
            cmd = st.getTokenAt(1);
        }
        this.print("Trap on " + m.getName() + " : ");
        if (cmd.equalsIgnoreCase("on")) {
            m.addMemoryWriteListener(this);
            m.addMemoryReadListener(this);
            this.println("ON");
        } else if (cmd.equalsIgnoreCase("off")) {
            m.removeMemoryWriteListener(this);
            m.removeMemoryReadListener(this);
            this.println("OFF");
        } else {
            boolean found = false;
            for (int i = 0; i < m.getMemoryWriteListenerCount(); ++i) {
                if (m.getMemoryWriteListenerAt(i) != this) continue;
                found = true;
            }
            this.println("is " + (found ? "ON" : "OFF"));
        }
    }

    @Override
    public int readMemory(Memory m, int address, int value) throws SIMException {
        int n = m.getMemoryReadListenerCount(address);
        if (n == 0) {
            throw new SIMException("TRAP I/O Read Address=" + Hex.formatWord(address));
        }
        return value;
    }

    @Override
    public void writeMemory(Memory m, int address, int value, int oldValue) throws SIMException {
        int n = m.getMemoryWriteListenerCount(address);
        if (n == 0) {
            throw new SIMException("TRAP I/O Write Address=" + Hex.formatWord(address) + " Value=" + Hex.formatByte(value));
        }
    }
}

