/*
 * Decompiled with CFR 0.152.
 */
package jmce;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;
import jmce.ApplicationFrame;
import jmce.Jmce;
import jmce.PanelAssembly;
import jmce.PanelBreak;
import jmce.PanelInfo;
import jmce.PanelMemory;
import jmce.PanelRegister;
import jmce.PanelStatus;
import jmce.Property;
import jmce.SortedLong;
import jmce.sim.CPU;
import jmce.sim.ExceptionEvent;
import jmce.sim.ExceptionListener;
import jmce.sim.SIMException;
import jmce.sim.cpu.AbstractOpcode;
import jmce.sim.cpu.MultiOpcode;
import jmce.swing.Util;
import jmce.util.StringUtil;

public class JDebug
extends ApplicationFrame
implements ExceptionListener {
    private static final long serialVersionUID = 1L;
    private AbstractAction actionDebugReset;
    private AbstractAction actionDebugGo;
    private AbstractAction actionDebugStop;
    private AbstractAction actionDebugInto;
    private AbstractAction actionDebugStep;
    private AbstractAction actionToolsProfile;
    private AbstractAction actionToolsInterrupt;
    private PanelInfo info;
    private PanelRegister regs;
    private PanelAssembly ass;
    private PanelStatus sts;
    private PanelMemory mem1;
    private PanelBreak wat;
    private JRadioButtonMenuItem bLaf = null;

    JDebug(CPU _cpu) {
        super(_cpu);
        this.setTitle("JMCE Debug - " + Jmce.versionNumber);
        this.cpu.addExceptionListener(this);
        this.createActions();
        this.createMenuBar();
        this.createPanels();
        this.setEmulation(false);
        this.update(this.cpu);
        this.update(this.cpu);
        Timer t = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JDebug.this.swingTimer();
            }
        });
        t.setRepeats(true);
        t.start();
        if (this.bLaf != null) {
            this.bLaf.doClick();
        }
        this.showMessage("$Id: JDebug.java 814 2012-03-29 11:07:49Z mviara $ - Ready");
    }

    private void addAction(JToolBar bar, AbstractAction a) {
        JButton b = bar.add(a);
        b.setToolTipText((String)a.getValue("Name"));
    }

    public void createPanels() {
        JToolBar bar = super.createToolBar();
        this.addAction(bar, this.actionFileLoad);
        this.addAction(bar, this.actionDebugGo);
        this.addAction(bar, this.actionDebugStop);
        this.addAction(bar, this.actionDebugStep);
        this.addAction(bar, this.actionDebugInto);
        this.addAction(bar, this.actionDebugReset);
        this.info = new PanelInfo(this.cpu);
        this.regs = new PanelRegister(this.cpu);
        this.ass = new PanelAssembly(this.cpu);
        this.sts = new PanelStatus(this.cpu);
        this.mem1 = new PanelMemory("Memory", this.cpu);
        this.wat = new PanelBreak(this.cpu);
        this.ass.setPreferredHeight(this.mem1.getPreferredSize().height);
        JPanel p = new JPanel(new GridBagLayout());
        GridBagConstraints g = new GridBagConstraints();
        g.fill = 1;
        g.gridx = 0;
        g.gridy = 0;
        g.fill = 0;
        g.anchor = 17;
        p.add((Component)bar, g);
        g.fill = 1;
        ++g.gridy;
        g.anchor = 10;
        p.add((Component)this.ass, g);
        ++g.gridx;
        p.add((Component)this.regs, g);
        ++g.gridx;
        p.add((Component)this.info, g);
        ++g.gridx;
        ++g.gridy;
        g.gridx = 0;
        g.gridwidth = 1;
        p.add((Component)this.mem1, g);
        ++g.gridx;
        g.gridwidth = 2;
        p.add((Component)this.wat, g);
        ++g.gridy;
        g.gridx = 0;
        g.gridwidth = 3;
        p.add((Component)this.sts, g);
        this.setContentPane(p);
    }

    public void createMenuBar() {
        JMenuBar bar = new JMenuBar();
        bar.add(this.createMenuFile());
        bar.add(this.createMenuDebug());
        bar.add(this.createMenuTools());
        JMenu m = this.createMenuTape();
        if (m != null) {
            bar.add(m);
        }
        bar.add(this.createMenuLaf());
        this.setJMenuBar(bar);
    }

    JMenu createMenuLaf() {
        JMenu lnf = new JMenu("Look & Feel", true);
        lnf.setIcon(Util.getIcon(this.getClass(), "colors.png"));
        ButtonGroup buttonGroup = new ButtonGroup();
        UIManager.LookAndFeelInfo[] info = UIManager.getInstalledLookAndFeels();
        String s = Property.getProperty("lookAndFeel", "");
        for (int i = 0; i < info.length; ++i) {
            boolean set = false;
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(info[i].getName(), set);
            final String className = info[i].getClassName();
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    try {
                        Property.setProperty("lookAndFeel", className);
                        UIManager.setLookAndFeel(className);
                    }
                    catch (Exception e) {
                        JDebug.this.showError(e);
                    }
                    SwingUtilities.updateComponentTreeUI(JDebug.this);
                    JDebug.this.pack();
                }
            });
            if (className.equals(s)) {
                this.bLaf = item;
            }
            buttonGroup.add(item);
            lnf.add(item);
        }
        lnf.setMnemonic('K');
        return lnf;
    }

    JMenu createMenuTools() {
        JMenu menu = new JMenu("Tools");
        menu.setMnemonic('T');
        menu.setIcon(Util.getIcon(this.getClass(), "tools.gif"));
        menu.add(this.actionToolsProfile);
        menu.add(this.actionToolsInterrupt);
        return menu;
    }

    JMenu createMenuDebug() {
        JMenu menu = new JMenu("Debug");
        menu.setMnemonic('D');
        menu.setIcon(Util.getIcon(this.getClass(), "Cpu.gif"));
        menu.add(this.actionDebugGo).setAccelerator(KeyStroke.getKeyStroke(116, 0));
        menu.add(this.actionDebugStop).setAccelerator(KeyStroke.getKeyStroke(117, 0));
        menu.add(this.actionDebugStep).setAccelerator(KeyStroke.getKeyStroke(120, 0));
        menu.add(this.actionDebugInto).setAccelerator(KeyStroke.getKeyStroke(119, 0));
        menu.add(this.actionDebugReset);
        return menu;
    }

    private void createActions() {
        this.actionToolsInterrupt = new AbstractAction("Interrupt"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JDebug.this.performToolsInterrupt();
            }
        };
        this.actionToolsProfile = new AbstractAction("Opcodes"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JDebug.this.performToolsProfile();
            }
        };
        this.actionDebugInto = new AbstractAction("Step into", Util.getIcon(this.getClass(), "stepinto.gif")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JDebug.this.performStep();
            }
        };
        this.actionDebugStep = new AbstractAction("Step over", Util.getIcon(this.getClass(), "step.gif")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JDebug.this.performOver();
            }
        };
        this.actionDebugReset = new AbstractAction("Reset", Util.getIcon(this.getClass(), "tools.gif")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JDebug.this.performReset();
            }
        };
        this.actionDebugGo = new AbstractAction("Go", Util.getIcon(this.getClass(), "play.gif")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JDebug.this.performStart();
            }
        };
        this.actionDebugStop = new AbstractAction("Stop", Util.getIcon(this.getClass(), "stop.gif")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JDebug.this.performStop();
            }
        };
    }

    @Override
    protected void setEmulation(boolean mode) {
        super.setEmulation(mode);
        this.actionDebugReset.setEnabled(!mode);
        this.actionDebugGo.setEnabled(!mode);
        this.actionDebugStop.setEnabled(mode);
        this.actionDebugStep.setEnabled(!mode);
        this.actionDebugInto.setEnabled(!mode);
        this.info.setEmulation(mode);
        this.regs.setEmulation(mode);
        this.ass.setEmulation(mode);
        this.mem1.setEmulation(mode);
        this.wat.setEmulation(mode);
    }

    void update(CPU cpu) {
        this.swingTimer();
        try {
            this.info.update(cpu);
            this.regs.update(cpu);
            this.ass.update(cpu);
            this.mem1.update(cpu);
            this.wat.update(cpu);
        }
        catch (SIMException sIMException) {
            // empty catch block
        }
    }

    void performStop() {
        this.cpu.stop();
        this.cpu.setTill(-1);
        this.setEmulation(false);
        this.update(this.cpu);
    }

    void performStart() {
        this.cpu.start();
        this.setEmulation(true);
    }

    void performStep() {
        this.setEmulation(true);
        try {
            this.cpu.step();
        }
        catch (SIMException sIMException) {
            // empty catch block
        }
        this.setEmulation(false);
        this.update(this.cpu);
    }

    private void showMessage(String s) {
        this.sts.append(s + "\n");
    }

    void performReset() {
        try {
            this.cpu.reset();
            this.update(this.cpu);
        }
        catch (Exception e) {
            this.showError(e);
        }
    }

    void performOver() {
        int till = -1;
        try {
            till = this.cpu.pc() + this.cpu.getLenghtAt(this.cpu.pc());
        }
        catch (SIMException sIMException) {
            // empty catch block
        }
        this.setEmulation(true);
        this.cpu.setTill(till);
        this.cpu.start();
    }

    @Override
    public void exceptionEvent(ExceptionEvent ev) {
        this.performStop();
        Throwable ex = ev.getEvent();
        this.sts.append(ex.toString() + "\n");
    }

    void performTree(String title, JTree tree) {
        class MyRenderer
        extends DefaultTreeCellRenderer {
            private static final long serialVersionUID = 1L;

            MyRenderer() {
            }

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                Font font = this.getFont();
                if (font != null) {
                    font = new Font("Monospaced", font.getStyle(), font.getSize());
                    this.setFont(font);
                }
                return this;
            }
        }
        tree.setCellRenderer(new MyRenderer());
        Dimension size = this.getPreferredSize();
        size.width = size.width * 3 / 4;
        size.height = size.height * 3 / 4;
        JScrollPane sc = new JScrollPane(tree);
        sc.setPreferredSize(size);
        JDialog d = new JDialog(this, title, true);
        Point p = this.getLocation();
        p.x += size.width / 10;
        p.y += size.height / 10;
        d.setLocation(p);
        d.setContentPane(sc);
        d.pack();
        d.setVisible(true);
    }

    private void performToolsProfile(SortedLong sl, MultiOpcode mo) {
        for (int i = 0; i < 256; ++i) {
            AbstractOpcode op = mo.getOpcode(i);
            if (op == null) continue;
            if (op instanceof MultiOpcode) {
                this.performToolsProfile(sl, (MultiOpcode)op);
                continue;
            }
            if (op.getCounter() <= 0L) continue;
            sl.put(op.getCounter(), StringUtil.expandTab(op.getDescription()));
        }
    }

    private void performToolsProfile() {
        SortedLong sl = new SortedLong();
        this.performToolsProfile(sl, this.cpu.getOpcodes());
        this.performTree("Profile", sl.createTree());
    }

    private void performToolsInterrupt() {
        SortedLong sl = new SortedLong();
        for (int i = 0; i < this.cpu.getInterruptCount(); ++i) {
            if (this.cpu.getInterruptCounter(i) <= 0) continue;
            sl.put(this.cpu.getInterruptCounter(i), this.cpu.getInterruptName(i));
        }
        this.performTree("Interrupt", sl.createTree());
    }

    @Override
    protected void performLoad() {
        super.performLoad();
        this.ass.purge();
        try {
            this.ass.update(this.cpu);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

