/*
 * Decompiled with CFR 0.152.
 */
package jmce;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import jmce.Command;
import jmce.CommandExamine;
import jmce.CommandException;
import jmce.CommandRegister;
import jmce.CommandTrap;
import jmce.Jmce;
import jmce.StringToken;
import jmce.sim.AbstractHardware;
import jmce.sim.BreakPoint;
import jmce.sim.CPU;
import jmce.sim.Console;
import jmce.sim.Device;
import jmce.sim.ExceptionEvent;
import jmce.sim.ExceptionListener;
import jmce.sim.Hardware;
import jmce.sim.LoadInfo;
import jmce.sim.Memory;
import jmce.sim.Register;
import jmce.sim.SIMException;
import jmce.sim.Tape;
import jmce.sim.TraceListener;
import jmce.sim.cpu.AbstractCPU;
import jmce.sim.terminal.Terminal;
import jmce.util.Hex;

public class Monitor
extends AbstractHardware
implements ExceptionListener,
TraceListener,
Runnable,
Console {
    private Vector<Command> cmds = new Vector();
    private boolean exit;
    private Device<Integer> console;
    private Terminal terminal;
    CPU cpu;
    private Jmce jmce;
    private Vector<BufferedReader> bufferedReaders = new Vector();
    BufferedReader rd = null;
    Timer timer = new Timer(true);
    private int from = -1;
    PrintStream trace = null;
    Thread thread = new Thread(this);

    public CPU getCPU() {
        return this.cpu;
    }

    public void addCommand(Command cmd) {
        this.cmds.add(cmd);
    }

    public int getCommandCount() {
        return this.cmds.size();
    }

    public Command getCommandAt(int i) {
        return this.cmds.elementAt(i);
    }

    Exception addBuffer(String name) {
        this.print("input from " + name);
        File file = new File(name);
        if (!file.exists()) {
            this.println(" not exists");
            return null;
        }
        this.println(" length=" + file.length());
        try {
            BufferedReader rdNew = new BufferedReader(new FileReader(name));
            if (this.rd != null) {
                this.bufferedReaders.add(this.rd);
                this.rd = rdNew;
            } else {
                this.rd = rdNew;
            }
        }
        catch (Exception e) {
            System.out.println(e);
            return e;
        }
        return null;
    }

    void nextBuffer() {
        this.rd = null;
        if (this.bufferedReaders.size() > 0) {
            this.rd = this.bufferedReaders.get(0);
            this.bufferedReaders.remove(0);
        }
    }

    public int getch() throws Exception {
        while (this.rd != null) {
            try {
                int ch = this.rd.read();
                if (ch < 0) {
                    try {
                        this.rd.close();
                    }
                    catch (Exception discard) {
                        // empty catch block
                    }
                    this.nextBuffer();
                    continue;
                }
                return ch;
            }
            catch (Exception ex) {
                try {
                    this.rd.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.nextBuffer();
            }
        }
        return this.console.readOutput();
    }

    public void printStatusLine(int n, String s) {
        if (this.terminal != null) {
            this.terminal.printStatusLine(n, s);
        }
    }

    @Override
    public void println() {
        this.putchar(13);
        this.putchar(10);
    }

    @Override
    public void println(Object o) {
        this.print(o);
        this.println();
    }

    @Override
    public void print(Object o) {
        String s = String.valueOf(o);
        for (int i = 0; i < s.length(); ++i) {
            this.putchar(s.charAt(i));
        }
    }

    @Override
    public void putchar(int c) {
        try {
            this.console.writeInput(c);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void getLine(String prompt, StringBuffer line) throws Exception {
        boolean refresh = true;
        block5: while (true) {
            if (refresh) {
                line.setLength(0);
                refresh = false;
                this.print(prompt);
            }
            int c = this.getch();
            switch (c) {
                default: {
                    if (c >= 32 && c < 128) {
                        line.append((char)c);
                        this.putchar(c);
                        continue block5;
                    }
                    this.printStatusLine(0, "Invalid key " + c);
                    continue block5;
                }
                case 8: {
                    if (line.length() <= 0) continue block5;
                    line.delete(line.length() - 1, line.length());
                    this.print("\b \b");
                    continue block5;
                }
                case 10: 
                case 13: {
                    this.println();
                    return;
                }
                case 27: 
            }
            this.println();
            refresh = true;
        }
    }

    @Override
    public void run() {
        StringBuffer line = new StringBuffer();
        TimerTask t1 = new TimerTask(){

            @Override
            public void run() {
                if (Monitor.this.cpu != null && Monitor.this.cpu.isRunning()) {
                    Monitor.this.printStatusLine(0, Monitor.this.cpu.getUsageDesc());
                } else {
                    Monitor.this.printStatusLine(0, "");
                }
            }
        };
        this.timer.schedule(t1, 1000L, 1000L);
        this.selectCPU();
        this.println("JMCE Monitor $Id: Monitor.java 589 2011-05-18 16:42:27Z mviara $");
        while (!this.exit) {
            Command c;
            int i;
            StringToken st;
            String c0;
            try {
                this.getLine(">", line);
            }
            catch (Exception e) {
                this.println(e);
            }
            if (line.length() == 0 || (c0 = (st = new StringToken(line.toString())).getStringAt(0).toLowerCase()).startsWith("rem") || c0.startsWith(";") || c0.startsWith("#") || c0.startsWith("//") || c0.startsWith("'")) continue;
            int count = 0;
            Command cmd = null;
            for (i = 0; i < this.getCommandCount(); ++i) {
                c = this.getCommandAt(i);
                if (!c.compare(st)) continue;
                ++count;
                cmd = c;
            }
            if (count == 0) {
                Register r = null;
                if (this.cpu != null && (r = this.cpu.getRegisterForName(st.getStringAt(0))) != null) {
                    try {
                        this.println(r.getName() + " = " + r.hexValue());
                        if (st.getTokenCount() > 1) {
                            r.setRegister(this.getHexNumber(st, 1));
                            this.println(r.getName() + " = " + r.hexValue());
                        }
                    }
                    catch (Exception ex) {
                        this.println(ex);
                    }
                }
                if (r != null) continue;
                this.println("Invalid command '" + line + "'");
                continue;
            }
            if (count > 1) {
                this.println("Too many candidates for '" + line + "'");
                for (i = 0; i < this.getCommandCount(); ++i) {
                    c = this.getCommandAt(i);
                    if (!c.compare(st)) continue;
                    this.println("\t" + c.toString());
                }
                continue;
            }
            try {
                cmd.exec(st);
            }
            catch (Exception ex) {
                this.println(ex);
                ex.printStackTrace(System.out);
            }
        }
        this.timer.cancel();
        try {
            this.jmce.cpu.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.exit(0);
    }

    public void error(String s) throws Exception {
        throw new CommandException(s);
    }

    void checkRunning() throws Exception {
        if (this.cpu != null && this.cpu.isRunning()) {
            this.error("CPU already running");
        }
    }

    void checkCPU() throws Exception {
        if (this.cpu == null && this.cpu == null) {
            this.error("CPU not loaded, try 'add  ...'");
        }
    }

    void checkArg(int n, StringToken line) throws Exception {
        if (n >= line.getTokenCount()) {
            this.error(n + " Arguments() are required");
        }
    }

    Memory getArgMemory(StringToken st, int n) throws Exception {
        this.checkArg(n, st);
        String s = st.getTokenAt(n);
        for (int i = 0; i < this.cpu.getMemoryCount(); ++i) {
            Memory m = this.cpu.getMemoryAt(i);
            if (!m.getName().equalsIgnoreCase(s)) continue;
            return m;
        }
        return this.cpu.getMemoryAt(st.getTokenInt(n));
    }

    int getHexNumber(StringToken st, int i) throws Exception {
        this.checkArg(i, st);
        String s = st.getTokenAt(i);
        Register r = null;
        r = this.cpu.getRegisterForName(s);
        if (r != null) {
            return r.getRegister();
        }
        return st.getTokenHex(i);
    }

    public void setConsole(Device<Integer> c) {
        this.console = c;
        this.terminal = c instanceof Terminal ? (Terminal)c : null;
    }

    @Override
    public void init(Hardware parent) throws SIMException {
        if (this.console == null) {
            this.console = new Device();
            Device t = (Device)this.getHardware((Class)this.console.getClass());
            if (t == null) {
                t = Terminal.createTerminal();
                this.addHardware(t);
            }
            this.setConsole(t);
        }
        super.init(parent);
    }

    @Override
    public void reset() throws SIMException {
        super.reset();
        if (!this.thread.isAlive()) {
            this.thread.start();
        }
    }

    public Tape getTape() throws Exception {
        this.checkCPU();
        Tape tape = (Tape)this.cpu.getHardware(Tape.class);
        if (tape == null) {
            throw new Exception("Tape not installed");
        }
        return tape;
    }

    public Monitor() {
        this.setName("Monitor");
        this.jmce = Jmce.getInstance();
        this.addCommand(new Command(this, "realtime\t[on|off", "Enable/disable realtime"){

            @Override
            public void exec(StringToken st) throws Exception {
                Monitor.this.checkCPU();
                if (st.getTokenCount() < 2) {
                    this.println("Realtime is " + Monitor.this.cpu.getRealTime());
                } else {
                    String s = st.getTokenAt(1);
                    if (s.equalsIgnoreCase("off")) {
                        Monitor.this.cpu.setRealTime(false);
                        if (Monitor.this.trace != null) {
                            Monitor.this.trace.close();
                        }
                        this.println("Realtime false");
                    } else {
                        Monitor.this.cpu.setRealTime(true);
                        this.println("Realtime true");
                    }
                }
            }
        });
        this.addCommand(new Command(this, "tape rewind", "Rewind tape"){

            @Override
            public void exec(StringToken st) throws Exception {
                Tape tape = Monitor.this.getTape();
                tape.play();
            }
        });
        this.addCommand(new Command(this, "tape play", "Play tape"){

            @Override
            public void exec(StringToken st) throws Exception {
                Tape tape = Monitor.this.getTape();
                tape.play();
            }
        });
        this.addCommand(new Command(this, "tape rec", "Record tape"){

            @Override
            public void exec(StringToken st) throws Exception {
                Tape tape = Monitor.this.getTape();
                tape.rec();
            }
        });
        this.addCommand(new Command(this, "tape stop", "Stop tape"){

            @Override
            public void exec(StringToken st) throws Exception {
                Tape tape = Monitor.this.getTape();
                tape.stop();
            }
        });
        this.addCommand(new Command(this, "tape config\t[file]", "Set show tape configuration"){

            @Override
            public void exec(StringToken st) throws Exception {
                Tape tape = Monitor.this.getTape();
                if (st.getTokenCount() >= 3) {
                    tape.setConfig(st.getTokenAt(2));
                }
                this.println("Tape config '" + tape.getConfig() + "'");
            }
        });
        this.addCommand(new CommandExamine(this));
        this.addCommand(new CommandTrap(this));
        this.addCommand(new CommandRegister(this));
        this.addCommand(new Command(this, "trace\t[file|off]", "Enable/disable/show file"){

            @Override
            public void exec(StringToken st) throws Exception {
                Monitor.this.checkCPU();
                if (st.getTokenCount() < 2) {
                    String s = Monitor.this.trace == null ? "OFF" : "ON";
                    this.println("Trace is " + s);
                } else {
                    String s = st.getTokenAt(1);
                    if (s.equalsIgnoreCase("off")) {
                        if (Monitor.this.trace != null) {
                            Monitor.this.trace.close();
                        }
                        this.println("Trace off");
                    } else {
                        Monitor.this.trace = new PrintStream(new FileOutputStream(s));
                        Monitor.this.cpu.addTraceListener(Monitor.this);
                        this.println("Trace on " + s);
                    }
                }
            }
        });
        this.addCommand(new Command(this, "quit", "Terminate the simulator"){

            @Override
            public void exec(StringToken cmdLine) {
                Monitor.this.exit = true;
            }
        });
        this.addCommand(new Command(this, "?", "Show command list"){

            @Override
            public void exec(StringToken cmdLine) throws Exception {
                Command c;
                int i;
                Vector<String> v = new Vector<String>();
                int l = 0;
                for (i = 0; i < Monitor.this.getCommandCount(); ++i) {
                    c = Monitor.this.getCommandAt(i);
                    if (c.getCmd().length() <= l) continue;
                    l = c.getCmd().length();
                }
                for (i = 0; i < Monitor.this.getCommandCount(); ++i) {
                    c = Monitor.this.getCommandAt(i);
                    String s = c.getCmd();
                    while (s.length() < l) {
                        s = s + " ";
                    }
                    v.add(s + " -> " + c.getHelp());
                }
                Collections.sort(v);
                for (i = 0; i < v.size() && !this.pressToContinue(i); ++i) {
                    this.println(v.elementAt(i));
                }
            }
        });
        this.addCommand(new Command(this, "@", "Exec command from file"){

            @Override
            public void exec(StringToken st) throws Exception {
                Monitor.this.checkArg(1, st);
                Exception e = Monitor.this.addBuffer(st.getStringAt(1));
                if (e != null) {
                    this.println(e);
                }
            }
        });
        this.addCommand(new Command(this, ".", "Display cpu register"){

            @Override
            public void exec(StringToken cmdLine) throws Exception {
                Monitor.this.checkCPU();
                Monitor.this.showCpu();
            }
        });
        this.addCommand(new Command(this, "break read\t[mem] add", "Set break on read"){

            @Override
            public void exec(StringToken st) throws Exception {
                Monitor.this.checkCPU();
                int m = st.getTokenInt(2);
                int a = st.getTokenHex(3);
                Monitor.this.cpu.addReadBreakPoint(m, a);
            }
        });
        this.addCommand(new Command(this, "break write\t[mem] add", "Set break on write"){

            @Override
            public void exec(StringToken st) throws Exception {
                Monitor.this.checkCPU();
                int m = st.getTokenInt(2);
                int a = st.getTokenHex(3);
                Monitor.this.cpu.addWriteBreakPoint(m, a);
            }
        });
        this.addCommand(new Command(this, "break exec\t[mem] add", "Set break on exec"){

            @Override
            public void exec(StringToken st) throws Exception {
                Monitor.this.checkCPU();
                int m = st.getTokenInt(2);
                int a = st.getTokenHex(3);
                Monitor.this.cpu.addExecBreakPoint(m, a);
            }
        });
        this.addCommand(new Command(this, "break cancel\tn", "Cancel break"){

            @Override
            public void exec(StringToken st) throws Exception {
                Monitor.this.checkCPU();
                int n = st.getTokenInt(2);
                BreakPoint bp = Monitor.this.cpu.getBreakPointAt(n);
                this.println(bp.toString() + " Cancelled.");
                Monitor.this.cpu.removeBreakPoint(n);
            }
        });
        this.addCommand(new Command(this, "break disable\tn", "Disable break"){

            @Override
            public void exec(StringToken st) throws Exception {
                Monitor.this.checkCPU();
                BreakPoint bp = Monitor.this.cpu.getBreakPointAt(st.getTokenInt(2));
                this.println(bp.toString() + " Disabled");
                bp.setEnabled(false);
            }
        });
        this.addCommand(new Command(this, "break enable\tn", "Enable break"){

            @Override
            public void exec(StringToken st) throws Exception {
                Monitor.this.checkCPU();
                BreakPoint bp = Monitor.this.cpu.getBreakPointAt(st.getTokenInt(2));
                this.println(bp.toString() + " Enabled");
                bp.setEnabled(true);
            }
        });
        this.addCommand(new Command(this, "break list", "Show define breaks"){

            @Override
            public void exec(StringToken cmdLine) throws Exception {
                Monitor.this.checkCPU();
                this.println("Break point list.");
                for (int i = 0; i < Monitor.this.cpu.getBreakPointCount(); ++i) {
                    BreakPoint bp = Monitor.this.cpu.getBreakPointAt(i);
                    this.println(i + ". " + bp.toString() + " Count=" + bp.getFireCount());
                }
            }
        });
        this.addCommand(new Command(this, "cpu statistics", "Dump cpu statistics"){

            @Override
            public void exec(StringToken cmdLine) throws Exception {
                Monitor.this.checkCPU();
                Monitor.this.cpu.dumpStatistics("cpu.txt");
            }
        });
        this.addCommand(new Command(this, "show memory", "Show memory list"){

            @Override
            public void exec(StringToken cmdLine) throws Exception {
                Monitor.this.checkCPU();
                this.println("Memory list");
                for (int i = 0; i < Monitor.this.cpu.getMemoryCount(); ++i) {
                    Memory m = Monitor.this.cpu.getMemoryAt(i);
                    this.println(i + ". " + m.toString());
                }
            }
        });
        this.addCommand(new Command(this, "show cpu", "Show cpu statistics"){

            public void show(String s1, String s2) {
                while (s1.length() < 32) {
                    s1 = " " + s1;
                }
                this.println(s1 + " = " + s2);
            }

            public void show(String s1, boolean b) {
                this.show(s1, b ? "true" : "false");
            }

            public void show(String s1, long n) {
                this.show(s1, "" + n);
            }

            @Override
            public void exec(StringToken cmdLine) throws Exception {
                Monitor.this.checkCPU();
                this.show("CPU name", Monitor.this.cpu.getName());
                this.show("Realtime ", Monitor.this.cpu.getRealTime());
                this.show("Clock ", Monitor.this.cpu.getClock());
                this.show("Clock per cycle", Monitor.this.cpu.getClockPerCycle());
                this.show("Endian", Monitor.this.cpu.isBigEndian() ? "Big" : "Little");
                this.show("Register", Monitor.this.cpu.getRegisterCount());
                this.show("Peripheral", Monitor.this.cpu.getHardwareCount());
                for (int i = 0; i < Monitor.this.cpu.getHardwareCount(); ++i) {
                    this.show("Peripheral #" + i, Monitor.this.cpu.getHardware(i).toString());
                }
                this.show("Cycle", Monitor.this.cpu.getCycle());
                this.show("Running", Monitor.this.cpu.isRunning());
                this.show("Interrupt", Monitor.this.cpu.isInterruptEnabled() ? "enabled" : "disabled");
                AbstractCPU a = (AbstractCPU)Monitor.this.cpu;
                for (int i = 0; i < a.getInterruptCount(); ++i) {
                    if (a.getInterruptCounter(i) <= 0) continue;
                    this.show("Interrupt #" + i, a.getInterruptName(i) + " Count=" + a.getInterruptCounter(i));
                }
            }
        });
        this.addCommand(new Command(this, "go\t[till]", "Start cpu with optional break"){

            @Override
            public void exec(StringToken st) throws Exception {
                Monitor.this.checkCPU();
                Monitor.this.checkRunning();
                Monitor.this.showCpu();
                this.println(Monitor.this.cpu.toString() + " - Started");
                if (st.getTokenCount() > 1) {
                    Monitor.this.cpu.setTill(st.getTokenHex(1));
                }
                Monitor.this.cpu.start();
            }
        });
        this.addCommand(new Command(this, "halt", "Stop cpu"){

            @Override
            public void exec(StringToken st) throws Exception {
                Monitor.this.checkCPU();
                if (!Monitor.this.cpu.isRunning()) {
                    this.println(Monitor.this.cpu.toString() + " - Already stopped");
                } else {
                    Monitor.this.cpu.stop();
                    this.println(Monitor.this.cpu.toString() + " - Stopped");
                }
                Monitor.this.showCpu();
            }
        });
        this.addCommand(new Command(this, "reset", "Reset CPU"){

            @Override
            public void exec(StringToken st) throws Exception {
                Monitor.this.checkRunning();
                Monitor.this.cpu.reset();
            }
        });
        this.addCommand(new Command(this, "load\t[base] file", "Load file in memory"){

            @Override
            public void exec(StringToken st) throws Exception {
                int base = 0;
                String file = null;
                Monitor.this.checkCPU();
                Monitor.this.checkRunning();
                Monitor.this.checkArg(1, st);
                LoadInfo info = new LoadInfo();
                if (st.getTokenCount() > 2) {
                    base = this.getHexNumber(st, 1);
                    file = st.getStringAt(2);
                } else {
                    file = st.getStringAt(1);
                }
                Monitor.this.cpu.load(file, base, info);
                this.println(file + " loaded at " + Hex.formatWord(info.start) + " - " + Hex.formatWord(info.end));
            }
        });
        this.addCommand(new Command(this, "xml load\t[cpu.xml]", "Load new xml configuration"){

            @Override
            public void exec(StringToken st) throws Exception {
                String s = st.getTokenCount() > 2 ? st.getTokenAt(2) : "cpu.xml";
                this.println("Decode CPU from " + s);
                Object o = Monitor.this.jmce.decode(s);
                Monitor.this.jmce.setCPU(o);
                Monitor.this.selectCPU();
            }
        });
        this.addCommand(new Command(this, "xml save\t[cpu.xml]", "Save current configuration"){

            @Override
            public void exec(StringToken st) throws Exception {
                String s = st.getTokenCount() > 2 ? st.getTokenAt(2) : "cpu.xml";
                this.println("Encode CPU to " + s);
                Monitor.this.jmce.encode(s);
            }
        });
        this.addCommand(new Command(this, "clock\tn", "Set cpu clock to n"){

            @Override
            public void exec(StringToken st) throws Exception {
                Monitor.this.checkCPU();
                Monitor.this.cpu.setClock(st.getTokenInt(1));
            }
        });
        this.addCommand(new Command(this, "show config", "Show cpu configuration"){

            @Override
            public void exec(StringToken cmdLine) throws Exception {
                Monitor.this.checkCPU();
                Jmce.showConfig(Monitor.this.cpu, Monitor.this);
            }
        });
        this.addCommand(new Command(this, "add\tclass", "Add new class"){

            @Override
            public void exec(StringToken cmdLine) throws Exception {
                Class<?> clazz;
                Object o;
                Monitor.this.checkArg(1, cmdLine);
                String s = cmdLine.getTokenAt(1);
                Hardware parent = ((Monitor)Monitor.this).jmce.cpu;
                if (cmdLine.getTokenCount() > 2) {
                    parent = parent.getHardware(cmdLine.getTokenInt(2));
                }
                if (!((o = (clazz = Class.forName(s)).newInstance()) instanceof Hardware)) {
                    Monitor.this.error("Not instance of jmce.sim.Hardware");
                }
                Hardware h = (Hardware)o;
                if (parent == null) {
                    Monitor.this.jmce.setCPU(o);
                    h.reset();
                } else {
                    h.init(parent);
                    h.initSwing(parent);
                    h.reset();
                    Monitor.this.jmce.addChild(parent, h);
                }
                if (Monitor.this.cpu == null && o instanceof CPU) {
                    Monitor.this.selectCPU((CPU)o);
                }
            }
        });
        this.addCommand(new Command(this, "unassemble\t[add]", "Disassmble program"){

            @Override
            public void exec(StringToken st) throws Exception {
                Monitor.this.checkCPU();
                if (Monitor.this.from < 0) {
                    Monitor.this.from = Monitor.this.cpu.pc();
                }
                if (st.getTokenCount() > 1) {
                    Monitor.this.from = this.getHexNumber(st, 1);
                }
                for (int i = 0; i < 16; ++i) {
                    this.println(Monitor.this.cpu.decodeAt(Monitor.this.from));
                    Monitor.this.from += Monitor.this.cpu.getLenghtAt(Monitor.this.from);
                }
            }
        });
        this.addCommand(new Command(this, "dump\t[mem] add", "Dump memory"){
            int from;
            Memory m;
            {
                this.from = 0;
                this.m = null;
            }

            @Override
            public void exec(StringToken st) throws Exception {
                Monitor.this.checkCPU();
                if (this.m == null) {
                    this.m = Monitor.this.cpu.getMemoryAt(0);
                }
                if (st.getTokenCount() > 2) {
                    this.m = Monitor.this.getArgMemory(st, 1);
                    this.from = this.getHexNumber(st, 2);
                } else if (st.getTokenCount() > 1) {
                    this.from = this.getHexNumber(st, 1);
                }
                this.println(this.m.getName() + " at " + Hex.formatWord(this.from));
                for (int i = 0; i < 8; ++i) {
                    String s = Hex.formatWord(this.from) + " ";
                    String s1 = "";
                    String s2 = "";
                    for (int j = 0; j < 16; ++j) {
                        byte c = (byte)this.m.getMemory(this.from + j);
                        s1 = s1 + Hex.formatByte(c & 0xFF);
                        s1 = s1 + (j == 7 ? (char)'.' : ' ');
                        s2 = s2 + (c < 32 || c > 127 ? (char)'.' : (char)c);
                    }
                    this.println(s + s1 + " " + s2);
                    this.from += 16;
                }
            }
        });
        this.addCommand(new Command(this, "pass", "Exec to next line"){

            @Override
            public void exec(StringToken cmdLine) throws Exception {
                Monitor.this.checkCPU();
                Monitor.this.checkRunning();
                int till = Monitor.this.cpu.pc() + Monitor.this.cpu.getLenghtAt(Monitor.this.cpu.pc());
                Monitor.this.cpu.setTill(till);
                Monitor.this.from = till;
                Monitor.this.cpu.start();
            }
        });
        this.addCommand(new Command(this, "step", "Exec one istructions"){

            @Override
            public void exec(StringToken cmdLine) throws Exception {
                Monitor.this.checkCPU();
                Monitor.this.checkRunning();
                Monitor.this.cpu.step();
                Monitor.this.showCpu();
                Monitor.this.from = Monitor.this.cpu.pc();
            }
        });
    }

    private void selectCPU() {
        if (this.jmce.cpu == null) {
            return;
        }
        if (this.jmce.cpu instanceof Hardware) {
            this.selectCPU(this.jmce.cpu);
        } else {
            CPU cpu = (CPU)this.jmce.cpu.getHardware(CPU.class);
            this.selectCPU(cpu);
        }
    }

    public void selectCPU(CPU cpu) {
        if (this.cpu != null) {
            this.cpu.removeExceptionListener(this);
        }
        if (cpu != null) {
            cpu.addExceptionListener(this);
        }
        this.cpu = cpu;
    }

    @Override
    public void trace(String s) throws SIMException {
        this.trace.println(s);
    }

    @Override
    public void exceptionEvent(ExceptionEvent ev) {
        this.cpu.stop();
        this.println(ev.toString());
        try {
            this.from = this.cpu.pc();
            this.showCpu();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void showCpu() throws Exception {
        for (int i = 0; i < this.cpu.getRegisterCount(); ++i) {
            if (this.terminal != null && this.terminal.getCol() + 8 > this.terminal.getNumCol()) {
                this.println();
            }
            Register r = this.cpu.getRegisterAt(i);
            this.print(r.getName() + "=" + r.descValue() + " ");
        }
        this.println();
        this.println(this.cpu.decodeAt(this.cpu.pc()));
    }
}

