/*
 * Decompiled with CFR 0.152.
 */
package jmce;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import jmce.PanelDebug;
import jmce.sim.BreakPoint;
import jmce.sim.CPU;
import jmce.sim.Memory;
import jmce.sim.SIMException;
import jmce.swing.KHexField;
import jmce.swing.KMemoryChoice;

class PanelBreak
extends PanelDebug
implements ActionListener {
    private static final long serialVersionUID = 1L;
    public static final int NROW = 8;
    KMemoryChoice[] m = new KMemoryChoice[8];
    KHexField[] a = new KHexField[8];
    KHexField[] value = new KHexField[8];
    JComboBox[] w = new JComboBox[8];
    JCheckBox[] e = new JCheckBox[8];
    BreakPoint[] b = new BreakPoint[8];

    PanelBreak(CPU cpu) {
        super("Break point", cpu);
        for (int i = 0; i < 8; ++i) {
            this.m[i] = new KMemoryChoice(cpu);
            this.a[i] = new KHexField(32);
            this.value[i] = new KHexField(8);
            this.w[i] = new JComboBox();
            this.e[i] = new JCheckBox();
            this.e[i].addActionListener(this);
            this.w[i].addItem("Exec");
            this.w[i].addItem("Read");
            this.w[i].addItem("Write");
            this.a[i].setValue(0);
            this.a[i].setValue(0);
            this.a[i].addActionListener(this);
            this.a[i].setEditable(true);
            this.add((Component)new JLabel("Address"), this.g);
            ++this.g.gridx;
            this.add((Component)this.m[i], this.g);
            ++this.g.gridx;
            this.add((Component)this.a[i], this.g);
            ++this.g.gridx;
            this.add((Component)this.value[i], this.g);
            ++this.g.gridx;
            this.add((Component)new JLabel("Break"), this.g);
            ++this.g.gridx;
            this.add((Component)this.w[i], this.g);
            ++this.g.gridx;
            this.add((Component)this.e[i], this.g);
            ++this.g.gridx;
            this.g.gridx = 0;
            ++this.g.gridy;
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object source = ev.getSource();
        for (int i = 0; i < 8; ++i) {
            if (this.e[i] == source) {
                if (!this.e[i].isSelected()) {
                    this.cpu.removeBreakPoint(this.b[i]);
                    this.b[i] = null;
                    this.setEnabled(i, true);
                } else {
                    this.setEnabled(i, false);
                    int address = this.a[i].getValue();
                    int memory = this.m[i].getSelectedIndex();
                    int type = this.w[i].getSelectedIndex();
                    BreakPoint bp = null;
                    switch (type) {
                        case 0: {
                            bp = this.cpu.addExecBreakPoint(memory, address);
                            break;
                        }
                        case 1: {
                            bp = this.cpu.addReadBreakPoint(memory, address);
                            break;
                        }
                        case 2: {
                            bp = this.cpu.addWriteBreakPoint(memory, address);
                        }
                    }
                    this.b[i] = bp;
                }
            }
            if (this.a[i] != source) continue;
            this.a[i].setValue(this.a[i].getValue());
            this.a[i].setValue(this.a[i].getValue());
            this.update(this.cpu, i);
            break;
        }
    }

    void setEnabled(int i, boolean mode) {
        this.m[i].setEnabled(mode);
        this.w[i].setEnabled(mode);
        this.a[i].setEditable(mode);
    }

    void update(CPU cpu, int i) {
        Memory mem = cpu.getMemoryAt(this.m[i].getSelectedIndex());
        try {
            int add = this.a[i].getValue();
            if (add < 0 || add >= mem.getSize()) {
                this.value[i].setText("??");
            } else {
                int v = mem.getMemory(this.a[i].getValue());
                this.value[i].setValue(v);
            }
        }
        catch (SIMException ex) {
            this.value[i].setText("??");
        }
    }

    @Override
    public void update(CPU cpu) {
        for (int i = 0; i < 8; ++i) {
            this.update(cpu, i);
        }
    }
}

