/*
 * Decompiled with CFR 0.152.
 */
package jmce;

import java.awt.Component;
import java.awt.Insets;
import javax.swing.JLabel;
import jmce.PanelDebug;
import jmce.sim.CPU;
import jmce.sim.Register;
import jmce.swing.KHexField;
import jmce.util.FastArray;

class PanelRegister
extends PanelDebug {
    private static final long serialVersionUID = 1L;
    private FastArray<Register> regs = new FastArray();
    private FastArray<KHexField> values = new FastArray();

    PanelRegister(CPU cpu) {
        super("Register", cpu);
        this.g.insets = new Insets(1, 2, 1, 2);
        for (int i = 0; i < cpu.getRegisterCount(); ++i) {
            Register reg = cpu.getRegisterAt(i);
            KHexField f = new KHexField(reg.getWidth());
            this.regs.add(reg);
            this.values.add(f);
            this.g.gridx = i / 8 * 2;
            this.g.gridy = i % 8;
            this.add((Component)new JLabel(reg.getName()), this.g);
            ++this.g.gridx;
            this.add((Component)f, this.g);
        }
    }

    @Override
    public void setEmulation(boolean mode) {
        for (int i = 0; i < this.regs.getSize(); ++i) {
            KHexField f = this.values.get(i);
            f.setEditable(!mode);
        }
    }

    @Override
    public void update(CPU cpu) {
        for (int i = 0; i < this.regs.getSize(); ++i) {
            Register r = this.regs.get(i);
            KHexField f = this.values.get(i);
            try {
                f.setValue(r.getRegister());
                continue;
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
    }
}

