/*
 * Decompiled with CFR 0.152.
 */
package jmce.altair;

import jmce.altair.Console;
import jmce.altair.Memory;
import jmce.altair.SIMHConstants;
import jmce.sim.AbstractPeripheral;
import jmce.sim.CPU;
import jmce.sim.MemoryReadListener;
import jmce.sim.MemoryWriteListener;
import jmce.sim.SIMException;
import jmce.util.FastArray;
import jmce.util.Hex;
import jmce.util.Logger;
import jmce.util.Timeout;

public class SIMH
extends AbstractPeripheral
implements MemoryReadListener,
MemoryWriteListener,
SIMHConstants {
    private static Logger log = Logger.getLogger(SIMH.class);
    private Timeout sysTime = new Timeout();
    private int lastCommand = -1;
    private FastArray<Timeout> timers = new FastArray();
    private int count;
    private Memory m;
    private Console c;

    public SIMH() {
        this.setName("SIMH");
    }

    @Override
    public void registerCPU(CPU cpu) throws SIMException {
        super.registerCPU(cpu);
        this.m = (Memory)cpu.getHardware(Memory.class);
        this.c = (Console)cpu.getHardware(Console.class);
        cpu.addIOReadListener(254, this);
        cpu.addIOWriteListener(254, this);
    }

    private void print(Object o) throws SIMException {
        String s = String.valueOf(o);
        for (int i = 0; i < s.length(); ++i) {
            this.c.write(Integer.valueOf(s.charAt(i)));
        }
    }

    private void println() throws SIMException {
        this.print("\r\n");
    }

    private void println(Object o) throws SIMException {
        this.print(o);
        this.println();
    }

    @Override
    public int readMemory(jmce.sim.Memory mm, int address, int value) throws SIMException {
        switch (this.lastCommand) {
            default: {
                this.lastCommand = -1;
                break;
            }
            case 13: {
                if (++this.count > 1) {
                    value = 192;
                    this.lastCommand = -1;
                    break;
                }
                value = 0;
                break;
            }
            case 6: {
                if (this.count >= "SIMH003".length()) {
                    value = 0;
                    this.lastCommand = -1;
                    break;
                }
                value = "SIMH003".charAt(this.count++);
                break;
            }
            case 18: {
                value = 16;
                this.lastCommand = -1;
                break;
            }
            case 11: {
                value = this.m.getBank();
                this.lastCommand = -1;
            }
        }
        log.fine("SIMH Read " + Hex.formatByte(address) + " = " + Hex.formatByte(value));
        return value;
    }

    private void newCommand(int value) throws SIMException {
        this.count = 0;
        switch (value) {
            default: {
                log.info("SIMH Unknow CMD=" + Hex.formatByte(value));
                break;
            }
            case 27: {
                this.idle();
                break;
            }
            case 1: {
                Timeout t = new Timeout();
                this.timers.add(t);
                break;
            }
            case 2: {
                if (this.timers.getSize() <= 0) break;
                Timeout t = this.timers.get(this.timers.getSize() - 1);
                this.timers.remove(t);
                this.println("Timer # " + (this.timers.getSize() + 1) + " = " + t.getElapsed() + " ms");
                break;
            }
            case 14: {
                this.resetSimh();
                break;
            }
            case 0: {
                this.println();
                this.println("Current System time is " + this.sysTime.getElapsed() + " ms");
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 18: {
                this.lastCommand = value;
            }
        }
    }

    @Override
    public void writeMemory(jmce.sim.Memory mm, int address, int value, int oldValue) throws SIMException {
        if (this.lastCommand == -1) {
            this.newCommand(value);
            return;
        }
        switch (this.lastCommand) {
            case 12: {
                this.m.setBank(value);
                this.lastCommand = -1;
            }
        }
        log.fine("SIMH Write " + Hex.formatByte(address) + " = " + Hex.formatByte(value));
    }

    public void resetSimh() {
        this.sysTime.restart();
        this.timers.clear();
        this.lastCommand = -1;
    }

    @Override
    public String toString() {
        return "SIMH at 0FE SIMH003";
    }
}

