/*
 * Decompiled with CFR 0.152.
 */
package jmce.commodore.vic20;

import java.awt.event.KeyEvent;
import jmce.mos.VIA6522;
import jmce.sim.CPU;
import jmce.sim.Memory;
import jmce.sim.MemoryWriteListener;
import jmce.sim.SIMException;
import jmce.sim.cpu.Binary;
import jmce.swing.KeyboardMatrix;

public class Keyboard
extends KeyboardMatrix
implements MemoryWriteListener {
    private VIA6522 via2;
    private VIA6522 via1;
    private boolean joystick;
    private boolean up;
    private boolean down;
    private boolean left;
    private boolean right;
    private boolean fire;

    public Keyboard() {
        this.setNumRows(8);
        this.setNumCols(8);
        this.setKey(0, 0, 49, 51, 53, 55, 57, 45, 92, 8);
        this.setKey(1, 0, 37, 87, 82, 89, 73, 80, 91, 10);
        this.setKey(2, 0, 17, 65, 68, 71, 74, 76, 59, 39);
        this.setKey(3, 0, 27, 16, 88, 86, 78, 44, 47, 40);
        this.setKey(4, 0, 32, 90, 67, 66, 77, 46, 16, 112);
        this.setKey(5, 0, 9, 83, 70, 72, 75, 93, 61, 114);
        this.setKey(6, 0, 81, 69, 84, 85, 79, 39, 38, 116);
        this.setKey(7, 0, 50, 52, 54, 56, 48, 96, 36, 118);
        this.setKeyLocation(3, 1, 2);
        this.setKeyLocation(4, 6, 3);
    }

    public void setVia1(VIA6522 via1) {
        this.via1 = via1;
    }

    public void setVia2(VIA6522 via2) {
        this.via2 = via2;
    }

    @Override
    public void registerCPU(CPU cpu) throws SIMException {
        super.registerCPU(cpu);
        this.via2.addPortBWriteListener(this);
    }

    @Override
    public void writeMemory(Memory memory, int address, int value, int oldValue) throws SIMException {
        int row = ~value & 0xFF;
        value = 255;
        for (int i = 0; i < 8; ++i) {
            if ((row & 1 << i) == 0) continue;
            value &= this.getRow(i);
        }
        this.via2.writePortA(value);
    }

    private void updateJoystick() {
        if (this.via1 == null || this.via2 == null) {
            return;
        }
        try {
            Binary b = new Binary(this.via2.readPortB());
            b.setBit(7, !this.right);
            this.via2.writePortB(b.getValue());
            b.setValue(this.via1.readPortA());
            b.setBit(2, !this.up);
            b.setBit(3, !this.down);
            b.setBit(4, !this.left);
            b.setBit(5, !this.fire);
            this.via1.writePortA(b.getValue());
        }
        catch (SIMException sIMException) {
            // empty catch block
        }
    }

    protected void resetJoystick() {
        this.joystick = false;
        this.fire = false;
        this.down = false;
        this.up = false;
        this.right = false;
        this.left = false;
        this.updateJoystick();
    }

    @Override
    public void keyEvent(KeyEvent e, boolean pressed) {
        if (e.getKeyCode() == 18) {
            if (pressed) {
                boolean bl = this.joystick = !this.joystick;
            }
            if (!this.joystick) {
                this.resetJoystick();
            } else {
                this.fire = false;
                this.right = false;
                this.left = false;
                this.down = false;
                this.up = false;
            }
        }
        if (this.joystick) {
            switch (e.getKeyCode()) {
                case 38: {
                    this.up = pressed;
                    break;
                }
                case 40: {
                    this.down = pressed;
                    break;
                }
                case 37: {
                    this.left = pressed;
                    break;
                }
                case 39: {
                    this.right = pressed;
                    break;
                }
                default: {
                    this.fire = pressed;
                }
            }
            this.updateJoystick();
        } else {
            super.keyEvent(e, pressed);
        }
    }

    @Override
    protected void resetKeyboard() {
        super.resetKeyboard();
        this.resetJoystick();
    }
}

